/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.renv;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.springframework.beans.factory.annotation.Autowired;

@WebServlet(urlPatterns={"/renvs"})
@NonNullByDefault
public class REnvsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private REnvManager rEnvManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=30, must-revalidate");
        PrintWriter writer = resp.getWriter();
        writer.write("<html><body>");
        writer.write("<table>");
        writer.write("<tr><th>Id</th><th>Name</th><th>Status</th>");
        for (REnv rEnv : this.rEnvManager.list()) {
            REnvConfiguration config = (REnvConfiguration)rEnv.get(REnvConfiguration.class);
            writer.write("<tr><td>");
            writer.write(rEnv.getId());
            writer.write("</td><td>");
            writer.write(rEnv.getName());
            writer.write("</td><td>");
            if (config != null) {
                writer.write(Statuses.getSeverityString((byte)config.getValidationStatus().getSeverity()));
            } else {
                writer.write("MISSING");
            }
            writer.write("</td></tr>");
        }
        writer.write("</html></body>");
        writer.close();
    }
}

