/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractCharacterStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;

@NonNullByDefault
public abstract class AbstractLogicalStore
extends AbstractRStore<Boolean>
implements RLogicalStore {
    protected static final String toChar(boolean logi) {
        return logi ? "TRUE" : "FALSE";
    }

    @Override
    public final byte getStoreType() {
        return 1;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "logical";
    }

    @Override
    public final int getInt(int idx) {
        return this.getLogi(idx) ? 1 : 0;
    }

    @Override
    public final int getInt(long idx) {
        return this.getLogi(idx) ? 1 : 0;
    }

    @Override
    public final void setInt(int idx, int integer) {
        this.setLogi(idx, integer != 0);
    }

    @Override
    public final void setInt(long idx, int integer) {
        this.setLogi(idx, integer != 0);
    }

    @Override
    public final String getChar(int idx) {
        return AbstractLogicalStore.toChar(this.getLogi(idx));
    }

    @Override
    public final String getChar(long idx) {
        return AbstractLogicalStore.toChar(this.getLogi(idx));
    }

    @Override
    public void setChar(int idx, String character) {
        this.setLogi(idx, AbstractCharacterStore.toLogi(character));
    }

    @Override
    public void setChar(long idx, String character) {
        this.setLogi(idx, AbstractCharacterStore.toLogi(character));
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        try {
            return this.indexOf(AbstractCharacterStore.toLogi(character) ? 1 : 0, fromIdx);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public byte getRaw(int idx) {
        return this.getLogi(idx) ? (byte)1 : 0;
    }

    @Override
    public byte getRaw(long idx) {
        return this.getLogi(idx) ? (byte)1 : 0;
    }

    @Override
    public void setRaw(int idx, byte raw) {
        this.setLogi(idx, raw != 0);
    }

    @Override
    public void setRaw(long idx, byte raw) {
        this.setLogi(idx, raw != 0);
    }

    @Override
    public abstract @Nullable Boolean[] toArray();

    @Override
    public boolean allEqual(RStore<?> other) {
        long length = this.getLength();
        if (1 != other.getStoreType() || length != other.getLength()) {
            return false;
        }
        if (length < 0L) {
            return true;
        }
        if (length <= Integer.MAX_VALUE) {
            int ilength = (int)length;
            int idx = 0;
            while (idx < ilength) {
                if (this.isNA(idx) ? !other.isNA(idx) : this.getLogi(idx) != other.getLogi(idx)) {
                    return false;
                }
                ++idx;
            }
        } else {
            long idx = 0L;
            while (idx < length) {
                if (this.isNA(idx) ? !other.isNA(idx) : this.getLogi(idx) != other.getLogi(idx)) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }
}

