/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class Statuses {
    static final String UNKNOWN_ID = "unknown";
    @Deprecated
    public static final Status OK_STATUS = Status.OK_STATUS;
    @Deprecated
    public static final Status CANCEL_STATUS = Status.CANCEL_STATUS;

    @Deprecated
    public static Status newStatus(int severity, String bundleId, int code, String message, @Nullable Throwable exception) {
        return Status.newStatus(severity, bundleId, code, message, exception);
    }

    @Deprecated
    public static Status newStatus(int severity, String bundleId, String message, @Nullable Throwable exception) {
        return Status.newStatus(severity, bundleId, message, exception);
    }

    @Deprecated
    public static Status newStatus(int severity, String bundleId, String message) {
        return Status.newStatus(severity, bundleId, message);
    }

    public static Status getMoreSevere(Status status1, Status status2) {
        if (status1.getSeverity() > status2.getSeverity()) {
            return status1;
        }
        return status2;
    }

    public static @Nullable Status getMostSevere(List<? extends Status> statuses) {
        Status max = null;
        for (Status status : statuses) {
            if (status.getSeverity() == 4) {
                return status;
            }
            if (max != null && status.getSeverity() < max.getSeverity()) continue;
            max = status;
        }
        return max;
    }

    public static String getSeverityString(byte severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    private Statuses() {
    }
}

