/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.stream.LongStream;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongSingletonList
extends AbstractImLongList {
    private final long e;

    public ImLongSingletonList(long e) {
        this.e = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(long element) {
        return this.e == element;
    }

    @Override
    public long getAt(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e;
    }

    @Override
    public int indexOf(long element) {
        return this.e == element ? 0 : -1;
    }

    @Override
    public int lastIndexOf(long element) {
        return this.e == element ? 0 : -1;
    }

    @Override
    public LongStream stream() {
        return LongStream.of(this.e);
    }

    @Override
    public long[] toArray() {
        return new long[]{this.e};
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 31 * hashCode + Long.hashCode(this.e);
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            return 1 == other.size() && this.e == other.getAt(0);
        }
        return false;
    }

    public String toString() {
        return "[" + this.e + ']';
    }
}

