/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.string.StringFactory;

@NonNullByDefault
public final class BasicStringFactory
implements StringFactory {
    public static final BasicStringFactory INSTANCE = new BasicStringFactory();
    static final int CHARTABLE_SIZE = 256;
    static final @NonNull String[] CHARTABLE = new String[256];

    static {
        char i = '\u0000';
        while (i < '\u0100') {
            BasicStringFactory.CHARTABLE[i] = String.valueOf(i).intern();
            i = (char)(i + '\u0001');
        }
    }

    @Override
    public String get(CharSequence s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.get(s.charAt(0));
            }
        }
        return s.toString();
    }

    @Override
    public String get(CharArrayString s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.get(s.charAt(0));
            }
        }
        return s.toString();
    }

    @Override
    public String get(String s) {
        switch (s.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.get(s.charAt(0), s);
            }
        }
        return s;
    }

    @Override
    public String get(char c) {
        if (c >= '\u0000' && c < '\u0100') {
            return CHARTABLE[c];
        }
        return String.valueOf(c);
    }

    @Override
    public String get(int codepoint) {
        if (codepoint >= 0 && codepoint < 256) {
            return CHARTABLE[codepoint];
        }
        return Character.toString(codepoint);
    }

    private String get(char c, String s) {
        if (c >= '\u0000' && c < '\u0100') {
            return CHARTABLE[c];
        }
        return s;
    }
}

