/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_uk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AUD" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BRL", "BRL" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CAD", "CAD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "CNY", "CNY" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "EUR", "EUR" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GBP", "GBP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HKD", "HKD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILS", "ILS" },
            { "INR", "INR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRW", "KRW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXN", "MXN" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "NZD", "NZD" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PES", "PES" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TWD", "TWD" },
            { "TZS", "TZS" },
            { "UAH", "\u20b4" },
            { "UAK", "\u043a\u0440\u0431." },
            { "UGX", "UGX" },
            { "USD", "USD" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VND", "VND" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XCD", "XCD" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u0430\u043d\u0434\u043e\u0440\u0440\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "aed", "\u0434\u0438\u0440\u0445\u0430\u043c \u041e\u0410\u0415" },
            { "afa", "\u0430\u0444\u0433\u0430\u043d\u0456 (1927\u20132002)" },
            { "afn", "\u0430\u0444\u0433\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0430\u0444\u0433\u0430\u043d\u0456" },
            { "all", "\u0430\u043b\u0431\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u043a" },
            { "amd", "\u0432\u0456\u0440\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0440\u0430\u043c" },
            { "ang", "\u043d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0430\u043d\u0442\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "aoa", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "aok", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 (1977\u20131990)" },
            { "aon", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043d\u043e\u0432\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 (1990\u20132000)" },
            { "aor", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430 \u0440\u0435\u0430\u0434\u0436\u0430\u0441\u0442\u0430\u0434\u043e (1995\u20131999)" },
            { "ara", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u0430\u0432\u0441\u0442\u0440\u0430\u043b" },
            { "arp", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e (1983\u20131985)" },
            { "ars", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "ats", "\u0430\u0432\u0441\u0442\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "aud", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "awg", "\u0430\u0440\u0443\u0431\u0441\u044c\u043a\u0438\u0439 \u0444\u043b\u043e\u0440\u0438\u043d" },
            { "azm", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442 (1993\u20132006)" },
            { "azn", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "bad", "\u0434\u0438\u043d\u0430\u0440 (\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430)" },
            { "bam", "\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0430 \u043c\u0430\u0440\u043a\u0430 \u0411\u043e\u0441\u043d\u0456\u0457 \u0456 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0438" },
            { "bbd", "\u0431\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bdt", "\u0431\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0441\u044c\u043a\u0430 \u0442\u0430\u043a\u0430" },
            { "bec", "\u0431\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439)" },
            { "bef", "\u0431\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bel", "\u0431\u0435\u043b\u044c\u0433\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439)" },
            { "bgl", "\u0431\u043e\u043b\u0433\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0442\u0432\u0435\u0440\u0434\u0438\u0439 \u043b\u0435\u0432" },
            { "bgn", "\u0431\u043e\u043b\u0433\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0432" },
            { "bhd", "\u0431\u0430\u0445\u0440\u0435\u0439\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "bif", "\u0431\u0443\u0440\u0443\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0431\u0435\u0440\u043c\u0443\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bnd", "\u0431\u0440\u0443\u043d\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "bob", "\u0431\u043e\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0456\u0430\u043d\u043e" },
            { "bop", "\u0431\u043e\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e" },
            { "bov", "\u0431\u043e\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043c\u0432\u0434\u043e\u043b" },
            { "brb", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043d\u043e\u0432\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1967\u20131986)" },
            { "brc", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "bre", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1990\u20131993)" },
            { "brl", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0430\u043b" },
            { "brn", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043d\u043e\u0432\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "brr", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0435 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e" },
            { "bsd", "\u0431\u0430\u0433\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "btn", "\u0431\u0443\u0442\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "buk", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0456\u0430\u0442" },
            { "bwp", "\u0431\u043e\u0442\u0441\u0432\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0443\u043b\u0430" },
            { "byb", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1994\u20131999)" },
            { "byn", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "byr", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (2000\u20132016)" },
            { "bzd", "\u0431\u0435\u043b\u0456\u0437\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "cad", "\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "cdf", "\u043a\u043e\u043d\u0433\u043e\u043b\u0435\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "che", "\u0454\u0432\u0440\u043e WIR" },
            { "chf", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "chw", "\u0444\u0440\u0430\u043d\u043a WIR" },
            { "clf", "\u0447\u0438\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434\u0435\u0441 \u0434\u0435 \u0444\u043e\u043c\u0435\u043d\u0442\u043e" },
            { "clp", "\u0447\u0438\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cnh", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043e\u0444\u0448\u043e\u0440\u043d\u0438\u0439 \u044e\u0430\u043d\u044c" },
            { "cny", "\u043a\u0438\u0442\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u044e\u0430\u043d\u044c" },
            { "cop", "\u043a\u043e\u043b\u0443\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cou", "\u043e\u0434\u0438\u043d\u0438\u0446\u044f \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0457 \u0432\u0430\u0440\u0442\u043e\u0441\u0442\u0456" },
            { "crc", "\u043a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "csd", "\u0441\u0442\u0430\u0440\u0438\u0439 \u0441\u0435\u0440\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "csk", "\u0447\u0435\u0445\u043e\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430 \u0442\u0432\u0435\u0440\u0434\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "cuc", "\u043a\u0443\u0431\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cup", "\u043a\u0443\u0431\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cve", "\u0435\u0441\u043a\u0443\u0434\u043e \u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "cyp", "\u043a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "czk", "\u0447\u0435\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "ddm", "\u043c\u0430\u0440\u043a\u0430 \u041d\u0414\u0420" },
            { "dem", "\u043d\u0456\u043c\u0435\u0446\u044c\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "djf", "\u0434\u0436\u0438\u0431\u0443\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "dkk", "\u0434\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "dop", "\u0434\u043e\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "dzd", "\u0430\u043b\u0436\u0438\u0440\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "ecs", "\u0435\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0441\u0443\u043a\u0440\u0435" },
            { "ecv", "\u0435\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434 \u0434\u0435 \u0432\u0430\u043b\u043e\u0440 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0435" },
            { "eek", "\u0435\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "egp", "\u0454\u0433\u0438\u043f\u0435\u0442\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ern", "\u0435\u0440\u0438\u0442\u0440\u0435\u0439\u0441\u044c\u043a\u0430 \u043d\u0430\u043a\u0444\u0430" },
            { "esa", "\u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430 (\"\u0410\" \u0440\u0430\u0445\u0443\u043d\u043e\u043a)" },
            { "esb", "\u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430 (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0456 \u0440\u0430\u0445\u0443\u043d\u043a\u0438)" },
            { "esp", "\u0456\u0441\u043f\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "etb", "\u0435\u0444\u0456\u043e\u043f\u0441\u044c\u043a\u0438\u0439 \u0431\u0438\u0440" },
            { "eur", "\u0454\u0432\u0440\u043e" },
            { "fim", "\u0444\u0456\u043d\u043b\u044f\u043d\u0434\u0441\u044c\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "fjd", "\u0444\u0456\u0434\u0436\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "fkp", "\u0444\u0443\u043d\u0442 \u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u0456\u0432" },
            { "frf", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gbp", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "gek", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0443\u043f\u043e\u043d" },
            { "gel", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0430\u0440\u0456" },
            { "ghc", "\u0433\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u0435\u0434\u0456 (1979\u20132007)" },
            { "ghs", "\u0433\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u0435\u0434\u0456" },
            { "gip", "\u0433\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "gmd", "\u0433\u0430\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u0430\u043b\u0430\u0441\u0456" },
            { "gnf", "\u0433\u0432\u0456\u043d\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gns", "\u0433\u0432\u0456\u043d\u0435\u0439\u0441\u044c\u043a\u0435 \u0441\u0456\u043b\u0456" },
            { "gqe", "\u0435\u043a\u0432\u0435\u043b\u0435 (\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0456\u0430\u043b\u044c\u043d\u0430 \u0490\u0432\u0456\u043d\u0435\u044f)" },
            { "grd", "\u0433\u0440\u0435\u0446\u044c\u043a\u0430 \u0434\u0440\u0430\u0445\u043c\u0430" },
            { "gtq", "\u0433\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u043a\u0435\u0442\u0441\u0430\u043b\u044c" },
            { "gwe", "\u0435\u0441\u043a\u0443\u0434\u043e \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u043e\u0457 \u0433\u0432\u0456\u043d\u0435\u0457" },
            { "gwp", "\u043f\u0435\u0441\u043e \u0413\u0432\u0456\u043d\u0435\u0457-\u0411\u0456\u0441\u0430\u0443" },
            { "gyd", "\u0433\u0430\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "hkd", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "hnl", "\u0433\u043e\u043d\u0434\u0443\u0440\u0430\u0441\u044c\u043a\u0430 \u043b\u0435\u043c\u043f\u0456\u0440\u0430" },
            { "hrd", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "hrk", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0430 \u043a\u0443\u043d\u0430" },
            { "htg", "\u0433\u0430\u0457\u0442\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u0440\u0434" },
            { "huf", "\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u043e\u0440\u0438\u043d\u0442" },
            { "idr", "\u0456\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "iep", "\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ilp", "\u0456\u0437\u0440\u0430\u0457\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ils", "\u0456\u0437\u0440\u0430\u0457\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0448\u0435\u043a\u0435\u043b\u044c" },
            { "inr", "\u0456\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "iqd", "\u0456\u0440\u0430\u043a\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "irr", "\u0456\u0440\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "isk", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "itl", "\u0456\u0442\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "jmd", "\u044f\u043c\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "jod", "\u0439\u043e\u0440\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "jpy", "\u044f\u043f\u043e\u043d\u0441\u044c\u043a\u0430 \u0454\u043d\u0430" },
            { "kes", "\u043a\u0435\u043d\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "kgs", "\u043a\u0438\u0440\u0433\u0438\u0437\u044c\u043a\u0438\u0439 \u0441\u043e\u043c" },
            { "khr", "\u043a\u0430\u043c\u0431\u043e\u0434\u0436\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0454\u043b\u044c" },
            { "kmf", "\u043a\u043e\u043c\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0432\u043e\u043d" },
            { "krw", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u044c\u043a\u0438\u0439 \u0432\u043e\u043d" },
            { "kwd", "\u043a\u0443\u0432\u0435\u0439\u0442\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "kyd", "\u0434\u043e\u043b\u0430\u0440 \u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u0456\u0432" },
            { "kzt", "\u043a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0442\u0435\u043d\u0433\u0435" },
            { "lak", "\u043b\u0430\u043e\u0441\u044c\u043a\u0438\u0439 \u043a\u0456\u043f" },
            { "lbp", "\u043b\u0456\u0432\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "lkr", "\u0448\u0440\u0456-\u043b\u0430\u043d\u043a\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "lrd", "\u043b\u0456\u0431\u0435\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "lsl", "\u043b\u0435\u0441\u043e\u0442\u0441\u044c\u043a\u0438\u0439 \u043b\u043e\u0442\u0456" },
            { "ltl", "\u043b\u0438\u0442\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u043b\u0456\u0442" },
            { "ltt", "\u043b\u0438\u0442\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u0442\u0430\u043b\u043e\u043d" },
            { "luc", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0491\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439)" },
            { "luf", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "lul", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0491\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439)" },
            { "lvl", "\u043b\u0430\u0442\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u043b\u0430\u0442" },
            { "lvr", "\u043b\u0430\u0442\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "lyd", "\u043b\u0456\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "mad", "\u043c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u0440\u0445\u0430\u043c" },
            { "maf", "\u043c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mdl", "\u043c\u043e\u043b\u0434\u043e\u0432\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "mga", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0430\u0440\u0456\u0430\u0440\u0456" },
            { "mgf", "\u043c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mkd", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0435\u043d\u0430\u0440" },
            { "mlf", "\u043c\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mmk", "\u043a\u02bc\u044f\u0442 \u041c\u02bc\u044f\u043d\u043c\u0438" },
            { "mnt", "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0442\u0443\u0433\u0440\u0438\u043a" },
            { "mop", "\u043f\u0430\u0442\u0430\u043a\u0430 \u041c\u0430\u043a\u0430\u043e" },
            { "mro", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0443\u0433\u0456\u044f (1973\u20132017)" },
            { "mru", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0443\u0433\u0456\u044f" },
            { "mtl", "\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "mtp", "\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "mur", "\u043c\u0430\u0432\u0440\u0438\u043a\u0456\u0439\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "mvr", "\u043c\u0430\u043b\u044c\u0434\u0456\u0432\u0441\u044c\u043a\u0430 \u0440\u0443\u0444\u0456\u044f" },
            { "mwk", "\u043c\u0430\u043b\u0430\u0432\u0456\u0439\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u0447\u0430" },
            { "mxn", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "mxp", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0435 \u0441\u0440\u0456\u0431\u043d\u0435 \u043f\u0435\u0441\u043e (1861\u20131992)" },
            { "mxv", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u044e\u043d\u0456\u0434\u0430\u0434 \u0434\u0435 \u0456\u043d\u0432\u0435\u0440\u0441\u0456\u043e\u043d" },
            { "myr", "\u043c\u0430\u043b\u0430\u0439\u0437\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0438\u043d\u0433\u0456\u0442" },
            { "mze", "\u043c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "mzm", "\u0441\u0442\u0430\u0440\u0438\u0439 \u043c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "mzn", "\u043c\u043e\u0437\u0430\u043c\u0431\u0456\u0446\u044c\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "nad", "\u043d\u0430\u043c\u0456\u0431\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "ngn", "\u043d\u0456\u0433\u0435\u0440\u0456\u0439\u0441\u044c\u043a\u0430 \u043d\u0430\u0439\u0440\u0430" },
            { "nic", "\u043d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430 (1988\u20131991)" },
            { "nio", "\u043d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u044c\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430" },
            { "nlg", "\u043d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "nok", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "npr", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "nzd", "\u043d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "omr", "\u043e\u043c\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "pab", "\u043f\u0430\u043d\u0430\u043c\u0441\u044c\u043a\u0435 \u0431\u0430\u043b\u044c\u0431\u043e\u0430" },
            { "pei", "\u043f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0456\u043d\u0442\u0456" },
            { "pen", "\u043f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0441\u043e\u043b" },
            { "pes", "\u043f\u0435\u0440\u0443\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0441\u043e\u043b (1863\u20131965)" },
            { "pgk", "\u043a\u0456\u043d\u0430 \u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u043e\u0457 \u0490\u0432\u0456\u043d\u0435\u0457" },
            { "php", "\u0444\u0456\u043b\u0456\u043f\u043f\u0456\u043d\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "pkr", "\u043f\u0430\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "pln", "\u043f\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u0438\u0439" },
            { "plz", "\u043f\u043e\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u0438\u0439 (1950\u20131995)" },
            { "pte", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "pyg", "\u043f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "qar", "\u043a\u0430\u0442\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "rhd", "\u0440\u043e\u0434\u0435\u0437\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "rol", "\u0441\u0442\u0430\u0440\u0438\u0439 \u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "ron", "\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "rsd", "\u0441\u0435\u0440\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "rub", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "rur", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1991\u20131998)" },
            { "rwf", "\u0440\u0443\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "sar", "\u0441\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "sbd", "\u0434\u043e\u043b\u0430\u0440 \u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0438\u0445 \u041e\u0441\u0442\u0440\u043e\u0432\u0456\u0432" },
            { "scr", "\u0441\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u044c\u043a\u0430 \u0440\u0443\u043f\u0456\u044f" },
            { "sdd", "\u0441\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "sdg", "\u0441\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sdp", "\u0441\u0442\u0430\u0440\u0438\u0439 \u0441\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sek", "\u0448\u0432\u0435\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sgd", "\u0441\u0456\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "shp", "\u0444\u0443\u043d\u0442 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u0432\u044f\u0442\u043e\u0457 \u0404\u043b\u0435\u043d\u0438" },
            { "sit", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0442\u043e\u043b\u0430\u0440" },
            { "skk", "\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sll", "\u043b\u0435\u043e\u043d\u0435 \u0421\u044c\u0454\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "sos", "\u0441\u043e\u043c\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "srd", "\u0441\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "srg", "\u0441\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "ssp", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0441\u0443\u0434\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "std", "\u0434\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0456\u043d\u0441\u0456\u043f\u0456 (1977\u20132017)" },
            { "stn", "\u0434\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0456\u043d\u0441\u0456\u043f\u0456" },
            { "sur", "\u0440\u0430\u0434\u044f\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "svc", "\u0441\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "syp", "\u0441\u0438\u0440\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "szl", "\u0441\u0432\u0430\u0437\u0456\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u043b\u0456\u043b\u0430\u043d\u0433\u0435\u043d\u0456" },
            { "thb", "\u0442\u0430\u0457\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0439 \u0431\u0430\u0442" },
            { "tjr", "\u0442\u0430\u0434\u0436\u0438\u0446\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "tjs", "\u0442\u0430\u0434\u0436\u0438\u0446\u044c\u043a\u0438\u0439 \u0441\u043e\u043c\u043e\u043d\u0456" },
            { "tmm", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442 (1993\u20132009)" },
            { "tmt", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0442\u0443\u043d\u0456\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "top", "\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u044c\u043a\u0430 \u043f\u0430\u0430\u043d\u0433\u0430" },
            { "tpe", "\u0442\u0456\u043c\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "trl", "\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0430 \u043b\u0456\u0440\u0430 (1922\u20132005)" },
            { "try", "\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0430 \u043b\u0456\u0440\u0430" },
            { "ttd", "\u0434\u043e\u043b\u0430\u0440 \u0422\u0440\u0438\u043d\u0456\u0434\u0430\u0434\u0443 \u0456 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "twd", "\u043d\u043e\u0432\u0438\u0439 \u0442\u0430\u0439\u0432\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "tzs", "\u0442\u0430\u043d\u0437\u0430\u043d\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "uah", "\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 \u0433\u0440\u0438\u0432\u043d\u044f" },
            { "uak", "\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439 \u043a\u0430\u0440\u0431\u043e\u0432\u0430\u043d\u0435\u0446\u044c" },
            { "ugs", "\u0443\u0433\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433 (1966\u20131987)" },
            { "ugx", "\u0443\u0433\u0430\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0448\u0438\u043b\u0456\u043d\u0433" },
            { "usd", "\u0434\u043e\u043b\u0430\u0440 \u0421\u0428\u0410" },
            { "usn", "\u0434\u043e\u043b\u0430\u0440 \u0421\u0428\u0410 (\u043d\u0430\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u0434\u043d\u044f)" },
            { "uss", "\u0434\u043e\u043b\u0430\u0440 \u0421\u0428\u0410 (\u0446\u044c\u043e\u0433\u043e \u0434\u043d\u044f)" },
            { "uyi", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e \u0432 \u0456\u043d\u0434\u0435\u043a\u0441\u043e\u0432\u0430\u043d\u0438\u0445 \u043e\u0434\u0438\u043d\u0438\u0446\u044f\u0445" },
            { "uyp", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0435 \u043f\u0435\u0441\u043e (1975\u20131993)" },
            { "uyu", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u044c\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "uzs", "\u0443\u0437\u0431\u0435\u0446\u044c\u043a\u0438\u0439 \u0441\u0443\u043c" },
            { "veb", "\u0432\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0430\u0440 (1871\u20132008)" },
            { "vef", "\u0432\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0430\u0440 (2008\u20132018)" },
            { "ves", "\u0432\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0431\u043e\u043b\u0456\u0432\u0430\u0440" },
            { "vnd", "\u0432\u02bc\u0454\u0442\u043d\u0430\u043c\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0432\u0430\u043d\u0443\u0430\u0442\u0441\u044c\u043a\u0438\u0439 \u0432\u0430\u0442\u0443" },
            { "wst", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u044c\u043a\u0430 \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xag", "\u0441\u0440\u0456\u0431\u043b\u043e" },
            { "xau", "\u0437\u043e\u043b\u043e\u0442\u043e" },
            { "xba", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0441\u043a\u043b\u0430\u0434\u0435\u043d\u0430 \u0432\u0430\u043b\u044e\u0442\u043d\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "xbb", "\u043e\u0434\u0438\u043d\u0438\u0446\u044f \u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u043e\u0433\u043e \u0432\u0430\u043b\u044e\u0442\u043d\u043e\u0433\u043e \u0444\u043e\u043d\u0434\u0443" },
            { "xbc", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0440\u043e\u0437\u0440\u0430\u0445\u0443\u043d\u043a\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f XBC" },
            { "xbd", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0440\u043e\u0437\u0440\u0430\u0445\u0443\u043d\u043a\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f XBD" },
            { "xcd", "\u0441\u0445\u0456\u0434\u043d\u043e\u043a\u0430\u0440\u0438\u0431\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "xdr", "\u0441\u043f\u0435\u0446\u0456\u0430\u043b\u044c\u043d\u0456 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u043f\u043e\u0437\u0438\u0447\u0435\u043d\u043d\u044f" },
            { "xeu", "\u0454\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u044c\u043a\u0430 \u0432\u0430\u043b\u044e\u0442\u043d\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "xfo", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0437\u043e\u043b\u043e\u0442\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xfu", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a UIC" },
            { "xof", "\u0437\u0430\u0445\u0456\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xpd", "\u043f\u0430\u043b\u0430\u0434\u0456\u0439" },
            { "xpf", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0438\u0439 \u0442\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xpt", "\u043f\u043b\u0430\u0442\u0438\u043d\u0430" },
            { "xre", "\u0444\u043e\u043d\u0434\u0438 RINET" },
            { "xts", "\u043a\u043e\u0434 \u0442\u0435\u0441\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0432\u0430\u043b\u044e\u0442\u0438" },
            { "xxx", "\u043d\u0435\u0432\u0456\u0434\u043e\u043c\u0430 \u0433\u0440\u043e\u0448\u043e\u0432\u0430 \u043e\u0434\u0438\u043d\u0438\u0446\u044f" },
            { "ydd", "\u0454\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yer", "\u0454\u043c\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0456\u0430\u043b" },
            { "yud", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u0442\u0432\u0435\u0440\u0434\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yum", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yun", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "zal", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0444\u0456\u043d\u0430\u043d\u0441\u043e\u0432\u0438\u0439 \u0440\u0430\u043d\u0434" },
            { "zar", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0438\u0439 \u0440\u0430\u043d\u0434" },
            { "zmk", "\u0437\u0430\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u0447\u0430 (1968\u20132012)" },
            { "zmw", "\u0437\u0430\u043c\u0431\u0456\u0439\u0441\u044c\u043a\u0430 \u043a\u0432\u0430\u0447\u0430" },
            { "zrn", "\u0437\u0430\u0457\u0440\u0441\u044c\u043a\u0438\u0439 \u043d\u043e\u0432\u0438\u0439 \u0437\u0430\u0457\u0440" },
            { "zrz", "\u0437\u0430\u0457\u0440\u0441\u044c\u043a\u0438\u0439 \u0437\u0430\u0457\u0440" },
            { "zwd", "\u0437\u0456\u043c\u0431\u0430\u0431\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440" },
            { "zwl", "\u0437\u0456\u043c\u0431\u0430\u0431\u0432\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440 (2009)" },
        };
        return data;
    }
}
