/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public enum TokenType {
    PACKAGE("namespace"),
    CLASS("class"),
    INTERFACE("interface"),
    ENUM("enum"),
    ENUM_MEMBER("enumMember"),
    TYPE("type"),
    TYPE_PARAMETER("typeParameter"),
    ANNOTATION("annotation"),
    ANNOTATION_MEMBER("annotationMember"),
    METHOD("function"),
    PROPERTY("property"),
    VARIABLE("variable"),
    PARAMETER("parameter"),
    MODIFIER("modifier");

    private String genericName;

    private TokenType(String genericName) {
        this.genericName = genericName;
    }

    public String toString() {
        return this.genericName;
    }

    public static TokenType getApplicableType(IBinding binding) {
        if (binding == null) {
            return null;
        }
        switch (binding.getKind()) {
            case 3: {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (variableBinding.isEnumConstant()) {
                    return ENUM_MEMBER;
                }
                if (variableBinding.isField()) {
                    return PROPERTY;
                }
                if (variableBinding.isParameter()) {
                    return PARAMETER;
                }
                return VARIABLE;
            }
            case 4: {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                if (methodBinding.isAnnotationMember()) {
                    return ANNOTATION_MEMBER;
                }
                return METHOD;
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isTypeVariable()) {
                    return TYPE_PARAMETER;
                }
                if (typeBinding.isAnnotation()) {
                    return ANNOTATION;
                }
                if (typeBinding.isClass()) {
                    return CLASS;
                }
                if (typeBinding.isInterface()) {
                    return INTERFACE;
                }
                if (typeBinding.isEnum()) {
                    return ENUM;
                }
                return TYPE;
            }
            case 1: {
                return PACKAGE;
            }
        }
        return null;
    }
}

