"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var temp = require("temp");
var Path = require("path");
var stage_1 = require("./stage");
var chai_1 = require("chai");
var status_1 = require("./status");
var commit_1 = require("./commit");
var log_1 = require("./log");
var test_helper_1 = require("./test-helper");
var track = temp.track();
describe('log', function () { return __awaiter(_this, void 0, void 0, function () {
    var _this = this;
    return __generator(this, function (_a) {
        after(function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                return [2 /*return*/];
            });
        }); });
        it('logCommitSHAs', function () { return __awaiter(_this, void 0, void 0, function () {
            var repositoryPath, fileName, _a, _b, _c, _d, _e, _f, _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        repositoryPath = track.mkdirSync('test-repo-path');
                        return [4 /*yield*/, test_helper_1.createTestRepository(repositoryPath)];
                    case 1:
                        _h.sent();
                        fileName = Path.join(repositoryPath, 'A.txt');
                        _a = chai_1.expect;
                        return [4 /*yield*/, log_1.logCommitSHAs(repositoryPath, fileName)];
                    case 2:
                        _a.apply(void 0, [_h.sent()]).to.be.lengthOf(1);
                        fs.writeFileSync(fileName, 'second commit', { encoding: 'utf8' });
                        chai_1.expect(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('second commit');
                        return [4 /*yield*/, stage_1.stage(repositoryPath, fileName)];
                    case 3:
                        _h.sent();
                        _b = chai_1.expect;
                        return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                    case 4:
                        _b.apply(void 0, [(_h.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.lengthOf(1);
                        return [4 /*yield*/, commit_1.createCommit(repositoryPath, 'second')];
                    case 5:
                        _h.sent();
                        _c = chai_1.expect;
                        return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                    case 6:
                        _c.apply(void 0, [(_h.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.empty;
                        _d = chai_1.expect;
                        return [4 /*yield*/, log_1.logCommitSHAs(repositoryPath, fileName)];
                    case 7:
                        _d.apply(void 0, [_h.sent()]).to.be.lengthOf(2);
                        fs.writeFileSync(fileName, 'third commit', { encoding: 'utf8' });
                        chai_1.expect(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('third commit');
                        return [4 /*yield*/, stage_1.stage(repositoryPath, fileName)];
                    case 8:
                        _h.sent();
                        _e = chai_1.expect;
                        return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                    case 9:
                        _e.apply(void 0, [(_h.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.lengthOf(1);
                        return [4 /*yield*/, commit_1.createCommit(repositoryPath, 'third')];
                    case 10:
                        _h.sent();
                        _f = chai_1.expect;
                        return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                    case 11:
                        _f.apply(void 0, [(_h.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.empty;
                        _g = chai_1.expect;
                        return [4 /*yield*/, log_1.logCommitSHAs(repositoryPath, fileName)];
                    case 12:
                        _g.apply(void 0, [_h.sent()]).to.be.lengthOf(3);
                        return [2 /*return*/];
                }
            });
        }); });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=log.spec.js.map