"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorRegistry = exports.Color = void 0;
const inversify_1 = require("inversify");
const disposable_1 = require("../common/disposable");
const event_1 = require("../common/event");
var Color;
(function (Color) {
    function rgba(r, g, b, a = 1) {
        return { r, g, b, a };
    }
    Color.rgba = rgba;
    function hsla(h, s, l, a = 1) {
        return { h, s, l, a };
    }
    Color.hsla = hsla;
    Color.white = rgba(255, 255, 255, 1);
    Color.black = rgba(0, 0, 0, 1);
    function transparent(v, f) {
        return { v, f, kind: 'transparent' };
    }
    Color.transparent = transparent;
    function lighten(v, f) {
        return { v, f, kind: 'lighten' };
    }
    Color.lighten = lighten;
    function darken(v, f) {
        return { v, f, kind: 'darken' };
    }
    Color.darken = darken;
})(Color = exports.Color || (exports.Color = {}));
/**
 * It should be implemented by an extension, e.g. by the monaco extension.
 */
let ColorRegistry = class ColorRegistry {
    constructor() {
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    fireDidChange() {
        this.onDidChangeEmitter.fire(undefined);
    }
    *getColors() { }
    getCurrentCssVariable(id) {
        const value = this.getCurrentColor(id);
        if (!value) {
            return undefined;
        }
        const name = this.toCssVariableName(id);
        return { name, value };
    }
    toCssVariableName(id, prefix = 'theia') {
        return `--${prefix}-${id.replace(/\./g, '-')}`;
    }
    getCurrentColor(id) {
        return undefined;
    }
    register(...definitions) {
        const result = new disposable_1.DisposableCollection(...definitions.map(definition => this.doRegister(definition)));
        this.fireDidChange();
        return result;
    }
    doRegister(definition) {
        return disposable_1.Disposable.NULL;
    }
};
ColorRegistry = __decorate([
    inversify_1.injectable()
], ColorRegistry);
exports.ColorRegistry = ColorRegistry;
//# sourceMappingURL=color-registry.js.map