/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
export var Iterable;
(function (Iterable) {
    function is(thing) {
        return thing && typeof thing === 'object' && typeof thing[Symbol.iterator] === 'function';
    }
    Iterable.is = is;
    var _empty = Object.freeze([]);
    function empty() {
        return _empty;
    }
    Iterable.empty = empty;
    function single(element) {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, element];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }
    Iterable.single = single;
    function from(iterable) {
        return iterable || _empty;
    }
    Iterable.from = from;
    function isEmpty(iterable) {
        return !iterable || iterable[Symbol.iterator]().next().done === true;
    }
    Iterable.isEmpty = isEmpty;
    function first(iterable) {
        return iterable[Symbol.iterator]().next().value;
    }
    Iterable.first = first;
    function some(iterable, predicate) {
        var e_1, _a;
        try {
            for (var iterable_1 = __values(iterable), iterable_1_1 = iterable_1.next(); !iterable_1_1.done; iterable_1_1 = iterable_1.next()) {
                var element = iterable_1_1.value;
                if (predicate(element)) {
                    return true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterable_1_1 && !iterable_1_1.done && (_a = iterable_1.return)) _a.call(iterable_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return false;
    }
    Iterable.some = some;
    function find(iterable, predicate) {
        var e_2, _a;
        try {
            for (var iterable_2 = __values(iterable), iterable_2_1 = iterable_2.next(); !iterable_2_1.done; iterable_2_1 = iterable_2.next()) {
                var element = iterable_2_1.value;
                if (predicate(element)) {
                    return element;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (iterable_2_1 && !iterable_2_1.done && (_a = iterable_2.return)) _a.call(iterable_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return undefined;
    }
    Iterable.find = find;
    function filter(iterable, predicate) {
        var iterable_3, iterable_3_1, element, e_3_1;
        var e_3, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 5, 6, 7]);
                    iterable_3 = __values(iterable), iterable_3_1 = iterable_3.next();
                    _b.label = 1;
                case 1:
                    if (!!iterable_3_1.done) return [3 /*break*/, 4];
                    element = iterable_3_1.value;
                    if (!predicate(element)) return [3 /*break*/, 3];
                    return [4 /*yield*/, element];
                case 2:
                    _b.sent();
                    _b.label = 3;
                case 3:
                    iterable_3_1 = iterable_3.next();
                    return [3 /*break*/, 1];
                case 4: return [3 /*break*/, 7];
                case 5:
                    e_3_1 = _b.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 7];
                case 6:
                    try {
                        if (iterable_3_1 && !iterable_3_1.done && (_a = iterable_3.return)) _a.call(iterable_3);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    }
    Iterable.filter = filter;
    function map(iterable, fn) {
        var iterable_4, iterable_4_1, element, e_4_1;
        var e_4, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 5, 6, 7]);
                    iterable_4 = __values(iterable), iterable_4_1 = iterable_4.next();
                    _b.label = 1;
                case 1:
                    if (!!iterable_4_1.done) return [3 /*break*/, 4];
                    element = iterable_4_1.value;
                    return [4 /*yield*/, fn(element)];
                case 2:
                    _b.sent();
                    _b.label = 3;
                case 3:
                    iterable_4_1 = iterable_4.next();
                    return [3 /*break*/, 1];
                case 4: return [3 /*break*/, 7];
                case 5:
                    e_4_1 = _b.sent();
                    e_4 = { error: e_4_1 };
                    return [3 /*break*/, 7];
                case 6:
                    try {
                        if (iterable_4_1 && !iterable_4_1.done && (_a = iterable_4.return)) _a.call(iterable_4);
                    }
                    finally { if (e_4) throw e_4.error; }
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    }
    Iterable.map = map;
    function concat() {
        var _i, iterables_1, iterables_1_1, iterable, iterable_5, iterable_5_1, element, e_5_1, e_6_1;
        var e_6, _a, e_5, _b;
        var iterables = [];
        for (_i = 0; _i < arguments.length; _i++) {
            iterables[_i] = arguments[_i];
        }
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _c.trys.push([0, 11, 12, 13]);
                    iterables_1 = __values(iterables), iterables_1_1 = iterables_1.next();
                    _c.label = 1;
                case 1:
                    if (!!iterables_1_1.done) return [3 /*break*/, 10];
                    iterable = iterables_1_1.value;
                    _c.label = 2;
                case 2:
                    _c.trys.push([2, 7, 8, 9]);
                    iterable_5 = (e_5 = void 0, __values(iterable)), iterable_5_1 = iterable_5.next();
                    _c.label = 3;
                case 3:
                    if (!!iterable_5_1.done) return [3 /*break*/, 6];
                    element = iterable_5_1.value;
                    return [4 /*yield*/, element];
                case 4:
                    _c.sent();
                    _c.label = 5;
                case 5:
                    iterable_5_1 = iterable_5.next();
                    return [3 /*break*/, 3];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_5_1 = _c.sent();
                    e_5 = { error: e_5_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (iterable_5_1 && !iterable_5_1.done && (_b = iterable_5.return)) _b.call(iterable_5);
                    }
                    finally { if (e_5) throw e_5.error; }
                    return [7 /*endfinally*/];
                case 9:
                    iterables_1_1 = iterables_1.next();
                    return [3 /*break*/, 1];
                case 10: return [3 /*break*/, 13];
                case 11:
                    e_6_1 = _c.sent();
                    e_6 = { error: e_6_1 };
                    return [3 /*break*/, 13];
                case 12:
                    try {
                        if (iterables_1_1 && !iterables_1_1.done && (_a = iterables_1.return)) _a.call(iterables_1);
                    }
                    finally { if (e_6) throw e_6.error; }
                    return [7 /*endfinally*/];
                case 13: return [2 /*return*/];
            }
        });
    }
    Iterable.concat = concat;
    function concatNested(iterables) {
        var iterables_2, iterables_2_1, iterable, iterable_6, iterable_6_1, element, e_7_1, e_8_1;
        var e_8, _a, e_7, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _c.trys.push([0, 11, 12, 13]);
                    iterables_2 = __values(iterables), iterables_2_1 = iterables_2.next();
                    _c.label = 1;
                case 1:
                    if (!!iterables_2_1.done) return [3 /*break*/, 10];
                    iterable = iterables_2_1.value;
                    _c.label = 2;
                case 2:
                    _c.trys.push([2, 7, 8, 9]);
                    iterable_6 = (e_7 = void 0, __values(iterable)), iterable_6_1 = iterable_6.next();
                    _c.label = 3;
                case 3:
                    if (!!iterable_6_1.done) return [3 /*break*/, 6];
                    element = iterable_6_1.value;
                    return [4 /*yield*/, element];
                case 4:
                    _c.sent();
                    _c.label = 5;
                case 5:
                    iterable_6_1 = iterable_6.next();
                    return [3 /*break*/, 3];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_7_1 = _c.sent();
                    e_7 = { error: e_7_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (iterable_6_1 && !iterable_6_1.done && (_b = iterable_6.return)) _b.call(iterable_6);
                    }
                    finally { if (e_7) throw e_7.error; }
                    return [7 /*endfinally*/];
                case 9:
                    iterables_2_1 = iterables_2.next();
                    return [3 /*break*/, 1];
                case 10: return [3 /*break*/, 13];
                case 11:
                    e_8_1 = _c.sent();
                    e_8 = { error: e_8_1 };
                    return [3 /*break*/, 13];
                case 12:
                    try {
                        if (iterables_2_1 && !iterables_2_1.done && (_a = iterables_2.return)) _a.call(iterables_2);
                    }
                    finally { if (e_8) throw e_8.error; }
                    return [7 /*endfinally*/];
                case 13: return [2 /*return*/];
            }
        });
    }
    Iterable.concatNested = concatNested;
    function reduce(iterable, reducer, initialValue) {
        var e_9, _a;
        var value = initialValue;
        try {
            for (var iterable_7 = __values(iterable), iterable_7_1 = iterable_7.next(); !iterable_7_1.done; iterable_7_1 = iterable_7.next()) {
                var element = iterable_7_1.value;
                value = reducer(value, element);
            }
        }
        catch (e_9_1) { e_9 = { error: e_9_1 }; }
        finally {
            try {
                if (iterable_7_1 && !iterable_7_1.done && (_a = iterable_7.return)) _a.call(iterable_7);
            }
            finally { if (e_9) throw e_9.error; }
        }
        return value;
    }
    Iterable.reduce = reduce;
    /**
     * Returns an iterable slice of the array, with the same semantics as `array.slice()`.
     */
    function slice(arr, from, to) {
        if (to === void 0) { to = arr.length; }
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (from < 0) {
                        from += arr.length;
                    }
                    if (to < 0) {
                        to += arr.length;
                    }
                    else if (to > arr.length) {
                        to = arr.length;
                    }
                    _a.label = 1;
                case 1:
                    if (!(from < to)) return [3 /*break*/, 4];
                    return [4 /*yield*/, arr[from]];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    from++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    }
    Iterable.slice = slice;
    /**
     * Consumes `atMost` elements from iterable and returns the consumed elements,
     * and an iterable for the rest of the elements.
     */
    function consume(iterable, atMost) {
        var _a;
        if (atMost === void 0) { atMost = Number.POSITIVE_INFINITY; }
        var consumed = [];
        if (atMost === 0) {
            return [consumed, iterable];
        }
        var iterator = iterable[Symbol.iterator]();
        for (var i = 0; i < atMost; i++) {
            var next = iterator.next();
            if (next.done) {
                return [consumed, Iterable.empty()];
            }
            consumed.push(next.value);
        }
        return [consumed, (_a = {}, _a[Symbol.iterator] = function () { return iterator; }, _a)];
    }
    Iterable.consume = consume;
    /**
     * Returns whether the iterables are the same length and all items are
     * equal using the comparator function.
     */
    function equals(a, b, comparator) {
        if (comparator === void 0) { comparator = function (at, bt) { return at === bt; }; }
        var ai = a[Symbol.iterator]();
        var bi = b[Symbol.iterator]();
        while (true) {
            var an = ai.next();
            var bn = bi.next();
            if (an.done !== bn.done) {
                return false;
            }
            else if (an.done) {
                return true;
            }
            else if (!comparator(an.value, bn.value)) {
                return false;
            }
        }
    }
    Iterable.equals = equals;
})(Iterable || (Iterable = {}));
