/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var _a;
import { localize } from '../../../nls';
import { CancellationTokenSource } from '../../../base/common/cancellation';
import { DisposableStore, Disposable, toDisposable } from '../../../base/common/lifecycle';
import { Range } from '../../common/core/range';
import { AbstractEditorNavigationQuickAccessProvider } from './editorNavigationQuickAccess';
import { SymbolKinds, DocumentSymbolProviderRegistry } from '../../common/modes';
import { OutlineModel } from '../documentSymbols/outlineModel';
import { trim, format } from '../../../base/common/strings';
import { prepareQuery, pieceToQuery, scoreFuzzy2 } from '../../../base/common/fuzzyScorer';
import { Codicon } from '../../../base/common/codicons';
var AbstractGotoSymbolQuickAccessProvider = /** @class */ (function (_super) {
    __extends(AbstractGotoSymbolQuickAccessProvider, _super);
    function AbstractGotoSymbolQuickAccessProvider(options) {
        if (options === void 0) { options = Object.create(null); }
        var _this = _super.call(this, options) || this;
        _this.options = options;
        options.canAcceptInBackground = true;
        return _this;
    }
    AbstractGotoSymbolQuickAccessProvider.prototype.provideWithoutTextEditor = function (picker) {
        this.provideLabelPick(picker, localize('cannotRunGotoSymbolWithoutEditor', "To go to a symbol, first open a text editor with symbol information."));
        return Disposable.None;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.provideWithTextEditor = function (context, picker, token) {
        var editor = context.editor;
        var model = this.getModel(editor);
        if (!model) {
            return Disposable.None;
        }
        // Provide symbols from model if available in registry
        if (DocumentSymbolProviderRegistry.has(model)) {
            return this.doProvideWithEditorSymbols(context, model, picker, token);
        }
        // Otherwise show an entry for a model without registry
        // But give a chance to resolve the symbols at a later
        // point if possible
        return this.doProvideWithoutEditorSymbols(context, model, picker, token);
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.doProvideWithoutEditorSymbols = function (context, model, picker, token) {
        var _this = this;
        var disposables = new DisposableStore();
        // Generic pick for not having any symbol information
        this.provideLabelPick(picker, localize('cannotRunGotoSymbolWithoutSymbolProvider', "The active text editor does not provide symbol information."));
        // Wait for changes to the registry and see if eventually
        // we do get symbols. This can happen if the picker is opened
        // very early after the model has loaded but before the
        // language registry is ready.
        // https://github.com/microsoft/vscode/issues/70607
        (function () { return __awaiter(_this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.waitForLanguageSymbolRegistry(model, disposables)];
                    case 1:
                        result = _a.sent();
                        if (!result || token.isCancellationRequested) {
                            return [2 /*return*/];
                        }
                        disposables.add(this.doProvideWithEditorSymbols(context, model, picker, token));
                        return [2 /*return*/];
                }
            });
        }); })();
        return disposables;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.provideLabelPick = function (picker, label) {
        picker.items = [{ label: label, index: 0, kind: 14 /* String */ }];
        picker.ariaLabel = label;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.waitForLanguageSymbolRegistry = function (model, disposables) {
        return __awaiter(this, void 0, void 0, function () {
            var symbolProviderRegistryPromiseResolve, symbolProviderRegistryPromise, symbolProviderListener;
            return __generator(this, function (_a) {
                if (DocumentSymbolProviderRegistry.has(model)) {
                    return [2 /*return*/, true];
                }
                symbolProviderRegistryPromise = new Promise(function (resolve) { return symbolProviderRegistryPromiseResolve = resolve; });
                symbolProviderListener = disposables.add(DocumentSymbolProviderRegistry.onDidChange(function () {
                    if (DocumentSymbolProviderRegistry.has(model)) {
                        symbolProviderListener.dispose();
                        symbolProviderRegistryPromiseResolve(true);
                    }
                }));
                // Resolve promise when we get disposed too
                disposables.add(toDisposable(function () { return symbolProviderRegistryPromiseResolve(false); }));
                return [2 /*return*/, symbolProviderRegistryPromise];
            });
        });
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.doProvideWithEditorSymbols = function (context, model, picker, token) {
        var _this = this;
        var editor = context.editor;
        var disposables = new DisposableStore();
        // Goto symbol once picked
        disposables.add(picker.onDidAccept(function (event) {
            var _a = __read(picker.selectedItems, 1), item = _a[0];
            if (item && item.range) {
                _this.gotoLocation(context, { range: item.range.selection, keyMods: picker.keyMods, preserveFocus: event.inBackground });
                if (!event.inBackground) {
                    picker.hide();
                }
            }
        }));
        // Goto symbol side by side if enabled
        disposables.add(picker.onDidTriggerItemButton(function (_a) {
            var item = _a.item;
            if (item && item.range) {
                _this.gotoLocation(context, { range: item.range.selection, keyMods: picker.keyMods, forceSideBySide: true });
                picker.hide();
            }
        }));
        // Resolve symbols from document once and reuse this
        // request for all filtering and typing then on
        var symbolsPromise = this.getDocumentSymbols(model, token);
        // Set initial picks and update on type
        var picksCts = undefined;
        var updatePickerItems = function () { return __awaiter(_this, void 0, void 0, function () {
            var query, items;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        // Cancel any previous ask for picks and busy
                        picksCts === null || picksCts === void 0 ? void 0 : picksCts.dispose(true);
                        picker.busy = false;
                        // Create new cancellation source for this run
                        picksCts = new CancellationTokenSource(token);
                        // Collect symbol picks
                        picker.busy = true;
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, , 3, 4]);
                        query = prepareQuery(picker.value.substr(AbstractGotoSymbolQuickAccessProvider.PREFIX.length).trim());
                        return [4 /*yield*/, this.doGetSymbolPicks(symbolsPromise, query, undefined, picksCts.token)];
                    case 2:
                        items = _a.sent();
                        if (token.isCancellationRequested) {
                            return [2 /*return*/];
                        }
                        if (items.length > 0) {
                            picker.items = items;
                        }
                        else {
                            if (query.original.length > 0) {
                                this.provideLabelPick(picker, localize('noMatchingSymbolResults', "No matching editor symbols"));
                            }
                            else {
                                this.provideLabelPick(picker, localize('noSymbolResults', "No editor symbols"));
                            }
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        if (!token.isCancellationRequested) {
                            picker.busy = false;
                        }
                        return [7 /*endfinally*/];
                    case 4: return [2 /*return*/];
                }
            });
        }); };
        disposables.add(picker.onDidChangeValue(function () { return updatePickerItems(); }));
        updatePickerItems();
        // Reveal and decorate when active item changes
        // However, ignore the very first event so that
        // opening the picker is not immediately revealing
        // and decorating the first entry.
        var ignoreFirstActiveEvent = true;
        disposables.add(picker.onDidChangeActive(function () {
            var _a = __read(picker.activeItems, 1), item = _a[0];
            if (item && item.range) {
                if (ignoreFirstActiveEvent) {
                    ignoreFirstActiveEvent = false;
                    return;
                }
                // Reveal
                editor.revealRangeInCenter(item.range.selection, 0 /* Smooth */);
                // Decorate
                _this.addDecorations(editor, item.range.decoration);
            }
        }));
        return disposables;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.doGetSymbolPicks = function (symbolsPromise, query, options, token) {
        return __awaiter(this, void 0, void 0, function () {
            var symbols, filterBySymbolKind, filterPos, symbolQuery, containerQuery, filteredSymbolPicks, index, symbol, symbolLabel, symbolLabelWithIcon, symbolLabelIconOffset, containerLabel, symbolScore, symbolMatches, containerScore, containerMatches, skipContainerQuery, deprecated, sortedFilteredSymbolPicks, symbolPicks, lastSymbolKind, lastSeparator, lastSymbolKindCounter, sortedFilteredSymbolPicks_1, sortedFilteredSymbolPicks_1_1, symbolPick;
            var _a, _b, _c, e_1, _d;
            var _this = this;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0: return [4 /*yield*/, symbolsPromise];
                    case 1:
                        symbols = _e.sent();
                        if (token.isCancellationRequested) {
                            return [2 /*return*/, []];
                        }
                        filterBySymbolKind = query.original.indexOf(AbstractGotoSymbolQuickAccessProvider.SCOPE_PREFIX) === 0;
                        filterPos = filterBySymbolKind ? 1 : 0;
                        if (query.values && query.values.length > 1) {
                            symbolQuery = pieceToQuery(query.values[0]); // symbol: only match on first part
                            containerQuery = pieceToQuery(query.values.slice(1)); // container: match on all but first parts
                        }
                        else {
                            symbolQuery = query;
                        }
                        filteredSymbolPicks = [];
                        for (index = 0; index < symbols.length; index++) {
                            symbol = symbols[index];
                            symbolLabel = trim(symbol.name);
                            symbolLabelWithIcon = "$(symbol-" + (SymbolKinds.toString(symbol.kind) || 'property') + ") " + symbolLabel;
                            symbolLabelIconOffset = symbolLabelWithIcon.length - symbolLabel.length;
                            containerLabel = symbol.containerName;
                            if (options === null || options === void 0 ? void 0 : options.extraContainerLabel) {
                                if (containerLabel) {
                                    containerLabel = options.extraContainerLabel + " \u2022 " + containerLabel;
                                }
                                else {
                                    containerLabel = options.extraContainerLabel;
                                }
                            }
                            symbolScore = undefined;
                            symbolMatches = undefined;
                            containerScore = undefined;
                            containerMatches = undefined;
                            if (query.original.length > filterPos) {
                                skipContainerQuery = false;
                                if (symbolQuery !== query) {
                                    _a = __read(scoreFuzzy2(symbolLabelWithIcon, __assign(__assign({}, query), { values: undefined /* disable multi-query support */ }), filterPos, symbolLabelIconOffset), 2), symbolScore = _a[0], symbolMatches = _a[1];
                                    if (typeof symbolScore === 'number') {
                                        skipContainerQuery = true; // since we consumed the query, skip any container matching
                                    }
                                }
                                // Otherwise: score on the symbol query and match on the container later
                                if (typeof symbolScore !== 'number') {
                                    _b = __read(scoreFuzzy2(symbolLabelWithIcon, symbolQuery, filterPos, symbolLabelIconOffset), 2), symbolScore = _b[0], symbolMatches = _b[1];
                                    if (typeof symbolScore !== 'number') {
                                        continue;
                                    }
                                }
                                // Score by container if specified
                                if (!skipContainerQuery && containerQuery) {
                                    if (containerLabel && containerQuery.original.length > 0) {
                                        _c = __read(scoreFuzzy2(containerLabel, containerQuery), 2), containerScore = _c[0], containerMatches = _c[1];
                                    }
                                    if (typeof containerScore !== 'number') {
                                        continue;
                                    }
                                    if (typeof symbolScore === 'number') {
                                        symbolScore += containerScore; // boost symbolScore by containerScore
                                    }
                                }
                            }
                            deprecated = symbol.tags && symbol.tags.indexOf(1 /* Deprecated */) >= 0;
                            filteredSymbolPicks.push({
                                index: index,
                                kind: symbol.kind,
                                score: symbolScore,
                                label: symbolLabelWithIcon,
                                ariaLabel: symbolLabel,
                                description: containerLabel,
                                highlights: deprecated ? undefined : {
                                    label: symbolMatches,
                                    description: containerMatches
                                },
                                range: {
                                    selection: Range.collapseToStart(symbol.selectionRange),
                                    decoration: symbol.range
                                },
                                strikethrough: deprecated,
                                buttons: (function () {
                                    var _a, _b;
                                    var openSideBySideDirection = ((_a = _this.options) === null || _a === void 0 ? void 0 : _a.openSideBySideDirection) ? (_b = _this.options) === null || _b === void 0 ? void 0 : _b.openSideBySideDirection() : undefined;
                                    if (!openSideBySideDirection) {
                                        return undefined;
                                    }
                                    return [
                                        {
                                            iconClass: openSideBySideDirection === 'right' ? Codicon.splitHorizontal.classNames : Codicon.splitVertical.classNames,
                                            tooltip: openSideBySideDirection === 'right' ? localize('openToSide', "Open to the Side") : localize('openToBottom', "Open to the Bottom")
                                        }
                                    ];
                                })()
                            });
                        }
                        sortedFilteredSymbolPicks = filteredSymbolPicks.sort(function (symbolA, symbolB) { return filterBySymbolKind ?
                            _this.compareByKindAndScore(symbolA, symbolB) :
                            _this.compareByScore(symbolA, symbolB); });
                        symbolPicks = [];
                        if (filterBySymbolKind) {
                            lastSymbolKind = undefined;
                            lastSeparator = undefined;
                            lastSymbolKindCounter = 0;
                            try {
                                for (sortedFilteredSymbolPicks_1 = __values(sortedFilteredSymbolPicks), sortedFilteredSymbolPicks_1_1 = sortedFilteredSymbolPicks_1.next(); !sortedFilteredSymbolPicks_1_1.done; sortedFilteredSymbolPicks_1_1 = sortedFilteredSymbolPicks_1.next()) {
                                    symbolPick = sortedFilteredSymbolPicks_1_1.value;
                                    // Found new kind
                                    if (lastSymbolKind !== symbolPick.kind) {
                                        // Update last separator with number of symbols we found for kind
                                        this.updateLastSeparatorLabel(lastSeparator, lastSymbolKind, lastSymbolKindCounter);
                                        lastSymbolKind = symbolPick.kind;
                                        lastSymbolKindCounter = 1;
                                        // Add new separator for new kind
                                        lastSeparator = { type: 'separator' };
                                        symbolPicks.push(lastSeparator);
                                    }
                                    // Existing kind, keep counting
                                    else {
                                        lastSymbolKindCounter++;
                                    }
                                    // Add to final result
                                    symbolPicks.push(symbolPick);
                                }
                            }
                            catch (e_1_1) { e_1 = { error: e_1_1 }; }
                            finally {
                                try {
                                    if (sortedFilteredSymbolPicks_1_1 && !sortedFilteredSymbolPicks_1_1.done && (_d = sortedFilteredSymbolPicks_1.return)) _d.call(sortedFilteredSymbolPicks_1);
                                }
                                finally { if (e_1) throw e_1.error; }
                            }
                            // Update last separator with number of symbols we found for kind
                            this.updateLastSeparatorLabel(lastSeparator, lastSymbolKind, lastSymbolKindCounter);
                        }
                        else if (sortedFilteredSymbolPicks.length > 0) {
                            symbolPicks = __spreadArray([
                                { label: localize('symbols', "symbols ({0})", filteredSymbolPicks.length), type: 'separator' }
                            ], __read(sortedFilteredSymbolPicks));
                        }
                        return [2 /*return*/, symbolPicks];
                }
            });
        });
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.updateLastSeparatorLabel = function (lastSeparator, lastSymbolKind, lastSymbolKindCounter) {
        if (lastSeparator === void 0) { lastSeparator = undefined; }
        if (lastSymbolKind === void 0) { lastSymbolKind = undefined; }
        if (lastSymbolKindCounter === void 0) { lastSymbolKindCounter = 0; }
        if (lastSeparator && typeof lastSymbolKind === 'number' && lastSymbolKindCounter > 0) {
            lastSeparator.label = format(NLS_SYMBOL_KIND_CACHE[lastSymbolKind] || FALLBACK_NLS_SYMBOL_KIND, lastSymbolKindCounter);
        }
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.compareByScore = function (symbolA, symbolB) {
        if (typeof symbolA.score !== 'number' && typeof symbolB.score === 'number') {
            return 1;
        }
        else if (typeof symbolA.score === 'number' && typeof symbolB.score !== 'number') {
            return -1;
        }
        if (typeof symbolA.score === 'number' && typeof symbolB.score === 'number') {
            if (symbolA.score > symbolB.score) {
                return -1;
            }
            else if (symbolA.score < symbolB.score) {
                return 1;
            }
        }
        if (symbolA.index < symbolB.index) {
            return -1;
        }
        else if (symbolA.index > symbolB.index) {
            return 1;
        }
        return 0;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.compareByKindAndScore = function (symbolA, symbolB) {
        var kindA = NLS_SYMBOL_KIND_CACHE[symbolA.kind] || FALLBACK_NLS_SYMBOL_KIND;
        var kindB = NLS_SYMBOL_KIND_CACHE[symbolB.kind] || FALLBACK_NLS_SYMBOL_KIND;
        // Sort by type first if scoped search
        var result = kindA.localeCompare(kindB);
        if (result === 0) {
            return this.compareByScore(symbolA, symbolB);
        }
        return result;
    };
    AbstractGotoSymbolQuickAccessProvider.prototype.getDocumentSymbols = function (document, token) {
        return __awaiter(this, void 0, void 0, function () {
            var model;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, OutlineModel.create(document, token)];
                    case 1:
                        model = _a.sent();
                        return [2 /*return*/, token.isCancellationRequested ? [] : model.asListOfDocumentSymbols()];
                }
            });
        });
    };
    AbstractGotoSymbolQuickAccessProvider.PREFIX = '@';
    AbstractGotoSymbolQuickAccessProvider.SCOPE_PREFIX = ':';
    AbstractGotoSymbolQuickAccessProvider.PREFIX_BY_CATEGORY = "" + AbstractGotoSymbolQuickAccessProvider.PREFIX + AbstractGotoSymbolQuickAccessProvider.SCOPE_PREFIX;
    return AbstractGotoSymbolQuickAccessProvider;
}(AbstractEditorNavigationQuickAccessProvider));
export { AbstractGotoSymbolQuickAccessProvider };
// #region NLS Helpers
var FALLBACK_NLS_SYMBOL_KIND = localize('property', "properties ({0})");
var NLS_SYMBOL_KIND_CACHE = (_a = {},
    _a[5 /* Method */] = localize('method', "methods ({0})"),
    _a[11 /* Function */] = localize('function', "functions ({0})"),
    _a[8 /* Constructor */] = localize('_constructor', "constructors ({0})"),
    _a[12 /* Variable */] = localize('variable', "variables ({0})"),
    _a[4 /* Class */] = localize('class', "classes ({0})"),
    _a[22 /* Struct */] = localize('struct', "structs ({0})"),
    _a[23 /* Event */] = localize('event', "events ({0})"),
    _a[24 /* Operator */] = localize('operator', "operators ({0})"),
    _a[10 /* Interface */] = localize('interface', "interfaces ({0})"),
    _a[2 /* Namespace */] = localize('namespace', "namespaces ({0})"),
    _a[3 /* Package */] = localize('package', "packages ({0})"),
    _a[25 /* TypeParameter */] = localize('typeParameter', "type parameters ({0})"),
    _a[1 /* Module */] = localize('modules', "modules ({0})"),
    _a[6 /* Property */] = localize('property', "properties ({0})"),
    _a[9 /* Enum */] = localize('enum', "enumerations ({0})"),
    _a[21 /* EnumMember */] = localize('enumMember', "enumeration members ({0})"),
    _a[14 /* String */] = localize('string', "strings ({0})"),
    _a[0 /* File */] = localize('file', "files ({0})"),
    _a[17 /* Array */] = localize('array', "arrays ({0})"),
    _a[15 /* Number */] = localize('number', "numbers ({0})"),
    _a[16 /* Boolean */] = localize('boolean', "booleans ({0})"),
    _a[18 /* Object */] = localize('object', "objects ({0})"),
    _a[19 /* Key */] = localize('key', "keys ({0})"),
    _a[7 /* Field */] = localize('field', "fields ({0})"),
    _a[13 /* Constant */] = localize('constant', "constants ({0})"),
    _a);
//#endregion
