/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import './menuEntryActionViewItem.css';
import { asCSSUrl, ModifierKeyEmitter } from '../../../base/browser/dom';
import { domEvent } from '../../../base/browser/event';
import { Separator, SubmenuAction } from '../../../base/common/actions';
import { toDisposable, MutableDisposable, DisposableStore } from '../../../base/common/lifecycle';
import { localize } from '../../../nls';
import { MenuItemAction, SubmenuItemAction } from '../common/actions';
import { IContextMenuService } from '../../contextview/browser/contextView';
import { IKeybindingService } from '../../keybinding/common/keybinding';
import { INotificationService } from '../../notification/common/notification';
import { ThemeIcon } from '../../theme/common/themeService';
import { ActionViewItem } from '../../../base/browser/ui/actionbar/actionViewItems';
import { DropdownMenuActionViewItem } from '../../../base/browser/ui/dropdown/dropdownActionViewItem';
import { isWindows, isLinux } from '../../../base/common/platform';
export function createAndFillInContextMenuActions(menu, options, target, isPrimaryGroup) {
    var groups = menu.getActions(options);
    var modifierKeyEmitter = ModifierKeyEmitter.getInstance();
    var useAlternativeActions = modifierKeyEmitter.keyStatus.altKey || ((isWindows || isLinux) && modifierKeyEmitter.keyStatus.shiftKey);
    fillInActions(groups, target, useAlternativeActions, isPrimaryGroup);
    return asDisposable(groups);
}
export function createAndFillInActionBarActions(menu, options, target, isPrimaryGroup, primaryMaxCount, shouldInlineSubmenu) {
    var groups = menu.getActions(options);
    // Action bars handle alternative actions on their own so the alternative actions should be ignored
    fillInActions(groups, target, false, isPrimaryGroup, primaryMaxCount, shouldInlineSubmenu);
    return asDisposable(groups);
}
function asDisposable(groups) {
    var e_1, _a, e_2, _b;
    var disposables = new DisposableStore();
    try {
        for (var groups_1 = __values(groups), groups_1_1 = groups_1.next(); !groups_1_1.done; groups_1_1 = groups_1.next()) {
            var _c = __read(groups_1_1.value, 2), actions = _c[1];
            try {
                for (var actions_1 = (e_2 = void 0, __values(actions)), actions_1_1 = actions_1.next(); !actions_1_1.done; actions_1_1 = actions_1.next()) {
                    var action = actions_1_1.value;
                    disposables.add(action);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (actions_1_1 && !actions_1_1.done && (_b = actions_1.return)) _b.call(actions_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (groups_1_1 && !groups_1_1.done && (_a = groups_1.return)) _a.call(groups_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return disposables;
}
function fillInActions(groups, target, useAlternativeActions, isPrimaryGroup, primaryMaxCount, shouldInlineSubmenu) {
    var e_3, _a, e_4, _b, e_5, _c;
    if (isPrimaryGroup === void 0) { isPrimaryGroup = function (group) { return group === 'navigation'; }; }
    if (primaryMaxCount === void 0) { primaryMaxCount = Number.MAX_SAFE_INTEGER; }
    if (shouldInlineSubmenu === void 0) { shouldInlineSubmenu = function () { return false; }; }
    var primaryBucket;
    var secondaryBucket;
    if (Array.isArray(target)) {
        primaryBucket = target;
        secondaryBucket = target;
    }
    else {
        primaryBucket = target.primary;
        secondaryBucket = target.secondary;
    }
    var submenuInfo = new Set();
    try {
        for (var groups_2 = __values(groups), groups_2_1 = groups_2.next(); !groups_2_1.done; groups_2_1 = groups_2.next()) {
            var _d = __read(groups_2_1.value, 2), group = _d[0], actions = _d[1];
            var target_1 = void 0;
            if (isPrimaryGroup(group)) {
                target_1 = primaryBucket;
            }
            else {
                target_1 = secondaryBucket;
                if (target_1.length > 0) {
                    target_1.push(new Separator());
                }
            }
            try {
                for (var actions_2 = (e_4 = void 0, __values(actions)), actions_2_1 = actions_2.next(); !actions_2_1.done; actions_2_1 = actions_2.next()) {
                    var action = actions_2_1.value;
                    if (useAlternativeActions) {
                        action = action instanceof MenuItemAction && action.alt ? action.alt : action;
                    }
                    var newLen = target_1.push(action);
                    // keep submenu info for later inlining
                    if (action instanceof SubmenuAction) {
                        submenuInfo.add({ group: group, action: action, index: newLen - 1 });
                    }
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (actions_2_1 && !actions_2_1.done && (_b = actions_2.return)) _b.call(actions_2);
                }
                finally { if (e_4) throw e_4.error; }
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (groups_2_1 && !groups_2_1.done && (_a = groups_2.return)) _a.call(groups_2);
        }
        finally { if (e_3) throw e_3.error; }
    }
    try {
        // ask the outside if submenu should be inlined or not. only ask when
        // there would be enough space
        for (var submenuInfo_1 = __values(submenuInfo), submenuInfo_1_1 = submenuInfo_1.next(); !submenuInfo_1_1.done; submenuInfo_1_1 = submenuInfo_1.next()) {
            var _e = submenuInfo_1_1.value, group = _e.group, action = _e.action, index = _e.index;
            var target_2 = isPrimaryGroup(group) ? primaryBucket : secondaryBucket;
            // inlining submenus with length 0 or 1 is easy,
            // larger submenus need to be checked with the overall limit
            var submenuActions = action.actions;
            if ((submenuActions.length <= 1 || target_2.length + submenuActions.length - 2 <= primaryMaxCount) && shouldInlineSubmenu(action, group, target_2.length)) {
                target_2.splice.apply(target_2, __spreadArray([index, 1], __read(submenuActions)));
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (submenuInfo_1_1 && !submenuInfo_1_1.done && (_c = submenuInfo_1.return)) _c.call(submenuInfo_1);
        }
        finally { if (e_5) throw e_5.error; }
    }
    // overflow items from the primary group into the secondary bucket
    if (primaryBucket !== secondaryBucket && primaryBucket.length > primaryMaxCount) {
        var overflow = primaryBucket.splice(primaryMaxCount, primaryBucket.length - primaryMaxCount);
        secondaryBucket.unshift.apply(secondaryBucket, __spreadArray(__spreadArray([], __read(overflow)), [new Separator()]));
    }
}
var MenuEntryActionViewItem = /** @class */ (function (_super) {
    __extends(MenuEntryActionViewItem, _super);
    function MenuEntryActionViewItem(_action, _keybindingService, _notificationService) {
        var _this = _super.call(this, undefined, _action, { icon: !!(_action.class || _action.item.icon), label: !_action.class && !_action.item.icon }) || this;
        _this._action = _action;
        _this._keybindingService = _keybindingService;
        _this._notificationService = _notificationService;
        _this._wantsAltCommand = false;
        _this._itemClassDispose = _this._register(new MutableDisposable());
        _this._altKey = ModifierKeyEmitter.getInstance();
        return _this;
    }
    Object.defineProperty(MenuEntryActionViewItem.prototype, "_commandAction", {
        get: function () {
            return this._wantsAltCommand && this._action.alt || this._action;
        },
        enumerable: false,
        configurable: true
    });
    MenuEntryActionViewItem.prototype.onClick = function (event) {
        var _this = this;
        event.preventDefault();
        event.stopPropagation();
        this.actionRunner
            .run(this._commandAction, this._context)
            .catch(function (err) { return _this._notificationService.error(err); });
    };
    MenuEntryActionViewItem.prototype.render = function (container) {
        var _this = this;
        _super.prototype.render.call(this, container);
        container.classList.add('menu-entry');
        this._updateItemClass(this._action.item);
        var mouseOver = false;
        var alternativeKeyDown = this._altKey.keyStatus.altKey || ((isWindows || isLinux) && this._altKey.keyStatus.shiftKey);
        var updateAltState = function () {
            var wantsAltCommand = mouseOver && alternativeKeyDown;
            if (wantsAltCommand !== _this._wantsAltCommand) {
                _this._wantsAltCommand = wantsAltCommand;
                _this.updateLabel();
                _this.updateTooltip();
                _this.updateClass();
            }
        };
        if (this._action.alt) {
            this._register(this._altKey.event(function (value) {
                alternativeKeyDown = value.altKey || ((isWindows || isLinux) && value.shiftKey);
                updateAltState();
            }));
        }
        this._register(domEvent(container, 'mouseleave')(function (_) {
            mouseOver = false;
            updateAltState();
        }));
        this._register(domEvent(container, 'mouseenter')(function (e) {
            mouseOver = true;
            updateAltState();
        }));
    };
    MenuEntryActionViewItem.prototype.updateLabel = function () {
        if (this.options.label && this.label) {
            this.label.textContent = this._commandAction.label;
        }
    };
    MenuEntryActionViewItem.prototype.updateTooltip = function () {
        if (this.label) {
            var keybinding = this._keybindingService.lookupKeybinding(this._commandAction.id);
            var keybindingLabel = keybinding && keybinding.getLabel();
            var tooltip = this._commandAction.tooltip || this._commandAction.label;
            this.label.title = keybindingLabel
                ? localize('titleAndKb', "{0} ({1})", tooltip, keybindingLabel)
                : tooltip;
        }
    };
    MenuEntryActionViewItem.prototype.updateClass = function () {
        if (this.options.icon) {
            if (this._commandAction !== this._action) {
                if (this._action.alt) {
                    this._updateItemClass(this._action.alt.item);
                }
            }
            else if (this._action.alt) {
                this._updateItemClass(this._action.item);
            }
        }
    };
    MenuEntryActionViewItem.prototype._updateItemClass = function (item) {
        var _a;
        var _b;
        this._itemClassDispose.value = undefined;
        var _c = this, element = _c.element, label = _c.label;
        if (!element || !label) {
            return;
        }
        var icon = this._commandAction.checked && ((_b = item.toggled) === null || _b === void 0 ? void 0 : _b.icon) ? item.toggled.icon : item.icon;
        if (!icon) {
            return;
        }
        if (ThemeIcon.isThemeIcon(icon)) {
            // theme icons
            var iconClass_1 = ThemeIcon.asClassName(icon);
            (_a = label.classList).add.apply(_a, __spreadArray([], __read(iconClass_1.split(' '))));
            this._itemClassDispose.value = toDisposable(function () {
                var _a;
                (_a = label.classList).remove.apply(_a, __spreadArray([], __read(iconClass_1.split(' '))));
            });
        }
        else {
            // icon path/url
            if (icon.light) {
                label.style.setProperty('--menu-entry-icon-light', asCSSUrl(icon.light));
            }
            if (icon.dark) {
                label.style.setProperty('--menu-entry-icon-dark', asCSSUrl(icon.dark));
            }
            label.classList.add('icon');
            this._itemClassDispose.value = toDisposable(function () {
                label.classList.remove('icon');
                label.style.removeProperty('--menu-entry-icon-light');
                label.style.removeProperty('--menu-entry-icon-dark');
            });
        }
    };
    MenuEntryActionViewItem = __decorate([
        __param(1, IKeybindingService),
        __param(2, INotificationService)
    ], MenuEntryActionViewItem);
    return MenuEntryActionViewItem;
}(ActionViewItem));
export { MenuEntryActionViewItem };
var SubmenuEntryActionViewItem = /** @class */ (function (_super) {
    __extends(SubmenuEntryActionViewItem, _super);
    function SubmenuEntryActionViewItem(action, contextMenuService) {
        return _super.call(this, action, { getActions: function () { return action.actions; } }, contextMenuService, {
            menuAsChild: true,
            classNames: ThemeIcon.isThemeIcon(action.item.icon) ? ThemeIcon.asClassName(action.item.icon) : undefined,
        }) || this;
    }
    SubmenuEntryActionViewItem.prototype.render = function (container) {
        _super.prototype.render.call(this, container);
        if (this.element) {
            container.classList.add('menu-entry');
            var icon = this._action.item.icon;
            if (icon && !ThemeIcon.isThemeIcon(icon)) {
                this.element.classList.add('icon');
                if (icon.light) {
                    this.element.style.setProperty('--menu-entry-icon-light', asCSSUrl(icon.light));
                }
                if (icon.dark) {
                    this.element.style.setProperty('--menu-entry-icon-dark', asCSSUrl(icon.dark));
                }
            }
        }
    };
    SubmenuEntryActionViewItem = __decorate([
        __param(1, IContextMenuService)
    ], SubmenuEntryActionViewItem);
    return SubmenuEntryActionViewItem;
}(DropdownMenuActionViewItem));
export { SubmenuEntryActionViewItem };
/**
 * Creates action view items for menu actions or submenu actions.
 */
export function createActionViewItem(instaService, action) {
    if (action instanceof MenuItemAction) {
        return instaService.createInstance(MenuEntryActionViewItem, action);
    }
    else if (action instanceof SubmenuItemAction) {
        return instaService.createInstance(SubmenuEntryActionViewItem, action);
    }
    else {
        return undefined;
    }
}
