"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox, EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
require("../../src/browser/style/index.css");
const browser_1 = require("@theia/core/lib/browser");
const about_dialog_1 = require("@theia/core/lib/browser/about-dialog");
const command_1 = require("@theia/core/lib/common/command");
const inversify_1 = require("@theia/core/shared/inversify");
const getting_started_widget_1 = require("@theia/getting-started/lib/browser/getting-started-widget");
const menu_1 = require("@theia/core/lib/common/menu");
const theia_blueprint_about_dialog_1 = require("./theia-blueprint-about-dialog");
const theia_blueprint_contribution_1 = require("./theia-blueprint-contribution");
const theia_blueprint_getting_started_contribution_1 = require("./theia-blueprint-getting-started-contribution");
const theia_blueprint_getting_started_widget_1 = require("./theia-blueprint-getting-started-widget");
exports.default = new inversify_1.ContainerModule((bind, _unbind, isBound, rebind) => {
    browser_1.bindViewContribution(bind, theia_blueprint_getting_started_contribution_1.TheiaBlueprintGettingStartedContribution);
    bind(browser_1.FrontendApplicationContribution).toService(theia_blueprint_getting_started_contribution_1.TheiaBlueprintGettingStartedContribution);
    bind(theia_blueprint_getting_started_widget_1.TheiaBlueprintGettingStartedWidget).toSelf();
    bind(browser_1.WidgetFactory).toDynamicValue(context => ({
        id: getting_started_widget_1.GettingStartedWidget.ID,
        createWidget: () => context.container.get(theia_blueprint_getting_started_widget_1.TheiaBlueprintGettingStartedWidget),
    })).inSingletonScope();
    if (isBound(about_dialog_1.AboutDialog)) {
        rebind(about_dialog_1.AboutDialog).to(theia_blueprint_about_dialog_1.TheiaBlueprintAboutDialog).inSingletonScope();
    }
    else {
        bind(about_dialog_1.AboutDialog).to(theia_blueprint_about_dialog_1.TheiaBlueprintAboutDialog).inSingletonScope();
    }
    bind(theia_blueprint_contribution_1.TheiaBlueprintContribution).toSelf().inSingletonScope();
    [command_1.CommandContribution, menu_1.MenuContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(theia_blueprint_contribution_1.TheiaBlueprintContribution));
});
//# sourceMappingURL=theia-blueprint-frontend-module.js.map