/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public class EclipseBuildSupport
implements IBuildSupport {
    private Set<String> files = Sets.newHashSet((Object[])new String[]{".classpath", ".project", ".factorypath"});
    private Set<String> folders = Sets.newHashSet((Object[])new String[]{".settings"});

    @Override
    public boolean applies(IProject project) {
        return true;
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        if (resource == null || resource.getProject() == null) {
            return false;
        }
        IProject project = resource.getProject();
        for (String file : this.files) {
            if (!resource.equals((Object)project.getFile(file))) continue;
            return true;
        }
        IPath path = resource.getFullPath();
        for (String folder : this.folders) {
            IPath folderPath = project.getFolder(folder).getFullPath();
            if (!folderPath.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        this.refresh(resource, changeType, monitor);
        IProject project = resource.getProject();
        if (ProjectUtils.isJavaProject(project)) {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1) {
                    IPath path = entry.getPath();
                    IFile r = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    if (r != null && r.equals((Object)resource)) {
                        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                        javaProject.setRawClasspath(new IClasspathEntry[0], monitor);
                        javaProject.setRawClasspath(rawClasspath, monitor);
                        break;
                    }
                }
                ++n2;
            }
        }
        return false;
    }
}

