"use strict";
/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Localization = exports.AsyncLocalizationProvider = exports.localizationPath = void 0;
exports.localizationPath = '/services/i18n';
exports.AsyncLocalizationProvider = Symbol('AsyncLocalizationProvider');
var Localization;
(function (Localization) {
    function format(message, args) {
        let result = message;
        if (args.length > 0) {
            result = message.replace(/\{(\d+)\}/g, (match, rest) => {
                const index = rest[0];
                const arg = args[index];
                let replacement = match;
                if (typeof arg === 'string') {
                    replacement = arg;
                }
                else if (typeof arg === 'number' || typeof arg === 'boolean' || !arg) {
                    replacement = String(arg);
                }
                return replacement;
            });
        }
        return result;
    }
    function localize(localization, key, defaultValue, ...args) {
        let value = defaultValue;
        if (localization) {
            const translation = localization.translations[key];
            if (translation) {
                // vscode's localizations often contain additional '&&' symbols, which we simply ignore
                value = translation.replace(/&&/g, '');
            }
        }
        return format(value, args);
    }
    Localization.localize = localize;
    function transformKey(key) {
        let nlsKey = key;
        const keySlashIndex = key.lastIndexOf('/');
        if (keySlashIndex >= 0) {
            nlsKey = key.substring(keySlashIndex + 1);
        }
        return nlsKey;
    }
    Localization.transformKey = transformKey;
})(Localization = exports.Localization || (exports.Localization = {}));
//# sourceMappingURL=localization.js.map