"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugConfigurationWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const common_1 = require("@theia/core/lib/common");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_1 = require("@theia/core/lib/browser");
const browser_2 = require("@theia/workspace/lib/browser");
const debug_console_contribution_1 = require("../console/debug-console-contribution");
const debug_configuration_manager_1 = require("../debug-configuration-manager");
const debug_session_manager_1 = require("../debug-session-manager");
const debug_action_1 = require("./debug-action");
const debug_view_model_1 = require("./debug-view-model");
const debug_frontend_application_contribution_1 = require("../debug-frontend-application-contribution");
const nls_1 = require("@theia/core/lib/common/nls");
let DebugConfigurationWidget = class DebugConfigurationWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.setStepRef = (stepRef) => this.stepRef = stepRef || undefined;
        this.setCurrentConfiguration = (event) => {
            const value = event.currentTarget.value;
            if (value === '__ADD_CONF__') {
                this.manager.addConfiguration();
            }
            else {
                const [name, workspaceFolderUri] = value.split('__CONF__');
                this.manager.current = this.manager.find(name, workspaceFolderUri);
            }
        };
        this.start = () => {
            const configuration = this.manager.current;
            this.commandRegistry.executeCommand(debug_frontend_application_contribution_1.DebugCommands.START.id, configuration);
        };
        this.openConfiguration = () => this.manager.openConfiguration();
        this.openConsole = () => this.debugConsole.openView({
            activate: true
        });
    }
    init() {
        this.addClass('debug-toolbar');
        this.toDispose.push(this.manager.onDidChange(() => this.update()));
        this.toDispose.push(this.workspaceService.onWorkspaceChanged(() => this.update()));
        this.toDispose.push(this.workspaceService.onWorkspaceLocationChanged(() => this.update()));
        this.scrollOptions = undefined;
        this.update();
    }
    focus() {
        if (!this.doFocus()) {
            this.onRender.push(common_1.Disposable.create(() => this.doFocus()));
            this.update();
        }
    }
    doFocus() {
        if (!this.stepRef) {
            return false;
        }
        this.stepRef.focus();
        return true;
    }
    render() {
        const { options } = this;
        return React.createElement(React.Fragment, null,
            React.createElement(debug_action_1.DebugAction, { run: this.start, label: nls_1.nls.localize('vscode/debugCommands/startDebug', 'Start Debugging'), iconClass: 'debug-start', ref: this.setStepRef }),
            React.createElement("select", { className: 'theia-select debug-configuration', value: this.currentValue, onChange: this.setCurrentConfiguration },
                options.length ? options : React.createElement("option", { value: '__NO_CONF__' }, nls_1.nls.localize('vscode/debugActionViewItems/noConfigurations', 'No Configurations')),
                React.createElement("option", { disabled: true }, 'Add Configuration...'.replace(/./g, '-')),
                React.createElement("option", { value: '__ADD_CONF__' }, nls_1.nls.localize('vscode/debugActionViewItems/addConfiguration', 'Add Configuration...'))),
            React.createElement(debug_action_1.DebugAction, { run: this.openConfiguration, label: nls_1.nls.localize('vscode/debugCommands/openLaunchJson', 'Open "launch.json"', '"launch.json"'), iconClass: 'settings-gear' }),
            React.createElement(debug_action_1.DebugAction, { run: this.openConsole, label: nls_1.nls.localize('vscode/repl/debugConsole', 'Debug Console'), iconClass: 'terminal' }));
    }
    get currentValue() {
        const { current } = this.manager;
        return current ? this.toValue(current) : '__NO_CONF__';
    }
    get options() {
        return Array.from(this.manager.all).map((options, index) => React.createElement("option", { key: index, value: this.toValue(options) }, this.toName(options)));
    }
    toValue({ configuration, workspaceFolderUri }) {
        if (!workspaceFolderUri) {
            return configuration.name;
        }
        return configuration.name + '__CONF__' + workspaceFolderUri;
    }
    toName({ configuration, workspaceFolderUri }) {
        if (!workspaceFolderUri || !this.workspaceService.isMultiRootWorkspaceOpened) {
            return configuration.name;
        }
        return configuration.name + ' (' + new uri_1.default(workspaceFolderUri).path.base + ')';
    }
};
__decorate([
    inversify_1.inject(common_1.CommandRegistry),
    __metadata("design:type", common_1.CommandRegistry)
], DebugConfigurationWidget.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(debug_view_model_1.DebugViewModel),
    __metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugConfigurationWidget.prototype, "viewModel", void 0);
__decorate([
    inversify_1.inject(debug_configuration_manager_1.DebugConfigurationManager),
    __metadata("design:type", debug_configuration_manager_1.DebugConfigurationManager)
], DebugConfigurationWidget.prototype, "manager", void 0);
__decorate([
    inversify_1.inject(debug_session_manager_1.DebugSessionManager),
    __metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugConfigurationWidget.prototype, "sessionManager", void 0);
__decorate([
    inversify_1.inject(debug_console_contribution_1.DebugConsoleContribution),
    __metadata("design:type", debug_console_contribution_1.DebugConsoleContribution)
], DebugConfigurationWidget.prototype, "debugConsole", void 0);
__decorate([
    inversify_1.inject(browser_2.WorkspaceService),
    __metadata("design:type", browser_2.WorkspaceService)
], DebugConfigurationWidget.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], DebugConfigurationWidget.prototype, "init", null);
DebugConfigurationWidget = __decorate([
    inversify_1.injectable()
], DebugConfigurationWidget);
exports.DebugConfigurationWidget = DebugConfigurationWidget;
//# sourceMappingURL=debug-configuration-widget.js.map