/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as nls from '../../../nls';
import { registerEditorContribution, registerModelAndPositionCommand, EditorAction, EditorCommand, registerEditorAction, registerEditorCommand } from '../../browser/editorExtensions';
import * as arrays from '../../../base/common/arrays';
import { Disposable, DisposableStore } from '../../../base/common/lifecycle';
import { Position } from '../../common/core/position';
import { CancellationToken } from '../../../base/common/cancellation';
import { Range } from '../../common/core/range';
import { LinkedEditingRangeProviderRegistry } from '../../common/modes';
import { first, createCancelablePromise, Delayer } from '../../../base/common/async';
import { ModelDecorationOptions } from '../../common/model/textModel';
import { ContextKeyExpr, RawContextKey, IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { URI } from '../../../base/common/uri';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
import { isPromiseCanceledError, onUnexpectedError, onUnexpectedExternalError } from '../../../base/common/errors';
import * as strings from '../../../base/common/strings';
import { registerColor } from '../../../platform/theme/common/colorRegistry';
import { registerThemingParticipant } from '../../../platform/theme/common/themeService';
import { Color } from '../../../base/common/color';
import { LanguageConfigurationRegistry } from '../../common/modes/languageConfigurationRegistry';
export var CONTEXT_ONTYPE_RENAME_INPUT_VISIBLE = new RawContextKey('LinkedEditingInputVisible', false);
var DECORATION_CLASS_NAME = 'linked-editing-decoration';
var LinkedEditingContribution = /** @class */ (function (_super) {
    __extends(LinkedEditingContribution, _super);
    function LinkedEditingContribution(editor, contextKeyService) {
        var _this = _super.call(this) || this;
        _this._debounceDuration = 200;
        _this._localToDispose = _this._register(new DisposableStore());
        _this._editor = editor;
        _this._enabled = false;
        _this._visibleContextKey = CONTEXT_ONTYPE_RENAME_INPUT_VISIBLE.bindTo(contextKeyService);
        _this._currentDecorations = [];
        _this._languageWordPattern = null;
        _this._currentWordPattern = null;
        _this._ignoreChangeEvent = false;
        _this._localToDispose = _this._register(new DisposableStore());
        _this._rangeUpdateTriggerPromise = null;
        _this._rangeSyncTriggerPromise = null;
        _this._currentRequest = null;
        _this._currentRequestPosition = null;
        _this._currentRequestModelVersion = null;
        _this._register(_this._editor.onDidChangeModel(function () { return _this.reinitialize(); }));
        _this._register(_this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(56 /* linkedEditing */) || e.hasChanged(76 /* renameOnType */)) {
                _this.reinitialize();
            }
        }));
        _this._register(LinkedEditingRangeProviderRegistry.onDidChange(function () { return _this.reinitialize(); }));
        _this._register(_this._editor.onDidChangeModelLanguage(function () { return _this.reinitialize(); }));
        _this.reinitialize();
        return _this;
    }
    LinkedEditingContribution.get = function (editor) {
        return editor.getContribution(LinkedEditingContribution.ID);
    };
    LinkedEditingContribution.prototype.reinitialize = function () {
        var _this = this;
        var model = this._editor.getModel();
        var isEnabled = model !== null && (this._editor.getOption(56 /* linkedEditing */) || this._editor.getOption(76 /* renameOnType */)) && LinkedEditingRangeProviderRegistry.has(model);
        if (isEnabled === this._enabled) {
            return;
        }
        this._enabled = isEnabled;
        this.clearRanges();
        this._localToDispose.clear();
        if (!isEnabled || model === null) {
            return;
        }
        this._languageWordPattern = LanguageConfigurationRegistry.getWordDefinition(model.getLanguageIdentifier().id);
        this._localToDispose.add(model.onDidChangeLanguageConfiguration(function () {
            _this._languageWordPattern = LanguageConfigurationRegistry.getWordDefinition(model.getLanguageIdentifier().id);
        }));
        var rangeUpdateScheduler = new Delayer(this._debounceDuration);
        var triggerRangeUpdate = function () {
            _this._rangeUpdateTriggerPromise = rangeUpdateScheduler.trigger(function () { return _this.updateRanges(); }, _this._debounceDuration);
        };
        var rangeSyncScheduler = new Delayer(0);
        var triggerRangeSync = function (decorations) {
            _this._rangeSyncTriggerPromise = rangeSyncScheduler.trigger(function () { return _this._syncRanges(decorations); });
        };
        this._localToDispose.add(this._editor.onDidChangeCursorPosition(function () {
            triggerRangeUpdate();
        }));
        this._localToDispose.add(this._editor.onDidChangeModelContent(function (e) {
            if (!_this._ignoreChangeEvent) {
                if (_this._currentDecorations.length > 0) {
                    var referenceRange_1 = model.getDecorationRange(_this._currentDecorations[0]);
                    if (referenceRange_1 && e.changes.every(function (c) { return referenceRange_1.intersectRanges(c.range); })) {
                        triggerRangeSync(_this._currentDecorations);
                        return;
                    }
                }
            }
            triggerRangeUpdate();
        }));
        this._localToDispose.add({
            dispose: function () {
                rangeUpdateScheduler.cancel();
                rangeSyncScheduler.cancel();
            }
        });
        this.updateRanges();
    };
    LinkedEditingContribution.prototype._syncRanges = function (decorations) {
        // dalayed invocation, make sure we're still on
        if (!this._editor.hasModel() || decorations !== this._currentDecorations || decorations.length === 0) {
            // nothing to do
            return;
        }
        var model = this._editor.getModel();
        var referenceRange = model.getDecorationRange(decorations[0]);
        if (!referenceRange || referenceRange.startLineNumber !== referenceRange.endLineNumber) {
            return this.clearRanges();
        }
        var referenceValue = model.getValueInRange(referenceRange);
        if (this._currentWordPattern) {
            var match = referenceValue.match(this._currentWordPattern);
            var matchLength = match ? match[0].length : 0;
            if (matchLength !== referenceValue.length) {
                return this.clearRanges();
            }
        }
        var edits = [];
        for (var i = 1, len = decorations.length; i < len; i++) {
            var mirrorRange = model.getDecorationRange(decorations[i]);
            if (!mirrorRange) {
                continue;
            }
            if (mirrorRange.startLineNumber !== mirrorRange.endLineNumber) {
                edits.push({
                    range: mirrorRange,
                    text: referenceValue
                });
            }
            else {
                var oldValue = model.getValueInRange(mirrorRange);
                var newValue = referenceValue;
                var rangeStartColumn = mirrorRange.startColumn;
                var rangeEndColumn = mirrorRange.endColumn;
                var commonPrefixLength = strings.commonPrefixLength(oldValue, newValue);
                rangeStartColumn += commonPrefixLength;
                oldValue = oldValue.substr(commonPrefixLength);
                newValue = newValue.substr(commonPrefixLength);
                var commonSuffixLength = strings.commonSuffixLength(oldValue, newValue);
                rangeEndColumn -= commonSuffixLength;
                oldValue = oldValue.substr(0, oldValue.length - commonSuffixLength);
                newValue = newValue.substr(0, newValue.length - commonSuffixLength);
                if (rangeStartColumn !== rangeEndColumn || newValue.length !== 0) {
                    edits.push({
                        range: new Range(mirrorRange.startLineNumber, rangeStartColumn, mirrorRange.endLineNumber, rangeEndColumn),
                        text: newValue
                    });
                }
            }
        }
        if (edits.length === 0) {
            return;
        }
        try {
            this._editor.popUndoStop();
            this._ignoreChangeEvent = true;
            var prevEditOperationType = this._editor._getViewModel().getPrevEditOperationType();
            this._editor.executeEdits('linkedEditing', edits);
            this._editor._getViewModel().setPrevEditOperationType(prevEditOperationType);
        }
        finally {
            this._ignoreChangeEvent = false;
        }
    };
    LinkedEditingContribution.prototype.dispose = function () {
        this.clearRanges();
        _super.prototype.dispose.call(this);
    };
    LinkedEditingContribution.prototype.clearRanges = function () {
        this._visibleContextKey.set(false);
        this._currentDecorations = this._editor.deltaDecorations(this._currentDecorations, []);
        if (this._currentRequest) {
            this._currentRequest.cancel();
            this._currentRequest = null;
            this._currentRequestPosition = null;
        }
    };
    Object.defineProperty(LinkedEditingContribution.prototype, "currentUpdateTriggerPromise", {
        get: function () {
            return this._rangeUpdateTriggerPromise || Promise.resolve();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LinkedEditingContribution.prototype, "currentSyncTriggerPromise", {
        get: function () {
            return this._rangeSyncTriggerPromise || Promise.resolve();
        },
        enumerable: false,
        configurable: true
    });
    LinkedEditingContribution.prototype.updateRanges = function (force) {
        if (force === void 0) { force = false; }
        return __awaiter(this, void 0, void 0, function () {
            var position, model, modelVersionId, range, request;
            var _this = this;
            return __generator(this, function (_a) {
                if (!this._editor.hasModel()) {
                    this.clearRanges();
                    return [2 /*return*/];
                }
                position = this._editor.getPosition();
                if (!this._enabled && !force || this._editor.getSelections().length > 1) {
                    // disabled or multicursor
                    this.clearRanges();
                    return [2 /*return*/];
                }
                model = this._editor.getModel();
                modelVersionId = model.getVersionId();
                if (this._currentRequestPosition && this._currentRequestModelVersion === modelVersionId) {
                    if (position.equals(this._currentRequestPosition)) {
                        return [2 /*return*/]; // same position
                    }
                    if (this._currentDecorations && this._currentDecorations.length > 0) {
                        range = model.getDecorationRange(this._currentDecorations[0]);
                        if (range && range.containsPosition(position)) {
                            return [2 /*return*/]; // just moving inside the existing primary range
                        }
                    }
                }
                this._currentRequestPosition = position;
                this._currentRequestModelVersion = modelVersionId;
                request = createCancelablePromise(function (token) { return __awaiter(_this, void 0, void 0, function () {
                    var response, ranges, foundReferenceRange, i, len, referenceRange, decorations, err_1;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                _a.trys.push([0, 2, , 3]);
                                return [4 /*yield*/, getLinkedEditingRanges(model, position, token)];
                            case 1:
                                response = _a.sent();
                                if (request !== this._currentRequest) {
                                    return [2 /*return*/];
                                }
                                this._currentRequest = null;
                                if (modelVersionId !== model.getVersionId()) {
                                    return [2 /*return*/];
                                }
                                ranges = [];
                                if (response === null || response === void 0 ? void 0 : response.ranges) {
                                    ranges = response.ranges;
                                }
                                this._currentWordPattern = (response === null || response === void 0 ? void 0 : response.wordPattern) || this._languageWordPattern;
                                foundReferenceRange = false;
                                for (i = 0, len = ranges.length; i < len; i++) {
                                    if (Range.containsPosition(ranges[i], position)) {
                                        foundReferenceRange = true;
                                        if (i !== 0) {
                                            referenceRange = ranges[i];
                                            ranges.splice(i, 1);
                                            ranges.unshift(referenceRange);
                                        }
                                        break;
                                    }
                                }
                                if (!foundReferenceRange) {
                                    // Cannot do linked editing if the ranges are not where the cursor is...
                                    this.clearRanges();
                                    return [2 /*return*/];
                                }
                                decorations = ranges.map(function (range) { return ({ range: range, options: LinkedEditingContribution.DECORATION }); });
                                this._visibleContextKey.set(true);
                                this._currentDecorations = this._editor.deltaDecorations(this._currentDecorations, decorations);
                                return [3 /*break*/, 3];
                            case 2:
                                err_1 = _a.sent();
                                if (!isPromiseCanceledError(err_1)) {
                                    onUnexpectedError(err_1);
                                }
                                if (this._currentRequest === request || !this._currentRequest) {
                                    // stop if we are still the latest request
                                    this.clearRanges();
                                }
                                return [3 /*break*/, 3];
                            case 3: return [2 /*return*/];
                        }
                    });
                }); });
                this._currentRequest = request;
                return [2 /*return*/, request];
            });
        });
    };
    // for testing
    LinkedEditingContribution.prototype.setDebounceDuration = function (timeInMS) {
        this._debounceDuration = timeInMS;
    };
    LinkedEditingContribution.ID = 'editor.contrib.linkedEditing';
    LinkedEditingContribution.DECORATION = ModelDecorationOptions.register({
        stickiness: 0 /* AlwaysGrowsWhenTypingAtEdges */,
        className: DECORATION_CLASS_NAME
    });
    LinkedEditingContribution = __decorate([
        __param(1, IContextKeyService)
    ], LinkedEditingContribution);
    return LinkedEditingContribution;
}(Disposable));
export { LinkedEditingContribution };
var LinkedEditingAction = /** @class */ (function (_super) {
    __extends(LinkedEditingAction, _super);
    function LinkedEditingAction() {
        return _super.call(this, {
            id: 'editor.action.linkedEditing',
            label: nls.localize('linkedEditing.label', "Start Linked Editing"),
            alias: 'Start Linked Editing',
            precondition: ContextKeyExpr.and(EditorContextKeys.writable, EditorContextKeys.hasRenameProvider),
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 2048 /* CtrlCmd */ | 1024 /* Shift */ | 60 /* F2 */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    LinkedEditingAction.prototype.runCommand = function (accessor, args) {
        var _this = this;
        var editorService = accessor.get(ICodeEditorService);
        var _a = __read(Array.isArray(args) && args || [undefined, undefined], 2), uri = _a[0], pos = _a[1];
        if (URI.isUri(uri) && Position.isIPosition(pos)) {
            return editorService.openCodeEditor({ resource: uri }, editorService.getActiveCodeEditor()).then(function (editor) {
                if (!editor) {
                    return;
                }
                editor.setPosition(pos);
                editor.invokeWithinContext(function (accessor) {
                    _this.reportTelemetry(accessor, editor);
                    return _this.run(accessor, editor);
                });
            }, onUnexpectedError);
        }
        return _super.prototype.runCommand.call(this, accessor, args);
    };
    LinkedEditingAction.prototype.run = function (_accessor, editor) {
        var controller = LinkedEditingContribution.get(editor);
        if (controller) {
            return Promise.resolve(controller.updateRanges(true));
        }
        return Promise.resolve();
    };
    return LinkedEditingAction;
}(EditorAction));
export { LinkedEditingAction };
var LinkedEditingCommand = EditorCommand.bindToContribution(LinkedEditingContribution.get);
registerEditorCommand(new LinkedEditingCommand({
    id: 'cancelLinkedEditingInput',
    precondition: CONTEXT_ONTYPE_RENAME_INPUT_VISIBLE,
    handler: function (x) { return x.clearRanges(); },
    kbOpts: {
        kbExpr: EditorContextKeys.editorTextFocus,
        weight: 100 /* EditorContrib */ + 99,
        primary: 9 /* Escape */,
        secondary: [1024 /* Shift */ | 9 /* Escape */]
    }
}));
function getLinkedEditingRanges(model, position, token) {
    var _this = this;
    var orderedByScore = LinkedEditingRangeProviderRegistry.ordered(model);
    // in order of score ask the linked editing range provider
    // until someone response with a good result
    // (good = not null)
    return first(orderedByScore.map(function (provider) { return function () { return __awaiter(_this, void 0, void 0, function () {
        var e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, provider.provideLinkedEditingRanges(model, position, token)];
                case 1: return [2 /*return*/, _a.sent()];
                case 2:
                    e_1 = _a.sent();
                    onUnexpectedExternalError(e_1);
                    return [2 /*return*/, undefined];
                case 3: return [2 /*return*/];
            }
        });
    }); }; }), function (result) { return !!result && arrays.isNonEmptyArray(result === null || result === void 0 ? void 0 : result.ranges); });
}
export var editorLinkedEditingBackground = registerColor('editor.linkedEditingBackground', { dark: Color.fromHex('#f00').transparent(0.3), light: Color.fromHex('#f00').transparent(0.3), hc: Color.fromHex('#f00').transparent(0.3) }, nls.localize('editorLinkedEditingBackground', 'Background color when the editor auto renames on type.'));
registerThemingParticipant(function (theme, collector) {
    var editorLinkedEditingBackgroundColor = theme.getColor(editorLinkedEditingBackground);
    if (editorLinkedEditingBackgroundColor) {
        collector.addRule(".monaco-editor ." + DECORATION_CLASS_NAME + " { background: " + editorLinkedEditingBackgroundColor + "; border-left-color: " + editorLinkedEditingBackgroundColor + "; }");
    }
});
registerModelAndPositionCommand('_executeLinkedEditingProvider', function (model, position) { return getLinkedEditingRanges(model, position, CancellationToken.None); });
registerEditorContribution(LinkedEditingContribution.ID, LinkedEditingContribution);
registerEditorAction(LinkedEditingAction);
