/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { TimeoutTimer } from '../../../base/common/async';
import { onUnexpectedError } from '../../../base/common/errors';
import { Emitter } from '../../../base/common/event';
import { dispose, DisposableStore } from '../../../base/common/lifecycle';
import { Selection } from '../../common/core/selection';
import { CompletionProviderRegistry } from '../../common/modes';
import { CompletionModel } from './completionModel';
import { getSuggestionComparator, provideSuggestionItems, getSnippetSuggestSupport, CompletionOptions } from './suggest';
import { SnippetController2 } from '../snippet/snippetController2';
import { CancellationTokenSource } from '../../../base/common/cancellation';
import { IEditorWorkerService } from '../../common/services/editorWorkerService';
import { WordDistance } from './wordDistance';
import { isLowSurrogate, isHighSurrogate, getLeadingWhitespace } from '../../../base/common/strings';
import { IClipboardService } from '../../../platform/clipboard/common/clipboardService';
import { ITelemetryService } from '../../../platform/telemetry/common/telemetry';
import { ILogService } from '../../../platform/log/common/log';
var LineContext = /** @class */ (function () {
    function LineContext(model, position, auto, shy) {
        this.leadingLineContent = model.getLineContent(position.lineNumber).substr(0, position.column - 1);
        this.leadingWord = model.getWordUntilPosition(position);
        this.lineNumber = position.lineNumber;
        this.column = position.column;
        this.auto = auto;
        this.shy = shy;
    }
    LineContext.shouldAutoTrigger = function (editor) {
        if (!editor.hasModel()) {
            return false;
        }
        var model = editor.getModel();
        var pos = editor.getPosition();
        model.tokenizeIfCheap(pos.lineNumber);
        var word = model.getWordAtPosition(pos);
        if (!word) {
            return false;
        }
        if (word.endColumn !== pos.column) {
            return false;
        }
        if (!isNaN(Number(word.word))) {
            return false;
        }
        return true;
    };
    return LineContext;
}());
export { LineContext };
var SuggestModel = /** @class */ (function () {
    function SuggestModel(_editor, _editorWorkerService, _clipboardService, _telemetryService, _logService) {
        var _this = this;
        this._editor = _editor;
        this._editorWorkerService = _editorWorkerService;
        this._clipboardService = _clipboardService;
        this._telemetryService = _telemetryService;
        this._logService = _logService;
        this._toDispose = new DisposableStore();
        this._quickSuggestDelay = 10;
        this._triggerCharacterListener = new DisposableStore();
        this._triggerQuickSuggest = new TimeoutTimer();
        this._state = 0 /* Idle */;
        this._completionDisposables = new DisposableStore();
        this._onDidCancel = new Emitter();
        this._onDidTrigger = new Emitter();
        this._onDidSuggest = new Emitter();
        this.onDidCancel = this._onDidCancel.event;
        this.onDidTrigger = this._onDidTrigger.event;
        this.onDidSuggest = this._onDidSuggest.event;
        this._telemetryGate = 0;
        this._currentSelection = this._editor.getSelection() || new Selection(1, 1, 1, 1);
        // wire up various listeners
        this._toDispose.add(this._editor.onDidChangeModel(function () {
            _this._updateTriggerCharacters();
            _this.cancel();
        }));
        this._toDispose.add(this._editor.onDidChangeModelLanguage(function () {
            _this._updateTriggerCharacters();
            _this.cancel();
        }));
        this._toDispose.add(this._editor.onDidChangeConfiguration(function () {
            _this._updateTriggerCharacters();
            _this._updateQuickSuggest();
        }));
        this._toDispose.add(CompletionProviderRegistry.onDidChange(function () {
            _this._updateTriggerCharacters();
            _this._updateActiveSuggestSession();
        }));
        this._toDispose.add(this._editor.onDidChangeCursorSelection(function (e) {
            _this._onCursorChange(e);
        }));
        var editorIsComposing = false;
        this._toDispose.add(this._editor.onDidCompositionStart(function () {
            editorIsComposing = true;
        }));
        this._toDispose.add(this._editor.onDidCompositionEnd(function () {
            // refilter when composition ends
            editorIsComposing = false;
            _this._refilterCompletionItems();
        }));
        this._toDispose.add(this._editor.onDidChangeModelContent(function () {
            // only filter completions when the editor isn't
            // composing a character, e.g. ¨ + u makes ü but just
            // ¨ cannot be used for filtering
            if (!editorIsComposing) {
                _this._refilterCompletionItems();
            }
        }));
        this._updateTriggerCharacters();
        this._updateQuickSuggest();
    }
    SuggestModel.prototype.dispose = function () {
        dispose(this._triggerCharacterListener);
        dispose([this._onDidCancel, this._onDidSuggest, this._onDidTrigger, this._triggerQuickSuggest]);
        this._toDispose.dispose();
        this._completionDisposables.dispose();
        this.cancel();
    };
    // --- handle configuration & precondition changes
    SuggestModel.prototype._updateQuickSuggest = function () {
        this._quickSuggestDelay = this._editor.getOption(74 /* quickSuggestionsDelay */);
        if (isNaN(this._quickSuggestDelay) || (!this._quickSuggestDelay && this._quickSuggestDelay !== 0) || this._quickSuggestDelay < 0) {
            this._quickSuggestDelay = 10;
        }
    };
    SuggestModel.prototype._updateTriggerCharacters = function () {
        var e_1, _a, e_2, _b;
        var _this = this;
        this._triggerCharacterListener.clear();
        if (this._editor.getOption(75 /* readOnly */)
            || !this._editor.hasModel()
            || !this._editor.getOption(104 /* suggestOnTriggerCharacters */)) {
            return;
        }
        var supportsByTriggerCharacter = new Map();
        try {
            for (var _c = __values(CompletionProviderRegistry.all(this._editor.getModel())), _d = _c.next(); !_d.done; _d = _c.next()) {
                var support = _d.value;
                try {
                    for (var _e = (e_2 = void 0, __values(support.triggerCharacters || [])), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var ch = _f.value;
                        var set = supportsByTriggerCharacter.get(ch);
                        if (!set) {
                            set = new Set();
                            set.add(getSnippetSuggestSupport());
                            supportsByTriggerCharacter.set(ch, set);
                        }
                        set.add(support);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var checkTriggerCharacter = function (text) {
            if (!text) {
                // came here from the compositionEnd-event
                var position = _this._editor.getPosition();
                var model = _this._editor.getModel();
                text = model.getLineContent(position.lineNumber).substr(0, position.column - 1);
            }
            var lastChar = '';
            if (isLowSurrogate(text.charCodeAt(text.length - 1))) {
                if (isHighSurrogate(text.charCodeAt(text.length - 2))) {
                    lastChar = text.substr(text.length - 2);
                }
            }
            else {
                lastChar = text.charAt(text.length - 1);
            }
            var supports = supportsByTriggerCharacter.get(lastChar);
            if (supports) {
                // keep existing items that where not computed by the
                // supports/providers that want to trigger now
                var existing = _this._completionModel
                    ? { items: _this._completionModel.adopt(supports), clipboardText: _this._completionModel.clipboardText }
                    : undefined;
                _this.trigger({ auto: true, shy: false, triggerCharacter: lastChar }, Boolean(_this._completionModel), supports, existing);
            }
        };
        this._triggerCharacterListener.add(this._editor.onDidType(checkTriggerCharacter));
        this._triggerCharacterListener.add(this._editor.onDidCompositionEnd(checkTriggerCharacter));
    };
    Object.defineProperty(SuggestModel.prototype, "state", {
        // --- trigger/retrigger/cancel suggest
        get: function () {
            return this._state;
        },
        enumerable: false,
        configurable: true
    });
    SuggestModel.prototype.cancel = function (retrigger) {
        var _a;
        if (retrigger === void 0) { retrigger = false; }
        if (this._state !== 0 /* Idle */) {
            this._triggerQuickSuggest.cancel();
            (_a = this._requestToken) === null || _a === void 0 ? void 0 : _a.cancel();
            this._requestToken = undefined;
            this._state = 0 /* Idle */;
            this._completionModel = undefined;
            this._context = undefined;
            this._onDidCancel.fire({ retrigger: retrigger });
        }
    };
    SuggestModel.prototype.clear = function () {
        this._completionDisposables.clear();
    };
    SuggestModel.prototype._updateActiveSuggestSession = function () {
        if (this._state !== 0 /* Idle */) {
            if (!this._editor.hasModel() || !CompletionProviderRegistry.has(this._editor.getModel())) {
                this.cancel();
            }
            else {
                this.trigger({ auto: this._state === 2 /* Auto */, shy: false }, true);
            }
        }
    };
    SuggestModel.prototype._onCursorChange = function (e) {
        var _this = this;
        if (!this._editor.hasModel()) {
            return;
        }
        var model = this._editor.getModel();
        var prevSelection = this._currentSelection;
        this._currentSelection = this._editor.getSelection();
        if (!e.selection.isEmpty()
            || (e.reason !== 0 /* NotSet */ && e.reason !== 3 /* Explicit */)
            || (e.source !== 'keyboard' && e.source !== 'deleteLeft')) {
            // Early exit if nothing needs to be done!
            // Leave some form of early exit check here if you wish to continue being a cursor position change listener ;)
            this.cancel();
            return;
        }
        if (!CompletionProviderRegistry.has(model)) {
            return;
        }
        if (this._state === 0 /* Idle */ && e.reason === 0 /* NotSet */) {
            if (this._editor.getOption(73 /* quickSuggestions */) === false) {
                // not enabled
                return;
            }
            if (!prevSelection.containsRange(this._currentSelection) && !prevSelection.getEndPosition().isBeforeOrEqual(this._currentSelection.getPosition())) {
                // cursor didn't move RIGHT
                return;
            }
            if (this._editor.getOption(101 /* suggest */).snippetsPreventQuickSuggestions && SnippetController2.get(this._editor).isInSnippet()) {
                // no quick suggestion when in snippet mode
                return;
            }
            this.cancel();
            this._triggerQuickSuggest.cancelAndSet(function () {
                if (_this._state !== 0 /* Idle */) {
                    return;
                }
                if (!LineContext.shouldAutoTrigger(_this._editor)) {
                    return;
                }
                if (!_this._editor.hasModel()) {
                    return;
                }
                var model = _this._editor.getModel();
                var pos = _this._editor.getPosition();
                // validate enabled now
                var quickSuggestions = _this._editor.getOption(73 /* quickSuggestions */);
                if (quickSuggestions === false) {
                    return;
                }
                else if (quickSuggestions === true) {
                    // all good
                }
                else {
                    // Check the type of the token that triggered this
                    model.tokenizeIfCheap(pos.lineNumber);
                    var lineTokens = model.getLineTokens(pos.lineNumber);
                    var tokenType = lineTokens.getStandardTokenType(lineTokens.findTokenIndexAtOffset(Math.max(pos.column - 1 - 1, 0)));
                    var inValidScope = quickSuggestions.other && tokenType === 0 /* Other */
                        || quickSuggestions.comments && tokenType === 1 /* Comment */
                        || quickSuggestions.strings && tokenType === 2 /* String */;
                    if (!inValidScope) {
                        return;
                    }
                }
                // we made it till here -> trigger now
                _this.trigger({ auto: true, shy: false });
            }, this._quickSuggestDelay);
        }
        else if (this._state !== 0 /* Idle */ && e.reason === 3 /* Explicit */) {
            // suggest is active and something like cursor keys are used to move
            // the cursor. this means we can refilter at the new position
            this._refilterCompletionItems();
        }
    };
    SuggestModel.prototype._refilterCompletionItems = function () {
        var _this = this;
        // Re-filter suggestions. This MUST run async because filtering/scoring
        // uses the model content AND the cursor position. The latter is NOT
        // updated when the document has changed (the event which drives this method)
        // and therefore a little pause (next mirco task) is needed. See:
        // https://stackoverflow.com/questions/25915634/difference-between-microtask-and-macrotask-within-an-event-loop-context#25933985
        Promise.resolve().then(function () {
            if (_this._state === 0 /* Idle */) {
                return;
            }
            if (!_this._editor.hasModel()) {
                return;
            }
            var model = _this._editor.getModel();
            var position = _this._editor.getPosition();
            var ctx = new LineContext(model, position, _this._state === 2 /* Auto */, false);
            _this._onNewContext(ctx);
        });
    };
    SuggestModel.prototype.trigger = function (context, retrigger, onlyFrom, existing) {
        var _this = this;
        var _a;
        if (retrigger === void 0) { retrigger = false; }
        if (!this._editor.hasModel()) {
            return;
        }
        var model = this._editor.getModel();
        var auto = context.auto;
        var ctx = new LineContext(model, this._editor.getPosition(), auto, context.shy);
        // Cancel previous requests, change state & update UI
        this.cancel(retrigger);
        this._state = auto ? 2 /* Auto */ : 1 /* Manual */;
        this._onDidTrigger.fire({ auto: auto, shy: context.shy, position: this._editor.getPosition() });
        // Capture context when request was sent
        this._context = ctx;
        // Build context for request
        var suggestCtx = { triggerKind: (_a = context.triggerKind) !== null && _a !== void 0 ? _a : 0 /* Invoke */ };
        if (context.triggerCharacter) {
            suggestCtx = {
                triggerKind: 1 /* TriggerCharacter */,
                triggerCharacter: context.triggerCharacter
            };
        }
        this._requestToken = new CancellationTokenSource();
        // kind filter and snippet sort rules
        var snippetSuggestions = this._editor.getOption(96 /* snippetSuggestions */);
        var snippetSortOrder = 1 /* Inline */;
        switch (snippetSuggestions) {
            case 'top':
                snippetSortOrder = 0 /* Top */;
                break;
            // 	↓ that's the default anyways...
            // case 'inline':
            // 	snippetSortOrder = SnippetSortOrder.Inline;
            // 	break;
            case 'bottom':
                snippetSortOrder = 2 /* Bottom */;
                break;
        }
        var itemKindFilter = SuggestModel._createItemKindFilter(this._editor);
        var wordDistance = WordDistance.create(this._editorWorkerService, this._editor);
        var completions = provideSuggestionItems(model, this._editor.getPosition(), new CompletionOptions(snippetSortOrder, itemKindFilter, onlyFrom), suggestCtx, this._requestToken.token);
        Promise.all([completions, wordDistance]).then(function (_a) {
            var _b = __read(_a, 2), completions = _b[0], wordDistance = _b[1];
            return __awaiter(_this, void 0, void 0, function () {
                var clipboardText, model, items, cmpFn, ctx;
                var _c;
                return __generator(this, function (_d) {
                    switch (_d.label) {
                        case 0:
                            (_c = this._requestToken) === null || _c === void 0 ? void 0 : _c.dispose();
                            if (!this._editor.hasModel()) {
                                return [2 /*return*/];
                            }
                            clipboardText = existing === null || existing === void 0 ? void 0 : existing.clipboardText;
                            if (!(!clipboardText && completions.needsClipboard)) return [3 /*break*/, 2];
                            return [4 /*yield*/, this._clipboardService.readText()];
                        case 1:
                            clipboardText = _d.sent();
                            _d.label = 2;
                        case 2:
                            if (this._state === 0 /* Idle */) {
                                return [2 /*return*/];
                            }
                            model = this._editor.getModel();
                            items = completions.items;
                            if (existing) {
                                cmpFn = getSuggestionComparator(snippetSortOrder);
                                items = items.concat(existing.items).sort(cmpFn);
                            }
                            ctx = new LineContext(model, this._editor.getPosition(), auto, context.shy);
                            this._completionModel = new CompletionModel(items, this._context.column, {
                                leadingLineContent: ctx.leadingLineContent,
                                characterCountDelta: ctx.column - this._context.column
                            }, wordDistance, this._editor.getOption(101 /* suggest */), this._editor.getOption(96 /* snippetSuggestions */), clipboardText);
                            // store containers so that they can be disposed later
                            this._completionDisposables.add(completions.disposable);
                            this._onNewContext(ctx);
                            // finally report telemetry about durations
                            this._reportDurationsTelemetry(completions.durations);
                            return [2 /*return*/];
                    }
                });
            });
        }).catch(onUnexpectedError);
    };
    SuggestModel.prototype._reportDurationsTelemetry = function (durations) {
        var _this = this;
        if (this._telemetryGate++ % 230 !== 0) {
            return;
        }
        setTimeout(function () {
            _this._telemetryService.publicLog2('suggest.durations.json', { data: JSON.stringify(durations) });
            _this._logService.debug('suggest.durations.json', durations);
        });
    };
    SuggestModel._createItemKindFilter = function (editor) {
        // kind filter and snippet sort rules
        var result = new Set();
        // snippet setting
        var snippetSuggestions = editor.getOption(96 /* snippetSuggestions */);
        if (snippetSuggestions === 'none') {
            result.add(27 /* Snippet */);
        }
        // type setting
        var suggestOptions = editor.getOption(101 /* suggest */);
        if (!suggestOptions.showMethods) {
            result.add(0 /* Method */);
        }
        if (!suggestOptions.showFunctions) {
            result.add(1 /* Function */);
        }
        if (!suggestOptions.showConstructors) {
            result.add(2 /* Constructor */);
        }
        if (!suggestOptions.showFields) {
            result.add(3 /* Field */);
        }
        if (!suggestOptions.showVariables) {
            result.add(4 /* Variable */);
        }
        if (!suggestOptions.showClasses) {
            result.add(5 /* Class */);
        }
        if (!suggestOptions.showStructs) {
            result.add(6 /* Struct */);
        }
        if (!suggestOptions.showInterfaces) {
            result.add(7 /* Interface */);
        }
        if (!suggestOptions.showModules) {
            result.add(8 /* Module */);
        }
        if (!suggestOptions.showProperties) {
            result.add(9 /* Property */);
        }
        if (!suggestOptions.showEvents) {
            result.add(10 /* Event */);
        }
        if (!suggestOptions.showOperators) {
            result.add(11 /* Operator */);
        }
        if (!suggestOptions.showUnits) {
            result.add(12 /* Unit */);
        }
        if (!suggestOptions.showValues) {
            result.add(13 /* Value */);
        }
        if (!suggestOptions.showConstants) {
            result.add(14 /* Constant */);
        }
        if (!suggestOptions.showEnums) {
            result.add(15 /* Enum */);
        }
        if (!suggestOptions.showEnumMembers) {
            result.add(16 /* EnumMember */);
        }
        if (!suggestOptions.showKeywords) {
            result.add(17 /* Keyword */);
        }
        if (!suggestOptions.showWords) {
            result.add(18 /* Text */);
        }
        if (!suggestOptions.showColors) {
            result.add(19 /* Color */);
        }
        if (!suggestOptions.showFiles) {
            result.add(20 /* File */);
        }
        if (!suggestOptions.showReferences) {
            result.add(21 /* Reference */);
        }
        if (!suggestOptions.showColors) {
            result.add(22 /* Customcolor */);
        }
        if (!suggestOptions.showFolders) {
            result.add(23 /* Folder */);
        }
        if (!suggestOptions.showTypeParameters) {
            result.add(24 /* TypeParameter */);
        }
        if (!suggestOptions.showSnippets) {
            result.add(27 /* Snippet */);
        }
        if (!suggestOptions.showUsers) {
            result.add(25 /* User */);
        }
        if (!suggestOptions.showIssues) {
            result.add(26 /* Issue */);
        }
        return result;
    };
    SuggestModel.prototype._onNewContext = function (ctx) {
        var e_3, _a;
        if (!this._context) {
            // happens when 24x7 IntelliSense is enabled and still in its delay
            return;
        }
        if (ctx.lineNumber !== this._context.lineNumber) {
            // e.g. happens when pressing Enter while IntelliSense is computed
            this.cancel();
            return;
        }
        if (getLeadingWhitespace(ctx.leadingLineContent) !== getLeadingWhitespace(this._context.leadingLineContent)) {
            // cancel IntelliSense when line start changes
            // happens when the current word gets outdented
            this.cancel();
            return;
        }
        if (ctx.column < this._context.column) {
            // typed -> moved cursor LEFT -> retrigger if still on a word
            if (ctx.leadingWord.word) {
                this.trigger({ auto: this._context.auto, shy: false }, true);
            }
            else {
                this.cancel();
            }
            return;
        }
        if (!this._completionModel) {
            // happens when IntelliSense is not yet computed
            return;
        }
        if (ctx.leadingWord.word.length !== 0 && ctx.leadingWord.startColumn > this._context.leadingWord.startColumn) {
            // started a new word while IntelliSense shows -> retrigger
            // Select those providers have not contributed to this completion model and re-trigger completions for
            // them. Also adopt the existing items and merge them into the new completion model
            var inactiveProvider = new Set(CompletionProviderRegistry.all(this._editor.getModel()));
            try {
                for (var _b = __values(this._completionModel.allProvider), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var provider = _c.value;
                    inactiveProvider.delete(provider);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_3) throw e_3.error; }
            }
            var items = this._completionModel.adopt(new Set());
            this.trigger({ auto: this._context.auto, shy: false }, true, inactiveProvider, { items: items, clipboardText: this._completionModel.clipboardText });
            return;
        }
        if (ctx.column > this._context.column && this._completionModel.incomplete.size > 0 && ctx.leadingWord.word.length !== 0) {
            // typed -> moved cursor RIGHT & incomple model & still on a word -> retrigger
            var incomplete = this._completionModel.incomplete;
            var items = this._completionModel.adopt(incomplete);
            this.trigger({ auto: this._state === 2 /* Auto */, shy: false, triggerKind: 2 /* TriggerForIncompleteCompletions */ }, true, incomplete, { items: items, clipboardText: this._completionModel.clipboardText });
        }
        else {
            // typed -> moved cursor RIGHT -> update UI
            var oldLineContext = this._completionModel.lineContext;
            var isFrozen = false;
            this._completionModel.lineContext = {
                leadingLineContent: ctx.leadingLineContent,
                characterCountDelta: ctx.column - this._context.column
            };
            if (this._completionModel.items.length === 0) {
                if (LineContext.shouldAutoTrigger(this._editor) && this._context.leadingWord.endColumn < ctx.leadingWord.startColumn) {
                    // retrigger when heading into a new word
                    this.trigger({ auto: this._context.auto, shy: false }, true);
                    return;
                }
                if (!this._context.auto) {
                    // freeze when IntelliSense was manually requested
                    this._completionModel.lineContext = oldLineContext;
                    isFrozen = this._completionModel.items.length > 0;
                    if (isFrozen && ctx.leadingWord.word.length === 0) {
                        // there were results before but now there aren't
                        // and also we are not on a word anymore -> cancel
                        this.cancel();
                        return;
                    }
                }
                else {
                    // nothing left
                    this.cancel();
                    return;
                }
            }
            this._onDidSuggest.fire({
                completionModel: this._completionModel,
                auto: this._context.auto,
                shy: this._context.shy,
                isFrozen: isFrozen,
            });
        }
    };
    SuggestModel = __decorate([
        __param(1, IEditorWorkerService),
        __param(2, IClipboardService),
        __param(3, ITelemetryService),
        __param(4, ILogService)
    ], SuggestModel);
    return SuggestModel;
}());
export { SuggestModel };
