"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginWebSocketChannel = exports.PluginConnection = void 0;
/**
 * The container for message reader and writer which can be used to create connection between plugins and main side.
 */
class PluginConnection {
    constructor(reader, writer, dispose) {
        this.reader = reader;
        this.writer = writer;
        this.dispose = dispose;
    }
    forward(to, map = message => message) {
        this.reader.listen(input => {
            const output = map(input);
            to.writer.write(output);
        });
    }
}
exports.PluginConnection = PluginConnection;
/**
 * [IWebSocket](#IWebSocket) implementation over RPC.
 */
class PluginWebSocketChannel {
    constructor(connection) {
        this.connection = connection;
    }
    send(content) {
        this.connection.writer.write(content);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    onMessage(cb) {
        this.connection.reader.listen(cb);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    onError(cb) {
        this.connection.reader.onError(e => cb(e));
    }
    onClose(cb) {
        this.connection.reader.onClose(() => cb(-1, 'closed'));
    }
    dispose() {
        this.connection.dispose();
    }
}
exports.PluginWebSocketChannel = PluginWebSocketChannel;
//# sourceMappingURL=connection.js.map