/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import './hover.css';
import * as dom from '../../dom';
import { Disposable } from '../../../common/lifecycle';
import { DomScrollableElement } from '../scrollbar/scrollableElement';
var $ = dom.$;
var HoverWidget = /** @class */ (function (_super) {
    __extends(HoverWidget, _super);
    function HoverWidget() {
        var _this = _super.call(this) || this;
        _this.containerDomNode = document.createElement('div');
        _this.containerDomNode.className = 'monaco-hover';
        _this.containerDomNode.tabIndex = 0;
        _this.containerDomNode.setAttribute('role', 'tooltip');
        _this.contentsDomNode = document.createElement('div');
        _this.contentsDomNode.className = 'monaco-hover-content';
        _this._scrollbar = _this._register(new DomScrollableElement(_this.contentsDomNode, {
            consumeMouseWheelIfScrollbarIsNeeded: true
        }));
        _this.containerDomNode.appendChild(_this._scrollbar.getDomNode());
        return _this;
    }
    HoverWidget.prototype.onContentsChanged = function () {
        this._scrollbar.scanDomNode();
    };
    return HoverWidget;
}(Disposable));
export { HoverWidget };
export function renderHoverAction(parent, actionOptions, keybindingLabel) {
    var actionContainer = dom.append(parent, $('div.action-container'));
    var action = dom.append(actionContainer, $('a.action'));
    action.setAttribute('href', '#');
    action.setAttribute('role', 'button');
    if (actionOptions.iconClass) {
        dom.append(action, $("span.icon." + actionOptions.iconClass));
    }
    var label = dom.append(action, $('span'));
    label.textContent = keybindingLabel ? actionOptions.label + " (" + keybindingLabel + ")" : actionOptions.label;
    return dom.addDisposableListener(actionContainer, dom.EventType.CLICK, function (e) {
        e.stopPropagation();
        e.preventDefault();
        actionOptions.run(actionContainer);
    });
}
