/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var ViewCompositionStartEvent = /** @class */ (function () {
    function ViewCompositionStartEvent() {
        this.type = 0 /* ViewCompositionStart */;
    }
    return ViewCompositionStartEvent;
}());
export { ViewCompositionStartEvent };
var ViewCompositionEndEvent = /** @class */ (function () {
    function ViewCompositionEndEvent() {
        this.type = 1 /* ViewCompositionEnd */;
    }
    return ViewCompositionEndEvent;
}());
export { ViewCompositionEndEvent };
var ViewConfigurationChangedEvent = /** @class */ (function () {
    function ViewConfigurationChangedEvent(source) {
        this.type = 2 /* ViewConfigurationChanged */;
        this._source = source;
    }
    ViewConfigurationChangedEvent.prototype.hasChanged = function (id) {
        return this._source.hasChanged(id);
    };
    return ViewConfigurationChangedEvent;
}());
export { ViewConfigurationChangedEvent };
var ViewCursorStateChangedEvent = /** @class */ (function () {
    function ViewCursorStateChangedEvent(selections, modelSelections) {
        this.type = 3 /* ViewCursorStateChanged */;
        this.selections = selections;
        this.modelSelections = modelSelections;
    }
    return ViewCursorStateChangedEvent;
}());
export { ViewCursorStateChangedEvent };
var ViewDecorationsChangedEvent = /** @class */ (function () {
    function ViewDecorationsChangedEvent(source) {
        this.type = 4 /* ViewDecorationsChanged */;
        if (source) {
            this.affectsMinimap = source.affectsMinimap;
            this.affectsOverviewRuler = source.affectsOverviewRuler;
        }
        else {
            this.affectsMinimap = true;
            this.affectsOverviewRuler = true;
        }
    }
    return ViewDecorationsChangedEvent;
}());
export { ViewDecorationsChangedEvent };
var ViewFlushedEvent = /** @class */ (function () {
    function ViewFlushedEvent() {
        this.type = 5 /* ViewFlushed */;
        // Nothing to do
    }
    return ViewFlushedEvent;
}());
export { ViewFlushedEvent };
var ViewFocusChangedEvent = /** @class */ (function () {
    function ViewFocusChangedEvent(isFocused) {
        this.type = 6 /* ViewFocusChanged */;
        this.isFocused = isFocused;
    }
    return ViewFocusChangedEvent;
}());
export { ViewFocusChangedEvent };
var ViewLanguageConfigurationEvent = /** @class */ (function () {
    function ViewLanguageConfigurationEvent() {
        this.type = 7 /* ViewLanguageConfigurationChanged */;
    }
    return ViewLanguageConfigurationEvent;
}());
export { ViewLanguageConfigurationEvent };
var ViewLineMappingChangedEvent = /** @class */ (function () {
    function ViewLineMappingChangedEvent() {
        this.type = 8 /* ViewLineMappingChanged */;
        // Nothing to do
    }
    return ViewLineMappingChangedEvent;
}());
export { ViewLineMappingChangedEvent };
var ViewLinesChangedEvent = /** @class */ (function () {
    function ViewLinesChangedEvent(fromLineNumber, toLineNumber) {
        this.type = 9 /* ViewLinesChanged */;
        this.fromLineNumber = fromLineNumber;
        this.toLineNumber = toLineNumber;
    }
    return ViewLinesChangedEvent;
}());
export { ViewLinesChangedEvent };
var ViewLinesDeletedEvent = /** @class */ (function () {
    function ViewLinesDeletedEvent(fromLineNumber, toLineNumber) {
        this.type = 10 /* ViewLinesDeleted */;
        this.fromLineNumber = fromLineNumber;
        this.toLineNumber = toLineNumber;
    }
    return ViewLinesDeletedEvent;
}());
export { ViewLinesDeletedEvent };
var ViewLinesInsertedEvent = /** @class */ (function () {
    function ViewLinesInsertedEvent(fromLineNumber, toLineNumber) {
        this.type = 11 /* ViewLinesInserted */;
        this.fromLineNumber = fromLineNumber;
        this.toLineNumber = toLineNumber;
    }
    return ViewLinesInsertedEvent;
}());
export { ViewLinesInsertedEvent };
var ViewRevealRangeRequestEvent = /** @class */ (function () {
    function ViewRevealRangeRequestEvent(source, range, selections, verticalType, revealHorizontal, scrollType) {
        this.type = 12 /* ViewRevealRangeRequest */;
        this.source = source;
        this.range = range;
        this.selections = selections;
        this.verticalType = verticalType;
        this.revealHorizontal = revealHorizontal;
        this.scrollType = scrollType;
    }
    return ViewRevealRangeRequestEvent;
}());
export { ViewRevealRangeRequestEvent };
var ViewScrollChangedEvent = /** @class */ (function () {
    function ViewScrollChangedEvent(source) {
        this.type = 13 /* ViewScrollChanged */;
        this.scrollWidth = source.scrollWidth;
        this.scrollLeft = source.scrollLeft;
        this.scrollHeight = source.scrollHeight;
        this.scrollTop = source.scrollTop;
        this.scrollWidthChanged = source.scrollWidthChanged;
        this.scrollLeftChanged = source.scrollLeftChanged;
        this.scrollHeightChanged = source.scrollHeightChanged;
        this.scrollTopChanged = source.scrollTopChanged;
    }
    return ViewScrollChangedEvent;
}());
export { ViewScrollChangedEvent };
var ViewThemeChangedEvent = /** @class */ (function () {
    function ViewThemeChangedEvent() {
        this.type = 14 /* ViewThemeChanged */;
    }
    return ViewThemeChangedEvent;
}());
export { ViewThemeChangedEvent };
var ViewTokensChangedEvent = /** @class */ (function () {
    function ViewTokensChangedEvent(ranges) {
        this.type = 15 /* ViewTokensChanged */;
        this.ranges = ranges;
    }
    return ViewTokensChangedEvent;
}());
export { ViewTokensChangedEvent };
var ViewTokensColorsChangedEvent = /** @class */ (function () {
    function ViewTokensColorsChangedEvent() {
        this.type = 16 /* ViewTokensColorsChanged */;
        // Nothing to do
    }
    return ViewTokensColorsChangedEvent;
}());
export { ViewTokensColorsChangedEvent };
var ViewZonesChangedEvent = /** @class */ (function () {
    function ViewZonesChangedEvent() {
        this.type = 17 /* ViewZonesChanged */;
        // Nothing to do
    }
    return ViewZonesChangedEvent;
}());
export { ViewZonesChangedEvent };
