"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.NavigatableWidgetOptions = exports.NavigatableWidget = exports.Navigatable = void 0;
const widgets_1 = require("./widgets");
var Navigatable;
(function (Navigatable) {
    function is(arg) {
        return !!arg && 'getResourceUri' in arg && 'createMoveToUri' in arg;
    }
    Navigatable.is = is;
})(Navigatable = exports.Navigatable || (exports.Navigatable = {}));
var NavigatableWidget;
(function (NavigatableWidget) {
    function is(arg) {
        return arg instanceof widgets_1.BaseWidget && Navigatable.is(arg);
    }
    NavigatableWidget.is = is;
    function* getAffected(widgets, context) {
        const uris = Array.isArray(context) ? context : [context];
        return get(widgets, resourceUri => uris.some(uri => uri.isEqualOrParent(resourceUri)));
    }
    NavigatableWidget.getAffected = getAffected;
    function* get(widgets, filter = () => true) {
        for (const widget of widgets) {
            if (NavigatableWidget.is(widget)) {
                const resourceUri = widget.getResourceUri();
                if (resourceUri && filter(resourceUri)) {
                    yield [resourceUri, widget];
                }
            }
        }
    }
    NavigatableWidget.get = get;
    function getUri(widget) {
        if (is(widget)) {
            return widget.getResourceUri();
        }
    }
    NavigatableWidget.getUri = getUri;
})(NavigatableWidget = exports.NavigatableWidget || (exports.NavigatableWidget = {}));
var NavigatableWidgetOptions;
(function (NavigatableWidgetOptions) {
    function is(arg) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return !!arg && 'kind' in arg && arg.kind === 'navigatable';
    }
    NavigatableWidgetOptions.is = is;
})(NavigatableWidgetOptions = exports.NavigatableWidgetOptions || (exports.NavigatableWidgetOptions = {}));
//# sourceMappingURL=navigatable-types.js.map