/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { onUnexpectedExternalError } from '../../../base/common/errors';
import { Position } from '../../common/core/position';
import * as modes from '../../common/modes';
import { RawContextKey } from '../../../platform/contextkey/common/contextkey';
import { CancellationToken } from '../../../base/common/cancellation';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { URI } from '../../../base/common/uri';
import { assertType } from '../../../base/common/types';
import { ITextModelService } from '../../common/services/resolverService';
export var Context = {
    Visible: new RawContextKey('parameterHintsVisible', false),
    MultipleSignatures: new RawContextKey('parameterHintsMultipleSignatures', false),
};
export function provideSignatureHelp(model, position, context, token) {
    return __awaiter(this, void 0, void 0, function () {
        var supports, supports_1, supports_1_1, support, result, err_1, e_1_1;
        var e_1, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    supports = modes.SignatureHelpProviderRegistry.ordered(model);
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 8, 9, 10]);
                    supports_1 = __values(supports), supports_1_1 = supports_1.next();
                    _b.label = 2;
                case 2:
                    if (!!supports_1_1.done) return [3 /*break*/, 7];
                    support = supports_1_1.value;
                    _b.label = 3;
                case 3:
                    _b.trys.push([3, 5, , 6]);
                    return [4 /*yield*/, support.provideSignatureHelp(model, position, token, context)];
                case 4:
                    result = _b.sent();
                    if (result) {
                        return [2 /*return*/, result];
                    }
                    return [3 /*break*/, 6];
                case 5:
                    err_1 = _b.sent();
                    onUnexpectedExternalError(err_1);
                    return [3 /*break*/, 6];
                case 6:
                    supports_1_1 = supports_1.next();
                    return [3 /*break*/, 2];
                case 7: return [3 /*break*/, 10];
                case 8:
                    e_1_1 = _b.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 10];
                case 9:
                    try {
                        if (supports_1_1 && !supports_1_1.done && (_a = supports_1.return)) _a.call(supports_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 10: return [2 /*return*/, undefined];
            }
        });
    });
}
CommandsRegistry.registerCommand('_executeSignatureHelpProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, position, triggerCharacter, ref, result_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = __read(args, 3), uri = _a[0], position = _a[1], triggerCharacter = _a[2];
                    assertType(URI.isUri(uri));
                    assertType(Position.isIPosition(position));
                    assertType(typeof triggerCharacter === 'string' || !triggerCharacter);
                    return [4 /*yield*/, accessor.get(ITextModelService).createModelReference(uri)];
                case 1:
                    ref = _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, , 4, 5]);
                    return [4 /*yield*/, provideSignatureHelp(ref.object.textEditorModel, Position.lift(position), {
                            triggerKind: modes.SignatureHelpTriggerKind.Invoke,
                            isRetrigger: false,
                            triggerCharacter: triggerCharacter,
                        }, CancellationToken.None)];
                case 3:
                    result_1 = _b.sent();
                    if (!result_1) {
                        return [2 /*return*/, undefined];
                    }
                    setTimeout(function () { return result_1.dispose(); }, 0);
                    return [2 /*return*/, result_1.value];
                case 4:
                    ref.dispose();
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/];
            }
        });
    });
});
