/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.CacheKey;
import org.eclipse.buildship.core.internal.util.gradle.InspectableResultHandler;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.events.OperationType;

public class CachingBuildActionExecuter<T>
implements BuildActionExecuter<T> {
    private final BuildActionExecuter<T> delegate;
    private final Cache<Object, Object> cache;
    private final CacheKey.Builder cacheKeyBuilder;

    CachingBuildActionExecuter(BuildActionExecuter<T> delegate, BuildAction<T> buildAction, Cache<Object, Object> cache) {
        this.delegate = delegate;
        this.cache = cache;
        this.cacheKeyBuilder = CacheKey.builder().setBuildAction(buildAction);
    }

    public CachingBuildActionExecuter<T> withArguments(String ... arguments) {
        this.cacheKeyBuilder.setArguments(Arrays.asList(arguments));
        this.delegate.withArguments(arguments);
        return this;
    }

    public CachingBuildActionExecuter<T> withArguments(Iterable<String> arguments) {
        this.cacheKeyBuilder.setArguments(arguments == null ? null : Lists.newArrayList(arguments));
        this.delegate.withArguments(arguments);
        return this;
    }

    public CachingBuildActionExecuter<T> addArguments(String ... arguments) {
        this.cacheKeyBuilder.addArguments(Arrays.asList(arguments));
        this.delegate.addArguments(arguments);
        return this;
    }

    public CachingBuildActionExecuter<T> addArguments(Iterable<String> arguments) {
        this.cacheKeyBuilder.addArguments(Lists.newArrayList(arguments));
        this.delegate.addArguments(arguments);
        return this;
    }

    public CachingBuildActionExecuter<T> setStandardOutput(OutputStream outputStream) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.setStandardOutput(outputStream);
        return this;
    }

    public CachingBuildActionExecuter<T> setStandardError(OutputStream outputStream) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.setStandardError(outputStream);
        return this;
    }

    public CachingBuildActionExecuter<T> setColorOutput(boolean colorOutput) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.setColorOutput(colorOutput);
        return this;
    }

    public CachingBuildActionExecuter<T> setStandardInput(InputStream inputStream) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.setStandardInput(inputStream);
        return this;
    }

    public CachingBuildActionExecuter<T> setJavaHome(File javaHome) {
        this.cacheKeyBuilder.setJavaHome(javaHome);
        this.delegate.setJavaHome(javaHome);
        return this;
    }

    public CachingBuildActionExecuter<T> setJvmArguments(String ... jvmArguments) {
        this.cacheKeyBuilder.setJvmArguments(Arrays.asList(jvmArguments));
        this.delegate.setJvmArguments(jvmArguments);
        return this;
    }

    public CachingBuildActionExecuter<T> setJvmArguments(Iterable<String> jvmArguments) {
        this.cacheKeyBuilder.setJvmArguments(jvmArguments == null ? null : Lists.newArrayList(jvmArguments));
        this.delegate.setJvmArguments(jvmArguments);
        return this;
    }

    public CachingBuildActionExecuter<T> addJvmArguments(String ... jvmArguments) {
        this.cacheKeyBuilder.addJvmArguments(Arrays.asList(jvmArguments));
        this.delegate.addJvmArguments(jvmArguments);
        return this;
    }

    public CachingBuildActionExecuter<T> addJvmArguments(Iterable<String> jvmArguments) {
        this.cacheKeyBuilder.addJvmArguments(Lists.newArrayList(jvmArguments));
        this.delegate.addJvmArguments(jvmArguments);
        return this;
    }

    public CachingBuildActionExecuter<T> setEnvironmentVariables(Map<String, String> envVariables) {
        this.cacheKeyBuilder.setEnvironmentVariables(envVariables);
        this.delegate.setEnvironmentVariables(envVariables);
        return this;
    }

    public CachingBuildActionExecuter<T> addProgressListener(ProgressListener listener) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.addProgressListener(listener);
        return this;
    }

    public CachingBuildActionExecuter<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.addProgressListener(listener);
        return this;
    }

    public CachingBuildActionExecuter<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener, Set<OperationType> eventTypes) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.addProgressListener(listener, eventTypes);
        return this;
    }

    public CachingBuildActionExecuter<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener, OperationType ... operationTypes) {
        this.cacheKeyBuilder.markInvalid();
        this.delegate.addProgressListener(listener, operationTypes);
        return this;
    }

    public CachingBuildActionExecuter<T> withCancellationToken(CancellationToken cancellationToken) {
        this.delegate.withCancellationToken(cancellationToken);
        return this;
    }

    public CachingBuildActionExecuter<T> forTasks(String ... tasks) {
        this.cacheKeyBuilder.setTasks(Arrays.asList(tasks));
        this.delegate.forTasks(tasks);
        return this;
    }

    public CachingBuildActionExecuter<T> forTasks(Iterable<String> tasks) {
        this.cacheKeyBuilder.setTasks(tasks == null ? null : Lists.newArrayList(tasks));
        this.delegate.forTasks(tasks);
        return this;
    }

    public T run() throws GradleConnectionException, IllegalStateException {
        Object cachedValue;
        CacheKey key = this.cacheKeyBuilder.build();
        Object object = cachedValue = key.isInvalid() ? null : this.cache.getIfPresent((Object)key);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        Object result = this.delegate.run();
        this.cache.put((Object)key, result);
        return (T)result;
    }

    public void run(ResultHandler<? super T> handler) throws IllegalStateException {
        Object cachedValue;
        CacheKey key = this.cacheKeyBuilder.build();
        Object object = cachedValue = key.isInvalid() ? null : this.cache.getIfPresent((Object)key);
        if (cachedValue != null) {
            handler.onComplete(cachedValue);
        } else {
            InspectableResultHandler<? super T> inspectableResultHandler = new InspectableResultHandler<T>();
            this.delegate.run(inspectableResultHandler);
            inspectableResultHandler.getResult().ifPresent(r -> this.cache.put((Object)key, r));
            inspectableResultHandler.forwardResults(handler);
        }
    }
}

