"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultJsonSchemaContribution = exports.JsonSchemaStore = exports.JsonSchemaContribution = void 0;
const inversify_1 = require("inversify");
const contribution_provider_1 = require("../common/contribution-provider");
const endpoint_1 = require("./endpoint");
const promise_util_1 = require("../common/promise-util");
exports.JsonSchemaContribution = Symbol('JsonSchemaContribution');
let JsonSchemaStore = class JsonSchemaStore {
    constructor() {
        this._schemas = new promise_util_1.Deferred();
    }
    get schemas() {
        return this._schemas.promise;
    }
    onStart() {
        const pendingRegistrations = [];
        const schemas = [];
        const freeze = () => {
            Object.freeze(schemas);
            this._schemas.resolve(schemas);
        };
        const registerTimeout = this.getRegisterTimeout();
        const frozenErrorCode = 'JsonSchemaRegisterContext.frozen';
        const context = {
            registerSchema: schema => {
                if (Object.isFrozen(schemas)) {
                    throw new Error(frozenErrorCode);
                }
                schemas.push(schema);
            }
        };
        for (const contribution of this.contributions.getContributions()) {
            const result = contribution.registerSchemas(context);
            if (result) {
                pendingRegistrations.push(result.then(() => { }, e => {
                    if (e instanceof Error && e.message === frozenErrorCode) {
                        console.error(`${contribution.constructor.name}.registerSchemas is taking more than ${registerTimeout.toFixed(1)} ms, new schemas are ignored.`);
                    }
                    else {
                        console.error(e);
                    }
                }));
            }
        }
        if (pendingRegistrations.length) {
            let pending = Promise.all(pendingRegistrations).then(() => { });
            if (registerTimeout) {
                pending = Promise.race([pending, (0, promise_util_1.timeout)(registerTimeout)]);
            }
            pending.then(freeze);
        }
        else {
            freeze();
        }
    }
    getRegisterTimeout() {
        return 500;
    }
};
__decorate([
    (0, inversify_1.inject)(contribution_provider_1.ContributionProvider),
    (0, inversify_1.named)(exports.JsonSchemaContribution),
    __metadata("design:type", Object)
], JsonSchemaStore.prototype, "contributions", void 0);
JsonSchemaStore = __decorate([
    (0, inversify_1.injectable)()
], JsonSchemaStore);
exports.JsonSchemaStore = JsonSchemaStore;
let DefaultJsonSchemaContribution = class DefaultJsonSchemaContribution {
    async registerSchemas(context) {
        const url = `${new endpoint_1.Endpoint().httpScheme}//schemastore.azurewebsites.net/api/json/catalog.json`;
        const response = await fetch(url);
        const schemas = (await response.json()).schemas;
        for (const s of schemas) {
            if (s.fileMatch) {
                context.registerSchema({
                    fileMatch: s.fileMatch,
                    url: s.url
                });
            }
        }
    }
};
DefaultJsonSchemaContribution = __decorate([
    (0, inversify_1.injectable)()
], DefaultJsonSchemaContribution);
exports.DefaultJsonSchemaContribution = DefaultJsonSchemaContribution;
//# sourceMappingURL=json-schema-store.js.map