"use strict";
// *****************************************************************************
// Copyright (C) 2018-2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeViewWidget = exports.PluginTreeModel = exports.PluginTree = exports.TreeViewWidgetIdentifier = exports.CompositeTreeViewNode = exports.TreeViewNode = exports.VIEW_ITEM_INLINE_MENU = exports.VIEW_ITEM_CONTEXT_MENU = exports.TREE_NODE_HYPERLINK = void 0;
const vscode_uri_1 = require("@theia/core/shared/vscode-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const plugin_api_rpc_1 = require("../../../common/plugin-api-rpc");
const browser_1 = require("@theia/core/lib/browser");
const menu_1 = require("@theia/core/lib/common/menu");
const React = require("@theia/core/shared/react");
const plugin_shared_style_1 = require("../plugin-shared-style");
const widget_1 = require("@theia/core/lib/browser/widgets/widget");
const event_1 = require("@theia/core/lib/common/event");
const message_service_1 = require("@theia/core/lib/common/message-service");
const uri_1 = require("@theia/core/lib/common/uri");
const context_key_service_1 = require("@theia/core/lib/browser/context-key-service");
const markdownit = require("@theia/core/shared/markdown-it");
const markdown_string_1 = require("../../../plugin/markdown-string");
exports.TREE_NODE_HYPERLINK = 'theia-TreeNodeHyperlink';
exports.VIEW_ITEM_CONTEXT_MENU = ['view-item-context-menu'];
exports.VIEW_ITEM_INLINE_MENU = ['view-item-inline-menu'];
var TreeViewNode;
(function (TreeViewNode) {
    function is(arg) {
        return !!arg && browser_1.SelectableTreeNode.is(arg) && !browser_1.ExpandableTreeNode.is(arg) && !browser_1.CompositeTreeNode.is(arg);
    }
    TreeViewNode.is = is;
})(TreeViewNode = exports.TreeViewNode || (exports.TreeViewNode = {}));
var CompositeTreeViewNode;
(function (CompositeTreeViewNode) {
    function is(arg) {
        return !!arg && browser_1.SelectableTreeNode.is(arg) && browser_1.ExpandableTreeNode.is(arg) && browser_1.CompositeTreeNode.is(arg);
    }
    CompositeTreeViewNode.is = is;
})(CompositeTreeViewNode = exports.CompositeTreeViewNode || (exports.CompositeTreeViewNode = {}));
let TreeViewWidgetIdentifier = class TreeViewWidgetIdentifier {
};
TreeViewWidgetIdentifier = __decorate([
    (0, inversify_1.injectable)()
], TreeViewWidgetIdentifier);
exports.TreeViewWidgetIdentifier = TreeViewWidgetIdentifier;
let PluginTree = class PluginTree extends browser_1.TreeImpl {
    constructor() {
        super(...arguments);
        this.onDidChangeWelcomeStateEmitter = new event_1.Emitter();
        this.onDidChangeWelcomeState = this.onDidChangeWelcomeStateEmitter.event;
    }
    set proxy(proxy) {
        this._proxy = proxy;
    }
    get proxy() {
        return this._proxy;
    }
    set viewInfo(viewInfo) {
        this._viewInfo = viewInfo;
    }
    get isEmpty() {
        return this._isEmpty;
    }
    async resolveChildren(parent) {
        if (!this._proxy) {
            return super.resolveChildren(parent);
        }
        const children = await this.fetchChildren(this._proxy, parent);
        return children.map(value => this.createTreeNode(value, parent));
    }
    async fetchChildren(proxy, parent) {
        try {
            const children = await proxy.$getChildren(this.identifier.id, parent.id);
            const oldEmpty = this._isEmpty;
            this._isEmpty = !parent.id && (!children || children.length === 0);
            if (oldEmpty !== this._isEmpty) {
                this.onDidChangeWelcomeStateEmitter.fire();
            }
            return children || [];
        }
        catch (e) {
            if (e) {
                console.error(`Failed to fetch children for '${this.identifier.id}'`, e);
                const label = this._viewInfo ? this._viewInfo.name : this.identifier.id;
                this.notification.error(`${label}: ${e.message}`);
            }
            return [];
        }
    }
    createTreeNode(item, parent) {
        const icon = this.toIconClass(item);
        const resourceUri = item.resourceUri && vscode_uri_1.URI.revive(item.resourceUri).toString();
        const themeIconId = item.themeIconId ? item.themeIconId : item.collapsibleState !== plugin_api_rpc_1.TreeViewItemCollapsibleState.None ? 'folder' : 'file';
        const update = {
            name: item.label,
            icon,
            description: item.description,
            themeIconId,
            resourceUri,
            tooltip: item.tooltip,
            contextValue: item.contextValue,
            command: item.command,
        };
        const node = this.getNode(item.id);
        if (item.collapsibleState !== undefined && item.collapsibleState !== plugin_api_rpc_1.TreeViewItemCollapsibleState.None) {
            if (CompositeTreeViewNode.is(node)) {
                return Object.assign(node, update);
            }
            return Object.assign({
                id: item.id,
                parent,
                visible: true,
                selected: false,
                expanded: plugin_api_rpc_1.TreeViewItemCollapsibleState.Expanded === item.collapsibleState,
                children: [],
                command: item.command
            }, update);
        }
        if (TreeViewNode.is(node)) {
            return Object.assign(node, update, { command: item.command });
        }
        return Object.assign({
            id: item.id,
            parent,
            visible: true,
            selected: false,
            command: item.command,
        }, update);
    }
    toIconClass(item) {
        if (item.icon) {
            return 'fa ' + item.icon;
        }
        if (item.iconUrl) {
            const reference = this.sharedStyle.toIconClass(item.iconUrl);
            this.toDispose.push(reference);
            return reference.object.iconClass;
        }
        return undefined;
    }
};
__decorate([
    (0, inversify_1.inject)(plugin_shared_style_1.PluginSharedStyle),
    __metadata("design:type", plugin_shared_style_1.PluginSharedStyle)
], PluginTree.prototype, "sharedStyle", void 0);
__decorate([
    (0, inversify_1.inject)(TreeViewWidgetIdentifier),
    __metadata("design:type", TreeViewWidgetIdentifier)
], PluginTree.prototype, "identifier", void 0);
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], PluginTree.prototype, "notification", void 0);
PluginTree = __decorate([
    (0, inversify_1.injectable)()
], PluginTree);
exports.PluginTree = PluginTree;
let PluginTreeModel = class PluginTreeModel extends browser_1.TreeModelImpl {
    set proxy(proxy) {
        this.tree.proxy = proxy;
    }
    get proxy() {
        return this.tree.proxy;
    }
    set viewInfo(viewInfo) {
        this.tree.viewInfo = viewInfo;
    }
    get isTreeEmpty() {
        return this.tree.isEmpty;
    }
    get onDidChangeWelcomeState() {
        return this.tree.onDidChangeWelcomeState;
    }
};
__decorate([
    (0, inversify_1.inject)(PluginTree),
    __metadata("design:type", PluginTree)
], PluginTreeModel.prototype, "tree", void 0);
PluginTreeModel = __decorate([
    (0, inversify_1.injectable)()
], PluginTreeModel);
exports.PluginTreeModel = PluginTreeModel;
let TreeViewWidget = class TreeViewWidget extends browser_1.TreeViewWelcomeWidget {
    constructor() {
        super(...arguments);
        this._contextSelection = false;
    }
    init() {
        super.init();
        this.id = this.identifier.id;
        this.addClass('theia-tree-view');
        this.node.style.height = '100%';
        this.model.onDidChangeWelcomeState(this.update, this);
        this.toDispose.push(this.model.onDidChangeWelcomeState(this.update, this));
        this.toDispose.push(this.onDidChangeVisibilityEmitter);
    }
    renderIcon(node, props) {
        const icon = this.toNodeIcon(node);
        if (icon) {
            return React.createElement("div", { className: icon + ' theia-tree-view-icon' });
        }
        return undefined;
    }
    renderCaption(node, props) {
        const classes = [browser_1.TREE_NODE_SEGMENT_CLASS];
        if (!this.hasTrailingSuffixes(node)) {
            classes.push(browser_1.TREE_NODE_SEGMENT_GROW_CLASS);
        }
        const className = classes.join(' ');
        let attrs = Object.assign(Object.assign({}, this.decorateCaption(node, {})), { className, id: node.id });
        if (node.tooltip && (0, markdown_string_1.isMarkdownString)(node.tooltip)) {
            // Render markdown in custom tooltip
            const tooltip = markdownit().render(node.tooltip.value);
            attrs = Object.assign(Object.assign({}, attrs), { 'data-tip': tooltip, 'data-for': this.tooltipService.tooltipId });
        }
        else {
            const title = node.tooltip ||
                (node.resourceUri && this.labelProvider.getLongName(new uri_1.default(node.resourceUri)))
                || this.toNodeName(node);
            attrs = Object.assign(Object.assign({}, attrs), { title });
        }
        const children = [];
        const caption = this.toNodeName(node);
        const highlight = this.getDecorationData(node, 'highlight')[0];
        if (highlight) {
            children.push(this.toReactNode(caption, highlight));
        }
        const searchHighlight = this.searchHighlights && this.searchHighlights.get(node.id);
        if (searchHighlight) {
            children.push(...this.toReactNode(caption, searchHighlight));
        }
        else if (!highlight) {
            children.push(caption);
        }
        const description = this.toNodeDescription(node);
        if (description) {
            children.push(React.createElement("span", { className: 'theia-tree-view-description' }, description));
        }
        return React.createElement('div', attrs, ...children);
    }
    renderTailDecorations(node, props) {
        return this.contextKeys.with({ view: this.id, viewItem: node.contextValue }, () => {
            const menu = this.menus.getMenu(exports.VIEW_ITEM_INLINE_MENU);
            const arg = this.toTreeViewSelection(node);
            return React.createElement(React.Fragment, null, menu.children.map((item, index) => item instanceof menu_1.ActionMenuNode && this.renderInlineCommand(item, index, arg)));
        });
    }
    toTreeViewSelection(node) {
        return { treeViewId: this.id, treeItemId: node.id };
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    renderInlineCommand(node, index, arg) {
        const { icon } = node;
        if (!icon || !this.commands.isVisible(node.action.commandId, arg) || !node.action.when || !this.contextKeys.match(node.action.when)) {
            return false;
        }
        const className = [browser_1.TREE_NODE_SEGMENT_CLASS, browser_1.TREE_NODE_TAIL_CLASS, icon, widget_1.ACTION_ITEM, 'theia-tree-view-inline-action'].join(' ');
        return React.createElement("div", { key: index, className: className, title: node.label, onClick: e => {
                e.stopPropagation();
                this.commands.executeCommand(node.action.commandId, arg);
            } });
    }
    toContextMenuArgs(node) {
        return [this.toTreeViewSelection(node)];
    }
    setFlag(flag) {
        super.setFlag(flag);
        if (flag === widget_1.Widget.Flag.IsVisible) {
            this.onDidChangeVisibilityEmitter.fire(this.isVisible);
        }
    }
    clearFlag(flag) {
        super.clearFlag(flag);
        if (flag === widget_1.Widget.Flag.IsVisible) {
            this.onDidChangeVisibilityEmitter.fire(this.isVisible);
        }
    }
    handleEnter(event) {
        super.handleEnter(event);
        this.tryExecuteCommand();
    }
    handleClickEvent(node, event) {
        super.handleClickEvent(node, event);
        // If clicked on item (not collapsable icon) - execute command or toggle expansion if item has no command
        const commandMap = this.findCommands(node);
        if (commandMap.size > 0) {
            this.tryExecuteCommandMap(commandMap);
        }
        else if (this.isExpandable(node) && !this.hasShiftMask(event) && !this.hasCtrlCmdMask(event)) {
            this.model.toggleNodeExpansion(node);
        }
    }
    // execute TreeItem.command if present
    tryExecuteCommand(node) {
        this.tryExecuteCommandMap(this.findCommands(node));
    }
    tryExecuteCommandMap(commandMap) {
        commandMap.forEach((args, commandId) => {
            this.commands.executeCommand(commandId, ...args);
        });
    }
    findCommands(node) {
        const commandMap = new Map();
        const treeNodes = (node ? [node] : this.model.selectedNodes);
        for (const treeNode of treeNodes) {
            if (treeNode && treeNode.command) {
                commandMap.set(treeNode.command.id, treeNode.command.arguments || []);
            }
        }
        return commandMap;
    }
    get message() {
        return this._message;
    }
    set message(message) {
        this._message = message;
        this.update();
    }
    render() {
        const node = React.createElement('div', this.createContainerAttributes(), this.renderSearchInfo(), this.renderTree(this.model));
        this.tooltipService.update();
        return node;
    }
    renderSearchInfo() {
        if (this._message) {
            return React.createElement("div", { className: 'theia-TreeViewInfo' }, this._message);
        }
        return undefined;
    }
    shouldShowWelcomeView() {
        return (this.model.proxy === undefined || this.model.isTreeEmpty) && this.message === undefined;
    }
};
__decorate([
    (0, inversify_1.inject)(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], TreeViewWidget.prototype, "menus", void 0);
__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "contextKeys", void 0);
__decorate([
    (0, inversify_1.inject)(TreeViewWidgetIdentifier),
    __metadata("design:type", TreeViewWidgetIdentifier)
], TreeViewWidget.prototype, "identifier", void 0);
__decorate([
    (0, inversify_1.inject)(PluginTreeModel),
    __metadata("design:type", PluginTreeModel)
], TreeViewWidget.prototype, "model", void 0);
__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "contextKeyService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.TooltipService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "tooltipService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TreeViewWidget.prototype, "init", null);
TreeViewWidget = __decorate([
    (0, inversify_1.injectable)()
], TreeViewWidget);
exports.TreeViewWidget = TreeViewWidget;
//# sourceMappingURL=tree-view-widget.js.map