/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import com.microsoft.java.test.plugin.model.TestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.searcher.BaseFrameworkSearcher;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class JUnit5TestSearcher
extends BaseFrameworkSearcher {
    public static final String JUPITER_NESTED = "org.junit.jupiter.api.Nested";
    public static final String JUNIT_PLATFORM_TESTABLE = "org.junit.platform.commons.annotation.Testable";
    public static final String JUPITER_TEST = "org.junit.jupiter.api.Test";
    public static final String JUPITER_PARAMETERIZED_TEST = "org.junit.jupiter.params.ParameterizedTest";
    public static final String JUPITER_REPEATED_TEST = "org.junit.jupiter.api.RepeatedTest";
    public static final String JUPITER_TEST_FACTORY = "org.junit.jupiter.api.TestFactory";
    public static final String JUPITER_TEST_TEMPLATE = "org.junit.jupiter.api.TestTemplate";
    protected static final String DISPLAY_NAME_ANNOTATION_JUNIT5 = "org.junit.jupiter.api.DisplayName";

    public JUnit5TestSearcher() {
        this.testMethodAnnotations = new String[]{JUPITER_TEST, JUPITER_PARAMETERIZED_TEST, JUPITER_REPEATED_TEST, JUPITER_TEST_FACTORY, JUPITER_TEST_TEMPLATE, JUNIT_PLATFORM_TESTABLE};
        this.testClassAnnotations = new String[]{JUNIT_PLATFORM_TESTABLE, JUPITER_NESTED};
    }

    @Override
    public TestKind getTestKind() {
        return TestKind.JUnit5;
    }

    @Override
    public String getJdtTestKind() {
        return "org.eclipse.jdt.junit.loader.junit5";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTestMethod(IMethod method) {
        try {
            int flags = method.getFlags();
            if (Flags.isAbstract((int)flags) || Flags.isStatic((int)flags) || Flags.isPrivate((int)flags)) {
                return false;
            }
            if (method.isConstructor()) {
                return false;
            }
            String[] stringArray = this.testMethodAnnotations;
            int n = this.testMethodAnnotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String annotation = stringArray[n2];
                if (TestFrameworkUtils.hasAnnotation((IMember)method, annotation, true)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    @Override
    public boolean isTestMethod(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isAbstract((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers)) {
            return false;
        }
        if (methodBinding.isConstructor()) {
            return false;
        }
        return this.findAnnotation(methodBinding.getAnnotations(), this.getTestMethodAnnotations());
    }

    @Override
    public TestItem parseTestItem(IMethod method) throws JavaModelException {
        TestItem item = super.parseTestItem(method);
        Optional<IAnnotation> annotation = TestFrameworkUtils.getAnnotation((IMember)method, DISPLAY_NAME_ANNOTATION_JUNIT5, false);
        if (annotation.isPresent()) {
            item.setDisplayName((String)annotation.get().getMemberValuePairs()[0].getValue());
        }
        return item;
    }

    @Override
    public TestItem parseTestItem(IMethodBinding methodBinding) throws JavaModelException {
        TestItem item = super.parseTestItem(methodBinding);
        IAnnotationBinding[] iAnnotationBindingArray = methodBinding.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation != null && this.matchesName(annotation.getAnnotationType(), DISPLAY_NAME_ANNOTATION_JUNIT5)) {
                item.setDisplayName((String)annotation.getAllMemberValuePairs()[0].getValue());
                break;
            }
            ++n2;
        }
        return item;
    }

    @Override
    public boolean findAnnotation(IAnnotationBinding[] annotations, String[] annotationNames) {
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation != null) {
                String[] stringArray = annotationNames;
                int n3 = annotationNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    HashSet<ITypeBinding> hierarchy;
                    String annotationName = stringArray[n4];
                    if (this.matchesName(annotation.getAnnotationType(), annotationName)) {
                        return true;
                    }
                    if ((JUPITER_NESTED.equals(annotationName) || JUNIT_PLATFORM_TESTABLE.equals(annotationName)) && this.matchesNameInAnnotationHierarchy(annotation, annotationName, hierarchy = new HashSet<ITypeBinding>())) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean matchesName(ITypeBinding annotationType, String annotationName) {
        return TestFrameworkUtils.isEquivalentAnnotationType(annotationType, annotationName);
    }

    private boolean matchesNameInAnnotationHierarchy(IAnnotationBinding annotation, String annotationName, Set<ITypeBinding> hierarchy) {
        ITypeBinding type = annotation.getAnnotationType();
        if (type == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = type.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding annotationType;
            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
            if (annotationBinding != null && (annotationType = annotationBinding.getAnnotationType()) != null && hierarchy.add(annotationType) && (this.matchesName(annotationType, annotationName) || this.matchesNameInAnnotationHierarchy(annotationBinding, annotationName, hierarchy))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

