/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.eclipse.jdt.ls.core.internal.corext.util.JavaElementUtil;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.DeleteFileOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class ChangeUtil {
    private static final String TEMP_FILE_NAME = ".temp";
    private static final Range ZERO_RANGE = new Range(new Position(), new Position());

    public static WorkspaceEdit convertToWorkspaceEdit(Change change) throws CoreException {
        WorkspaceEdit edit = new WorkspaceEdit();
        if (change instanceof CompositeChange) {
            ChangeUtil.convertCompositeChange((CompositeChange)change, edit);
        } else {
            ChangeUtil.convertSingleChange(change, edit);
        }
        return edit;
    }

    private static void convertSingleChange(Change change, WorkspaceEdit edit) throws CoreException {
        if (change instanceof CompositeChange) {
            return;
        }
        if (change instanceof TextChange) {
            ChangeUtil.convertTextChange((TextChange)change, edit);
        } else if (change instanceof ResourceChange) {
            ChangeUtil.convertResourceChange((ResourceChange)change, edit);
        }
    }

    private static void convertCompositeChange(CompositeChange change, WorkspaceEdit edit) throws CoreException {
        Change[] changes;
        Change[] changeArray = changes = change.getChildren();
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change ch = changeArray[n2];
            if (ch instanceof CompositeChange) {
                ChangeUtil.convertCompositeChange((CompositeChange)ch, edit);
            } else {
                ChangeUtil.convertSingleChange(ch, edit);
            }
            ++n2;
        }
    }

    private static void convertResourceChange(ResourceChange resourceChange, WorkspaceEdit edit) throws CoreException {
        if (!JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isResourceOperationSupported()) {
            return;
        }
        ArrayList changes = edit.getDocumentChanges();
        if (changes == null) {
            changes = new ArrayList();
            edit.setDocumentChanges(changes);
        }
        if (resourceChange instanceof RenameCompilationUnitChange) {
            ChangeUtil.convertCUResourceChange(edit, (RenameCompilationUnitChange)resourceChange);
        } else if (resourceChange instanceof RenamePackageChange) {
            ChangeUtil.convertRenamePackcageChange(edit, (RenamePackageChange)resourceChange);
        } else if (resourceChange instanceof MoveCompilationUnitChange) {
            ChangeUtil.convertMoveCompilationUnitChange(edit, (MoveCompilationUnitChange)resourceChange);
        } else if (resourceChange instanceof CreateFileChange) {
            ChangeUtil.convertCreateFileChange(edit, (CreateFileChange)resourceChange);
        } else if (resourceChange instanceof CreateCompilationUnitChange) {
            ChangeUtil.convertCreateCompilationUnitChange(edit, (CreateCompilationUnitChange)resourceChange);
        }
    }

    private static void convertMoveCompilationUnitChange(WorkspaceEdit edit, MoveCompilationUnitChange change) throws JavaModelException {
        String oldPackageName;
        IPackageFragment newPackage = change.getDestinationPackage();
        ICompilationUnit unit = change.getCu();
        CompilationUnit astCU = RefactoringASTParser.parseWithASTProvider((ITypeRoot)unit, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        ASTRewrite rewrite = ASTRewrite.create((AST)astCU.getAST());
        IPackageDeclaration[] packDecls = unit.getPackageDeclarations();
        String string = oldPackageName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
        if (!Objects.equals(oldPackageName, newPackage.getElementName()) && ChangeUtil.updatePackageStatement(astCU, newPackage.getElementName(), rewrite, unit)) {
            ChangeUtil.convertTextEdit(edit, unit, rewrite.rewriteAST());
        }
        RenameFile cuResourceChange = new RenameFile();
        cuResourceChange.setOldUri(JDTUtils.toURI(unit));
        IPath newCUPath = newPackage.getResource().getLocation().append(unit.getPath().lastSegment());
        String newUri = ResourceUtils.fixURI(newCUPath.toFile().toURI());
        cuResourceChange.setNewUri(newUri);
        edit.getDocumentChanges().add(Either.forRight((Object)cuResourceChange));
    }

    private static void convertCreateCompilationUnitChange(WorkspaceEdit edit, CreateCompilationUnitChange change) {
        ICompilationUnit unit = change.getCu();
        CreateFile createFile = new CreateFile();
        createFile.setUri(JDTUtils.toURI(unit));
        createFile.setOptions(new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)));
        edit.getDocumentChanges().add(Either.forRight((Object)createFile));
        InsertEdit textEdit = new InsertEdit(0, change.getPreview());
        ChangeUtil.convertTextEdit(edit, unit, (TextEdit)textEdit);
    }

    private static void convertRenamePackcageChange(WorkspaceEdit edit, RenamePackageChange packageChange) throws CoreException {
        IPackageFragment pack = (IPackageFragment)packageChange.getModifiedElement();
        Path newPackageFragment = new Path(packageChange.getNewName().replace('.', '/'));
        Path oldPackageFragment = new Path(packageChange.getOldName().replace('.', '/'));
        IPath newPackagePath = pack.getResource().getLocation().removeLastSegments(oldPackageFragment.segmentCount()).append((IPath)newPackageFragment);
        if (packageChange.getRenameSubpackages()) {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
            String oldPrefix = packageChange.getOldName();
            IPackageFragment[] iPackageFragmentArray = allPackages;
            int n = allPackages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment currentPackage = iPackageFragmentArray[n2];
                String newPkgName = String.valueOf(packageChange.getNewName()) + currentPackage.getElementName().substring(oldPrefix.length());
                ChangeUtil.convertPackageUpdateEdit(currentPackage.getCompilationUnits(), newPkgName, edit);
                ++n2;
            }
            RenameFile renameFile = new RenameFile();
            renameFile.setNewUri(ResourceUtils.fixURI(newPackagePath.toFile().toURI()));
            renameFile.setOldUri(ResourceUtils.fixURI(pack.getResource().getRawLocationURI()));
            edit.getDocumentChanges().add(Either.forRight((Object)renameFile));
        } else {
            ChangeUtil.convertPackageUpdateEdit(pack.getCompilationUnits(), packageChange.getNewName(), edit);
            CreateFile createFile = new CreateFile();
            createFile.setUri(ResourceUtils.fixURI(newPackagePath.append(TEMP_FILE_NAME).toFile().toURI()));
            createFile.setOptions(new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)));
            edit.getDocumentChanges().add(Either.forRight((Object)createFile));
            ICompilationUnit[] iCompilationUnitArray = pack.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n3 = 0;
            while (n3 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n3];
                RenameFile cuResourceChange = new RenameFile();
                cuResourceChange.setOldUri(ResourceUtils.fixURI(unit.getResource().getLocationURI()));
                IPath newCUPath = newPackagePath.append(unit.getPath().lastSegment());
                cuResourceChange.setNewUri(ResourceUtils.fixURI(newCUPath.toFile().toURI()));
                edit.getDocumentChanges().add(Either.forRight((Object)cuResourceChange));
                ++n3;
            }
            DeleteFile deleteFile = new DeleteFile();
            deleteFile.setUri(ResourceUtils.fixURI(newPackagePath.append(TEMP_FILE_NAME).toFile().toURI()));
            deleteFile.setOptions(new DeleteFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)));
            edit.getDocumentChanges().add(Either.forRight((Object)deleteFile));
        }
    }

    private static void convertCUResourceChange(WorkspaceEdit edit, RenameCompilationUnitChange cuChange) {
        ICompilationUnit modifiedCU = (ICompilationUnit)cuChange.getModifiedElement();
        RenameFile rf = new RenameFile();
        String newCUName = cuChange.getNewName();
        IPath currentPath = modifiedCU.getResource().getLocation();
        rf.setOldUri(ResourceUtils.fixURI(modifiedCU.getResource().getRawLocationURI()));
        IPath newPath = currentPath.removeLastSegments(1).append(newCUName);
        rf.setNewUri(ResourceUtils.fixURI(newPath.toFile().toURI()));
        edit.getDocumentChanges().add(Either.forRight((Object)rf));
    }

    private static void convertCreateFileChange(WorkspaceEdit edit, CreateFileChange createFileChange) {
        CreateFile createFile = new CreateFile();
        createFile.setUri(ResourceUtils.fixURI(createFileChange.getPath().toFile().toURI()));
        createFile.setOptions(new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)));
        edit.getDocumentChanges().add(Either.forRight((Object)createFile));
    }

    private static void convertTextChange(TextChange textChange, WorkspaceEdit rootEdit) {
        Object modifiedElement = textChange.getModifiedElement();
        if (!(modifiedElement instanceof IJavaElement)) {
            return;
        }
        TextEdit textEdits = textChange.getEdit();
        if (textEdits == null) {
            return;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)((IJavaElement)modifiedElement).getAncestor(5);
        ChangeUtil.convertTextEdit(rootEdit, compilationUnit, textEdits);
    }

    private static void convertTextEdit(WorkspaceEdit root, ICompilationUnit unit, TextEdit edit) {
        if (edit == null) {
            return;
        }
        TextEditConverter converter = new TextEditConverter(unit, edit);
        String uri = JDTUtils.toURI(unit);
        if (JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isResourceOperationSupported()) {
            ArrayList<Either> changes = root.getDocumentChanges();
            if (changes == null) {
                changes = new ArrayList<Either>();
                root.setDocumentChanges(changes);
            }
            VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0));
            TextDocumentEdit documentEdit = new TextDocumentEdit(identifier, converter.convert());
            changes.add(Either.forLeft((Object)documentEdit));
        } else {
            Map changes = root.getChanges();
            if (changes.containsKey(uri)) {
                ((List)changes.get(uri)).addAll(converter.convert());
            } else {
                changes.put(uri, converter.convert());
            }
        }
    }

    private static ICompilationUnit getNewCompilationUnit(IType type, String newName) {
        ICompilationUnit cu = type.getCompilationUnit();
        if (ChangeUtil.isPrimaryType(type)) {
            IPackageFragment parent = type.getPackageFragment();
            String renamedCUName = JavaModelUtil.getRenamedCUName((ICompilationUnit)cu, (String)newName);
            return parent.getCompilationUnit(renamedCUName);
        }
        return cu;
    }

    private static boolean isPrimaryType(IType type) {
        String cuName = type.getCompilationUnit().getElementName();
        String typeName = type.getElementName();
        return type.getDeclaringType() == null && JavaCore.removeJavaLikeExtension((String)cuName).equals(typeName);
    }

    private static void convertPackageUpdateEdit(ICompilationUnit[] cus, String newPkgName, WorkspaceEdit rootEdit) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = cus;
        int n = cus.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            ChangeUtil.convertPackageUpdateEdit(cu, newPkgName, rootEdit);
            ++n2;
        }
    }

    private static void convertPackageUpdateEdit(ICompilationUnit cu, String newPkgName, WorkspaceEdit rootEdit) throws JavaModelException {
        ASTRewrite rewrite;
        CompilationUnit unit = new RefactoringASTParser(15).parse((ITypeRoot)cu, true);
        if (ChangeUtil.updatePackageStatement(unit, newPkgName, rewrite = ASTRewrite.create((AST)unit.getAST()), cu)) {
            TextEdit textEdit = rewrite.rewriteAST();
            ChangeUtil.convertTextEdit(rootEdit, cu, textEdit);
        }
    }

    private static boolean updatePackageStatement(CompilationUnit astCU, String pkgName, ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        boolean defaultPackage = pkgName.isEmpty();
        AST ast = astCU.getAST();
        if (defaultPackage) {
            int extendedStart;
            PackageDeclaration pkg = astCU.getPackage();
            if (pkg == null) {
                return false;
            }
            Javadoc javadoc = pkg.getJavadoc();
            int pkgStart = javadoc != null ? javadoc.getStartPosition() + javadoc.getLength() + 1 : pkg.getStartPosition();
            if (pkgStart != (extendedStart = astCU.getExtendedStartPosition((ASTNode)pkg))) {
                String commentSource = cu.getSource().substring(extendedStart, pkgStart);
                ASTNode comment = rewriter.createStringPlaceholder(commentSource, 35);
                rewriter.set((ASTNode)astCU, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)comment, null);
            } else {
                rewriter.set((ASTNode)astCU, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, null, null);
            }
        } else {
            PackageDeclaration pkg = astCU.getPackage();
            if (pkg != null) {
                if (Objects.equals(pkg.getName().getFullyQualifiedName(), pkgName)) {
                    return false;
                }
                Name name = ast.newName(pkgName);
                rewriter.set((ASTNode)pkg, (StructuralPropertyDescriptor)PackageDeclaration.NAME_PROPERTY, (Object)name, null);
            } else {
                pkg = ast.newPackageDeclaration();
                pkg.setName(ast.newName(pkgName));
                rewriter.set((ASTNode)astCU, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)pkg, null);
            }
        }
        return true;
    }

    public static boolean hasChanges(WorkspaceEdit edit) {
        if (edit == null) {
            return false;
        }
        if (edit.getDocumentChanges() != null && !edit.getDocumentChanges().isEmpty()) {
            return true;
        }
        boolean hasChanges = false;
        if (edit.getChanges() != null && !edit.getChanges().isEmpty()) {
            hasChanges = edit.getChanges().values().stream().filter(changes -> changes != null && !changes.isEmpty() && ChangeUtil.hasChanges(changes)).findFirst().isPresent();
        }
        return hasChanges;
    }

    public static boolean hasChanges(List<org.eclipse.lsp4j.TextEdit> edits) {
        if (edits == null) {
            return false;
        }
        return edits.stream().filter(edit -> !edit.getRange().equals((Object)ZERO_RANGE) || !"".equals(edit.getNewText())).findFirst().isPresent();
    }

    public static WorkspaceEdit mergeChanges(WorkspaceEdit editA, WorkspaceEdit editB) {
        return ChangeUtil.mergeChanges(editA, editB, false);
    }

    public static WorkspaceEdit mergeChanges(WorkspaceEdit editA, WorkspaceEdit editB, boolean ignoreResourceChange) {
        if (editA == null && editB == null) {
            return null;
        }
        WorkspaceEdit result = new WorkspaceEdit();
        ChangeUtil.appendChanges(result, editA, ignoreResourceChange);
        ChangeUtil.appendChanges(result, editB, ignoreResourceChange);
        return result;
    }

    private static void appendChanges(WorkspaceEdit root, WorkspaceEdit child, boolean ignoreResourceChange) {
        if (root == null || child == null) {
            return;
        }
        if (child.getChanges() != null && !child.getChanges().isEmpty()) {
            if (root.getChanges() == null) {
                root.setChanges(new LinkedHashMap());
            }
            for (Map.Entry entry : child.getChanges().entrySet()) {
                root.getChanges().computeIfAbsent((String)entry.getKey(), key -> new ArrayList());
                ((List)root.getChanges().get(entry.getKey())).addAll((Collection)entry.getValue());
            }
        }
        if (child.getDocumentChanges() != null && !child.getDocumentChanges().isEmpty()) {
            if (root.getDocumentChanges() == null) {
                root.setDocumentChanges(new ArrayList());
            }
            if (ignoreResourceChange) {
                root.getDocumentChanges().addAll(child.getDocumentChanges().stream().filter(change -> change.isLeft()).collect(Collectors.toList()));
            } else {
                root.getDocumentChanges().addAll(child.getDocumentChanges());
            }
        }
    }
}

