/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvParserFactory;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvFileSource> {
    private final BiFunction<Class<?>, String, InputStream> inputStreamProvider;
    private CsvFileSource annotation;
    private String[] resources;
    private Charset charset;
    private int numLinesToSkip;
    private CsvParser csvParser;

    CsvFileArgumentsProvider() {
        this(Class::getResourceAsStream);
    }

    CsvFileArgumentsProvider(BiFunction<Class<?>, String, InputStream> inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    public void accept(CsvFileSource annotation) {
        this.annotation = annotation;
        this.resources = annotation.resources();
        this.charset = this.getCharsetFrom(annotation);
        this.numLinesToSkip = annotation.numLinesToSkip();
        this.csvParser = CsvParserFactory.createParserFor(annotation);
    }

    private Charset getCharsetFrom(CsvFileSource annotation) {
        try {
            return Charset.forName(annotation.encoding());
        }
        catch (Exception ex) {
            throw new PreconditionViolationException("The charset supplied in " + annotation + " is invalid", (Throwable)ex);
        }
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Arrays.stream(this.resources).map(resource -> this.openInputStream(context, (String)resource)).map(this::beginParsing).flatMap(this::toStream);
    }

    private InputStream openInputStream(ExtensionContext context, String resource) {
        Preconditions.notBlank((String)resource, (String)("Classpath resource [" + resource + "] must not be null or blank"));
        Class testClass = context.getRequiredTestClass();
        return (InputStream)Preconditions.notNull((Object)this.inputStreamProvider.apply(testClass, resource), () -> "Classpath resource [" + resource + "] does not exist");
    }

    private CsvParser beginParsing(InputStream inputStream) {
        try {
            this.csvParser.beginParsing(inputStream, this.charset);
        }
        catch (Throwable throwable) {
            CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        return this.csvParser;
    }

    private Stream<Arguments> toStream(CsvParser csvParser) {
        CsvParserIterator iterator = new CsvParserIterator(csvParser, this.annotation);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).skip(this.numLinesToSkip).onClose(() -> {
            try {
                csvParser.stopParsing();
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
        });
    }

    private static class CsvParserIterator
    implements Iterator<Arguments> {
        private final CsvParser csvParser;
        private final CsvFileSource annotation;
        private final Set<String> nullValues;
        private Object[] nextCsvRecord;

        CsvParserIterator(CsvParser csvParser, CsvFileSource annotation) {
            this.csvParser = csvParser;
            this.annotation = annotation;
            this.nullValues = CollectionUtils.toSet((Object[])annotation.nullValues());
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextCsvRecord != null;
        }

        @Override
        public Arguments next() {
            Arguments result = Arguments.arguments(this.nextCsvRecord);
            this.advance();
            return result;
        }

        private void advance() {
            String[] parsedLine = null;
            try {
                parsedLine = this.csvParser.parseNext();
                if (parsedLine != null && !this.nullValues.isEmpty()) {
                    for (int i = 0; i < parsedLine.length; ++i) {
                        if (!this.nullValues.contains(parsedLine[i])) continue;
                        parsedLine[i] = null;
                    }
                }
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
            this.nextCsvRecord = parsedLine;
        }
    }
}

