/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ICleanUpCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFixCore;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUpCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;

public final class SerialVersionSubProcessor {
    public static final void getSerialVersionProposals(IInvocationContext context, IProblemLocationCore location, Collection<ChangeCorrectionProposal> proposals) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)location);
        Assert.isNotNull(proposals);
        IProposableFix[] fixes = PotentialProgrammingProblemsFixCore.createMissingSerialVersionFixes((CompilationUnit)context.getASTRoot(), (IProblemLocationCore)location);
        if (fixes != null) {
            proposals.add(new SerialVersionProposal(fixes[0], 9, context, true));
            ICompilationUnit unit = context.getCompilationUnit();
            if (unit != null && unit.getJavaProject() != null && !"jdt.ls-java-project".equals(unit.getJavaProject().getProject().getName())) {
                proposals.add(new SerialVersionProposal(fixes[1], 9, context, false));
            }
        }
    }

    public static final class SerialVersionProposal
    extends FixCorrectionProposal {
        private boolean fIsDefaultProposal;

        public SerialVersionProposal(IProposableFix fix, int relevance, IInvocationContext context, boolean isDefault) {
            super(fix, SerialVersionProposal.createCleanUp(isDefault), relevance, context);
            this.fIsDefaultProposal = isDefault;
        }

        public boolean isDefaultProposal() {
            return this.fIsDefaultProposal;
        }

        private static ICleanUpCore createCleanUp(boolean isDefault) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_serial_version_id", "true");
            if (isDefault) {
                options.put("cleanup.add_default_serial_version_id", "true");
            } else {
                options.put("cleanup.add_generated_serial_version_id", "true");
            }
            return new PotentialProgrammingProblemsCleanUpCore(options);
        }

        @Override
        public String getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.fIsDefaultProposal) {
                return CorrectionMessages.SerialVersionDefaultProposal_message_default_info;
            }
            return CorrectionMessages.SerialVersionHashProposal_message_generated_info;
        }
    }
}

