"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIEditor = exports.getCodeEditor = exports.isCompositeEditor = exports.isDiffEditor = exports.isCodeEditor = void 0;
const editorCommon = require("../common/editorCommon");
/**
 *@internal
 */
function isCodeEditor(thing) {
    if (thing && typeof thing.getEditorType === 'function') {
        return thing.getEditorType() === editorCommon.EditorType.ICodeEditor;
    }
    else {
        return false;
    }
}
exports.isCodeEditor = isCodeEditor;
/**
 *@internal
 */
function isDiffEditor(thing) {
    if (thing && typeof thing.getEditorType === 'function') {
        return thing.getEditorType() === editorCommon.EditorType.IDiffEditor;
    }
    else {
        return false;
    }
}
exports.isDiffEditor = isDiffEditor;
/**
 *@internal
 */
function isCompositeEditor(thing) {
    return !!thing
        && typeof thing === 'object'
        && typeof thing.onDidChangeActiveEditor === 'function';
}
exports.isCompositeEditor = isCompositeEditor;
/**
 *@internal
 */
function getCodeEditor(thing) {
    if (isCodeEditor(thing)) {
        return thing;
    }
    if (isDiffEditor(thing)) {
        return thing.getModifiedEditor();
    }
    return null;
}
exports.getCodeEditor = getCodeEditor;
/**
 *@internal
 */
function getIEditor(thing) {
    if (isCodeEditor(thing) || isDiffEditor(thing)) {
        return thing;
    }
    return null;
}
exports.getIEditor = getIEditor;
//# sourceMappingURL=editorBrowser.js.map