/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import com.microsoft.java.test.plugin.model.TestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.searcher.TestFrameworkSearcher;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import com.microsoft.java.test.plugin.util.TestItemUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.search.SearchPattern;

public abstract class BaseFrameworkSearcher
implements TestFrameworkSearcher {
    protected String[] testMethodAnnotations;
    protected String[] testClassAnnotations;

    @Override
    public abstract TestKind getTestKind();

    @Override
    public String[] getTestMethodAnnotations() {
        return this.testMethodAnnotations;
    }

    @Override
    public String[] getTestClassAnnotations() {
        return this.testClassAnnotations;
    }

    @Override
    public boolean isTestClass(IType type) {
        String[] stringArray = this.getTestClassAnnotations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            if (TestFrameworkUtils.hasAnnotation((IMember)type, annotation, false)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public SearchPattern getSearchPattern() {
        if (this.getTestMethodAnnotations().length <= 0) {
            throw new RuntimeException("Failed to initialize the supported test annotations for " + this.getClass().getName());
        }
        SearchPattern searchPattern = SearchPattern.createPattern((String)this.getTestMethodAnnotations()[0], (int)8, (int)65536, (int)0);
        int i = 1;
        while (i < this.getTestMethodAnnotations().length) {
            searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)SearchPattern.createPattern((String)this.getTestMethodAnnotations()[i], (int)8, (int)65536, (int)0));
            ++i;
        }
        String[] stringArray = this.getTestClassAnnotations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String classAnnotation = stringArray[n2];
            searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)SearchPattern.createPattern((String)classAnnotation, (int)8, (int)65536, (int)0));
            ++n2;
        }
        return searchPattern;
    }

    @Override
    public boolean findAnnotation(IAnnotationBinding[] annotations, String[] annotationNames) {
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = annotation.getAnnotationType();
            String[] stringArray = annotationNames;
            int n3 = annotationNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String annotationName = stringArray[n4];
                if (TestFrameworkUtils.isEquivalentAnnotationType(annotationType, annotationName)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public TestItem parseTestItem(IMethod method) throws JavaModelException {
        return TestItemUtils.constructTestItem((IJavaElement)method, TestLevel.METHOD, this.getTestKind());
    }

    @Override
    public TestItem parseTestItem(IType type) throws JavaModelException {
        return TestItemUtils.constructTestItem((IJavaElement)type, TestLevel.CLASS, this.getTestKind());
    }

    @Override
    public TestItem parseTestItem(IMethodBinding methodBinding) throws JavaModelException {
        return TestItemUtils.constructTestItem((IJavaElement)((IMethod)methodBinding.getJavaElement()), TestLevel.METHOD, this.getTestKind());
    }
}

