/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.Chain;
import org.eclipse.jdt.internal.ui.text.ChainElement;
import org.eclipse.jdt.internal.ui.text.ChainElementAnalyzer;
import org.eclipse.jdt.internal.ui.text.ChainFinder;
import org.eclipse.jdt.internal.ui.text.ChainType;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.TextEdit;

public class ChainCompletionProposalComputer {
    private static final char[] KEYWORD_NEW = "new".toCharArray();
    private List<ChainElement> entrypoints;
    private String[] excludedTypes;
    private ICompilationUnit cu;
    private CompletionProposalRequestor coll;
    private Map<String, List<TextEdit>> additionalEdits = new HashMap<String, List<TextEdit>>();
    private boolean snippetStringSupported;

    public ChainCompletionProposalComputer(ICompilationUnit cu, CompletionProposalRequestor coll, boolean snippetStringSupported) {
        this.cu = cu;
        this.coll = coll;
        this.snippetStringSupported = snippetStringSupported;
    }

    public List<CompletionItem> computeCompletionProposals() {
        if (!this.shouldPerformCompletionOnExpectedType()) {
            return Collections.emptyList();
        }
        return this.executeCallChainSearch();
    }

    private List<CompletionItem> executeCallChainSearch() {
        int maxChains = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.max_chains", (IJavaProject)this.cu.getJavaProject()));
        int minDepth = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.min_chain_length", (IJavaProject)this.cu.getJavaProject()));
        int maxDepth = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.max_chain_length", (IJavaProject)this.cu.getJavaProject()));
        this.excludedTypes = JavaManipulation.getPreference((String)"recommenders.chain.ignore_types", (IJavaProject)this.cu.getJavaProject()).split("\\|");
        int i = 0;
        while (i < this.excludedTypes.length) {
            this.excludedTypes[i] = "L" + this.excludedTypes[i].replace('.', '/');
            ++i;
        }
        IType invocationType = this.cu.findPrimaryType();
        List<ChainType> expectedTypes = ChainCompletionProposalComputer.resolveBindingsForExpectedTypes(this.cu.getJavaProject(), this.coll.getContext());
        ChainFinder mainFinder = new ChainFinder(expectedTypes, Arrays.asList(this.excludedTypes), invocationType);
        ChainFinder contextFinder = new ChainFinder(expectedTypes, Arrays.asList(this.excludedTypes), invocationType);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CompletableFuture<Void> mainChains = CompletableFuture.runAsync(() -> {
                if (this.findEntrypoints(expectedTypes, this.cu.getJavaProject())) {
                    mainFinder.startChainSearch(this.entrypoints, maxChains, minDepth, maxDepth);
                }
            }, executor);
            CompletableFuture<Void> contextChains = CompletableFuture.runAsync(() -> {
                try {
                    List<ChainElement> contextEntrypoint = this.computeContextEntrypoint(expectedTypes, this.cu.getJavaProject());
                    if (!contextEntrypoint.isEmpty()) {
                        contextFinder.startChainSearch(contextEntrypoint, maxChains, 1, 2);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }, executor);
            CompletableFuture<Void> future = CompletableFuture.allOf(mainChains, contextChains);
            long timeout = Long.parseLong(JavaManipulation.getPreference((String)"recommenders.chain.timeout", (IJavaProject)this.cu.getJavaProject()));
            future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            mainFinder.cancel();
            contextFinder.cancel();
            executor.shutdownNow();
        }
        ArrayList<Chain> found = new ArrayList<Chain>();
        found.addAll(mainFinder.getChains());
        found.addAll(contextFinder.getChains());
        return this.buildCompletionProposals(found);
    }

    private List<CompletionItem> buildCompletionProposals(List<Chain> chains) {
        LinkedList<CompletionItem> proposals = new LinkedList<CompletionItem>();
        for (Chain chain : chains) {
            try {
                proposals.add(this.create(chain));
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return proposals;
    }

    private boolean findEntrypoints(List<ChainType> expectedTypes, IJavaProject project) {
        IJavaElement[] visibleElements;
        this.entrypoints = new LinkedList<ChainElement>();
        HashSet<IJavaElement> processed = new HashSet<IJavaElement>();
        for (CompletionProposal prop : this.coll.getProposals()) {
            ChainElement ce;
            IJavaElement e;
            IJavaElement javaElement = this.resolveJavaElement(prop, this.cu.getJavaProject());
            if (javaElement == null || !this.matchesExpectedPrefix(e = javaElement) || ChainFinder.isFromExcludedType(Arrays.asList(this.excludedTypes), (IJavaElement)e) || (ce = new ChainElement(e, false)).getElementType() == null) continue;
            this.entrypoints.add(ce);
            processed.add(javaElement);
        }
        IJavaElement[] iJavaElementArray = visibleElements = this.coll.getContext().getVisibleElements(null);
        int n = visibleElements.length;
        int n2 = 0;
        while (n2 < n) {
            ChainElement ce;
            IJavaElement ve = iJavaElementArray[n2];
            if (!processed.contains(ve) && this.matchesExpectedPrefix(ve) && !ChainFinder.isFromExcludedType(Arrays.asList(this.excludedTypes), (IJavaElement)ve) && (ce = new ChainElement(ve, false)).getElementType() != null) {
                this.entrypoints.add(ce);
            }
            ++n2;
        }
        return !this.entrypoints.isEmpty();
    }

    private IJavaElement resolveJavaElement(CompletionProposal prop, IJavaProject proj) {
        try {
            if (prop.getKind() == 2) {
                return JDTUtils.resolveField(prop, proj);
            }
            if (prop.getKind() == 6 || prop.getKind() == 13) {
                return JDTUtils.resolveMethod(prop, proj);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private boolean shouldPerformCompletionOnExpectedType() {
        if (this.coll.getContext().getToken() != null && CharOperation.equals((char[])this.coll.getContext().getToken(), (char[])KEYWORD_NEW)) {
            return false;
        }
        if (this.coll.getContext().getTokenLocation() == 4) {
            return false;
        }
        CompilationUnit cuNode = this.getASTRoot();
        AST ast = cuNode.getAST();
        ITypeBinding binding = ast.resolveWellKnownType(ChainElementAnalyzer.getExpectedFullyQualifiedTypeName((CompletionContext)this.coll.getContext()));
        IType type = ChainElementAnalyzer.getExpectedType((IJavaProject)this.cu.getJavaProject(), (CompletionContext)this.coll.getContext());
        return this.hasValidExpectedTypeResolution(binding, type);
    }

    private boolean hasValidExpectedTypeResolution(ITypeBinding binding, IType type) {
        if (binding != null) {
            return !this.isPrimitiveOrBoxedPrimitive(binding) && !"java.lang.String".equals(binding.getQualifiedName()) && !"java.lang.Object".equals(binding.getQualifiedName());
        }
        if (type != null) {
            return !"java.lang.String".equals(type.getFullyQualifiedName()) && !"java.lang.Object".equals(type.getFullyQualifiedName());
        }
        return false;
    }

    private boolean isPrimitiveOrBoxedPrimitive(ITypeBinding binding) {
        if (binding.isPrimitive()) {
            return true;
        }
        return switch (binding.getQualifiedName()) {
            case "java.lang.Boolean" -> true;
            case "java.lang.Byte" -> true;
            case "java.lang.Character" -> true;
            case "java.lang.Short" -> true;
            case "java.lang.Double" -> true;
            case "java.lang.Float" -> true;
            case "java.lang.Integer" -> true;
            case "java.lang.Long" -> true;
            default -> false;
        };
    }

    private CompilationUnit getASTRoot() {
        CompilationUnit cuNode = SharedASTProviderCore.getAST((ITypeRoot)this.cu, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        if (cuNode == null) {
            ASTParser p = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            p.setSource(this.cu);
            p.setResolveBindings(true);
            p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.cu));
            cuNode = (CompilationUnit)p.createAST(null);
        }
        return cuNode;
    }

    private boolean matchesExpectedPrefix(IJavaElement element) {
        String prefix = String.valueOf(this.coll.getContext().getToken());
        return String.valueOf(element.getElementName()).startsWith(prefix);
    }

    private CompletionItem create(Chain chain) throws JavaModelException {
        String insert = this.createInsertText(chain, chain.getExpectedDimensions());
        CompletionItem ci = new CompletionItem();
        ci.setTextEditText(insert);
        ci.setInsertText(this.getQualifiedMethodName(insert));
        ci.setInsertTextFormat(this.snippetStringSupported ? InsertTextFormat.Snippet : InsertTextFormat.PlainText);
        ci.setKind(CompletionItemKind.Method);
        this.setLabelDetails(chain, ci);
        ChainElement root = (ChainElement)chain.getElements().get(0);
        if (root.getElementType() == ChainElement.ElementType.TYPE) {
            ci.setAdditionalTextEdits(this.addImport(((IType)root.getElement()).getFullyQualifiedName()));
        }
        return ci;
    }

    private String getQualifiedMethodName(String name) {
        int index = name.indexOf(40);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    private String createInsertText(Chain chain, int expectedDimension) throws JavaModelException {
        AtomicInteger counter = new AtomicInteger(1);
        StringBuilder sb = new StringBuilder(64);
        for (ChainElement edge : chain.getElements()) {
            switch (edge.getElementType()) {
                case FIELD: 
                case LOCAL_VARIABLE: 
                case TYPE: {
                    ChainCompletionProposalComputer.appendVariableString(edge, sb);
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getElement();
                    sb.append(method.getElementName());
                    this.appendParameters(sb, method, counter);
                }
            }
            this.appendArrayDimensions(sb, edge.getReturnTypeDimension(), expectedDimension, this.snippetStringSupported, counter);
            sb.append(".");
        }
        ChainCompletionProposalComputer.deleteLastChar(sb);
        return sb.toString();
    }

    private void setLabelDetails(Chain chain, CompletionItem item) throws JavaModelException {
        CompletionItemLabelDetails details = new CompletionItemLabelDetails();
        ChainElement last = (ChainElement)chain.getElements().get(chain.getElements().size() - 1);
        String lastDetails = "";
        switch (last.getElementType()) {
            case FIELD: 
            case LOCAL_VARIABLE: 
            case TYPE: {
                item.setLabel(last.getElement().getElementName());
                details.setDescription(last.getReturnType().toString());
                break;
            }
            case METHOD: {
                IMethod method = (IMethod)last.getElement();
                String returnTypeSig = method.getReturnType();
                String signatureQualifier = Signature.getSignatureQualifier((String)returnTypeSig);
                String[] signatureComps = null;
                signatureComps = signatureQualifier != null && !signatureQualifier.isBlank() ? new String[]{signatureQualifier, Signature.getSignatureSimpleName((String)returnTypeSig)} : new String[]{Signature.getSignatureSimpleName((String)returnTypeSig)};
                details.setDescription(Signature.toQualifiedName((String[])signatureComps));
                lastDetails = "(%s)".formatted(Stream.of(method.getParameterNames()).collect(Collectors.joining(",")));
            }
        }
        List receivers = chain.getElements().subList(0, chain.getElements().size() - 1);
        StringBuilder receiversString = new StringBuilder(64);
        receiversString.append(" - ");
        for (ChainElement edge : receivers) {
            switch (edge.getElementType()) {
                case FIELD: 
                case LOCAL_VARIABLE: 
                case TYPE: {
                    ChainCompletionProposalComputer.appendVariableString(edge, receiversString);
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getElement();
                    receiversString.append(method.getElementName());
                    receiversString.append("(%s)".formatted(Stream.of(method.getParameterNames()).collect(Collectors.joining(","))));
                }
            }
            receiversString.append(".");
        }
        details.setDetail(receiversString.append(last.getElement().getElementName()).append(lastDetails).toString());
        item.setLabelDetails(details);
        item.setLabel(last.getElement().getElementName().concat(lastDetails));
    }

    private static void appendVariableString(ChainElement edge, StringBuilder sb) {
        if (edge.requiresThisForQualification() && sb.length() == 0) {
            sb.append("this.");
        }
        sb.append(edge.getElement().getElementName());
    }

    private void appendParameters(StringBuilder sb, IMethod method, AtomicInteger counter) throws JavaModelException {
        sb.append("(");
        if (this.snippetStringSupported) {
            String[] parameterNames = method.getParameterNames();
            if (parameterNames == null) {
                parameterNames = (String[])Stream.of(method.getParameterTypes()).map(ts -> Signature.getSignatureSimpleName((String)Signature.getElementType((String)ts))).map(n -> String.valueOf(n.substring(0, 1).toLowerCase()) + n.substring(1)).map(n -> {
                    int index = n.indexOf(60);
                    return index > -1 ? n.substring(0, index) : n;
                }).toArray(String[]::new);
            }
            sb.append(Stream.of(parameterNames).map(n -> "${%s:%s}".formatted(counter.getAndIncrement(), n)).collect(Collectors.joining(", ")));
        }
        sb.append(")");
    }

    private void appendArrayDimensions(StringBuilder sb, int dimension, int expectedDimension, boolean appendVariables, AtomicInteger counter) {
        int i = dimension;
        while (i-- > expectedDimension) {
            sb.append("[");
            if (appendVariables) {
                sb.append("${%s:%s}".formatted(counter.getAndIncrement(), "i"));
            }
            sb.append("]");
        }
    }

    private static StringBuilder deleteLastChar(StringBuilder sb) {
        return sb.deleteCharAt(sb.length() - 1);
    }

    private List<ChainElement> computeContextEntrypoint(List<ChainType> expectedTypes, IJavaProject project) throws JavaModelException {
        ArrayList<ChainElement> results = new ArrayList<ChainElement>();
        for (ChainType chainType : expectedTypes) {
            IType type;
            if (chainType.getType() == null) continue;
            if (("java.util.List".equals(chainType.getType().getFullyQualifiedName()) || "java.util.Set".equals(chainType.getType().getFullyQualifiedName()) || "java.util.Map".equals(chainType.getType().getFullyQualifiedName())) && (type = project.findType("java.util.Collections")) != null) {
                results.add(new ChainElement((IJavaElement)type, false));
            }
            if (!JavaModelUtil.is1d8OrHigher((IJavaProject)project) || !"java.util.stream.Collector".equals(chainType.getType().getFullyQualifiedName()) || (type = project.findType("java.util.stream.Collectors")) == null) continue;
            results.add(new ChainElement((IJavaElement)type, false));
        }
        return results;
    }

    private List<TextEdit> addImport(String type) {
        if (this.additionalEdits.containsKey(type)) {
            return this.additionalEdits.get(type);
        }
        try {
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                return Collections.emptyList();
            }
            CompilationUnit root = this.getASTRoot();
            ImportRewrite importRewrite = root == null ? StubUtility.createImportRewrite((ICompilationUnit)this.cu, (boolean)true) : StubUtility.createImportRewrite((CompilationUnit)root, (boolean)true);
            ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.coll.getContext().getOffset(), importRewrite);
            importRewrite.addImport(type, context);
            List edits = this.additionalEdits.getOrDefault(type, new ArrayList());
            TextEditConverter converter = new TextEditConverter(this.cu, importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
            edits.addAll(converter.convert());
            this.additionalEdits.put(type, edits);
            return edits;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return Collections.emptyList();
        }
    }

    public static List<ChainType> resolveBindingsForExpectedTypes(IJavaProject proj, CompletionContext ctx) {
        LinkedList<ChainType> types = new LinkedList<ChainType>();
        IType[] expectedTypeSigs = ChainCompletionProposalComputer.getExpectedType(proj, ctx);
        if (expectedTypeSigs == null) {
            char[][] expectedTypes = ctx.getExpectedTypesSignatures();
            int i = 0;
            while (i < expectedTypes.length) {
                String typeSig = new String(expectedTypes[i]);
                int dim = ChainCompletionProposalComputer.getArrayDimension(expectedTypes[i]);
                ChainType type = new ChainType(typeSig, dim);
                types.add(type);
                ++i;
            }
        } else {
            int i = 0;
            while (i < expectedTypeSigs.length) {
                ChainType type = new ChainType(expectedTypeSigs[i]);
                types.add(type);
                ++i;
            }
        }
        return types;
    }

    private static int getArrayDimension(char[] expectedTypesSignatures) {
        if (expectedTypesSignatures != null && expectedTypesSignatures.length > 0) {
            return Signature.getArrayCount((String)new String(expectedTypesSignatures));
        }
        return 0;
    }

    public static IType[] getExpectedType(IJavaProject proj, CompletionContext ctx) {
        IType[] expected = null;
        String[] fqExpectedTypes = ChainCompletionProposalComputer.getExpectedFullyQualifiedTypeNames(ctx);
        if (fqExpectedTypes != null && fqExpectedTypes.length > 0) {
            expected = new IType[fqExpectedTypes.length];
            int i = 0;
            while (i < fqExpectedTypes.length) {
                try {
                    expected[i] = proj.findType(fqExpectedTypes[i]);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return expected;
    }

    public static String[] getExpectedFullyQualifiedTypeNames(CompletionContext ctx) {
        String[] fqExpectedTypes = null;
        char[][] expectedTypes = ctx.getExpectedTypesSignatures();
        if (expectedTypes != null && expectedTypes.length > 0) {
            fqExpectedTypes = new String[expectedTypes.length];
            int i = 0;
            while (i < expectedTypes.length) {
                fqExpectedTypes[i] = SignatureUtil.stripSignatureToFQN((String)new String(expectedTypes[i]));
                ++i;
            }
        }
        return fqExpectedTypes;
    }
}

