/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword2;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.CompletionUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixCompletionProposalComputer;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixTemplateEngine;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.CodeGenerationTemplate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SnippetCompletionProposal
extends CompletionProposal {
    private static final String CLASS_SNIPPET_LABEL = "class";
    private static final String INTERFACE_SNIPPET_LABEL = "interface";
    private static final String RECORD_SNIPPET_LABEL = "record";
    private static final String CLASS_KEYWORD = "class";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final String RECORD_KEYWORD = "record";
    private static String PACKAGEHEADER = "package_header";
    private static String CURSOR = "cursor";
    private Template template;

    public SnippetCompletionProposal(Template template) {
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    public static List<CompletionItem> getSnippets(ICompilationUnit cu, CompletionProposalRequestor collector, IProgressMonitor monitor) throws JavaModelException {
        CompletionContext completionContext = collector.getContext();
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>();
        SnippetCompletionContext scc = new SnippetCompletionContext(cu, completionContext);
        res.addAll(SnippetCompletionProposal.getGenericSnippets(scc, collector.getCompletionItemDefaults()));
        res.addAll(SnippetCompletionProposal.getTypeDefinitionSnippets(scc, monitor, collector.getCompletionItemDefaults()));
        res.addAll(SnippetCompletionProposal.getPostfixSnippets(scc, collector.getCompletionItemDefaults()));
        return res;
    }

    private static List<CompletionItem> getPostfixSnippets(SnippetCompletionContext scc, CompletionItemDefaults completionItemDefaults) {
        if (!SnippetCompletionProposal.isPostfixSupported()) {
            return Collections.emptyList();
        }
        CompletionContext jdtCtx = scc.getCompletionContext();
        try {
            PostfixCompletionProposalComputer computer;
            PostfixTemplateEngine engine;
            IDocument document = JsonRpcHelpers.toDocument(scc.getCompilationUnit().getBuffer());
            if (SnippetCompletionProposal.canResolvePostfix(jdtCtx, document) && (engine = (computer = new PostfixCompletionProposalComputer()).computeCompletionEngine(jdtCtx, document, jdtCtx.getOffset())) != null) {
                return engine.complete(document, jdtCtx.getOffset(), scc.getCompilationUnit(), completionItemDefaults);
            }
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    private static boolean isPostfixSupported() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isPostfixCompletionEnabled();
    }

    private static boolean canResolvePostfix(CompletionContext jdtCtx, IDocument document) throws BadLocationException {
        char[] token = jdtCtx.getToken();
        if (token == null) {
            return false;
        }
        int tokenStart = jdtCtx.getOffset() - token.length - 1;
        if (tokenStart < 0) {
            return false;
        }
        String tokenSequence = document.get(tokenStart, jdtCtx.getOffset() - tokenStart);
        if (!tokenSequence.startsWith(".")) {
            return false;
        }
        Template[] templates = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("postfix");
        return Arrays.stream(templates).anyMatch(t -> t.getName().toLowerCase().startsWith(new String(token).toLowerCase()));
    }

    private static List<CompletionItem> getGenericSnippets(SnippetCompletionContext scc, CompletionItemDefaults completionItemDefaults) throws JavaModelException {
        DocumentTemplateContext javaContextAll;
        DocumentTemplateContext javaContext;
        CompletionResponse response = new CompletionResponse();
        response.setContext(scc.getCompletionContext());
        response.setOffset(scc.getCompletionContext().getOffset());
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>();
        CompletionContext completionContext = scc.getCompletionContext();
        char[] completionToken = completionContext.getToken();
        if (completionToken == null) {
            return Collections.emptyList();
        }
        int tokenLocation = completionContext.getTokenLocation();
        JavaContextType contextType = null;
        JavaContextType contextTypeAll = (JavaContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType("java");
        ICompilationUnit cu = scc.getCompilationUnit();
        Document document = new Document(cu.getSource());
        Template[] templates = null;
        Template[] templatesAll = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("java");
        if ((tokenLocation & 2) != 0) {
            contextType = (JavaContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType("java-statements");
            javaContext = contextType != null ? contextType.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu) : null;
            templates = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("java-statements");
            javaContextAll = contextTypeAll != null ? contextTypeAll.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu) : null;
        } else if ((tokenLocation & 1) != 0) {
            contextType = (JavaContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType("java-members");
            javaContext = contextType != null ? contextType.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu) : null;
            templates = JavaLanguageServerPlugin.getInstance().getTemplateStore().getTemplates("java-members");
            javaContextAll = contextTypeAll != null ? contextTypeAll.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu) : null;
        } else {
            javaContext = null;
            javaContextAll = null;
        }
        if (javaContext == null && javaContextAll == null || templates == null && templatesAll == null || templates.length == 0) {
            return Collections.emptyList();
        }
        String uri = JDTUtils.toURI(cu);
        Template[] availableTemplates = (Template[])Arrays.stream(templates).filter(t -> javaContext.canEvaluate(t)).toArray(Template[]::new);
        Template[] availableTemplatesAll = (Template[])Arrays.stream(templatesAll).filter(t -> javaContextAll.canEvaluate(t)).toArray(Template[]::new);
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        int i = 0;
        while (i < availableTemplates.length + availableTemplatesAll.length) {
            Template template = i < availableTemplates.length ? availableTemplates[i] : availableTemplatesAll[i - availableTemplates.length];
            CompletionItem item = new CompletionItem();
            item.setLabel(template.getName());
            item.setKind(CompletionItemKind.Snippet);
            CompletionUtils.setInsertTextFormat(item, completionItemDefaults);
            CompletionUtils.setInsertTextMode(item, completionItemDefaults);
            if (SnippetCompletionProposal.isCompletionLazyResolveTextEditEnabled()) {
                String insertText = SnippetUtils.templateToSnippet(template.getPattern());
                if (SnippetCompletionProposal.isCompletionListItemDefaultsSupport() && completionItemDefaults.getEditRange() != null) {
                    item.setTextEditText(insertText);
                } else {
                    item.setInsertText(insertText);
                }
            } else {
                String content = SnippetCompletionProposal.evaluateGenericTemplate(cu, completionContext, template);
                if (SnippetCompletionProposal.isCompletionListItemDefaultsSupport() && completionItemDefaults.getEditRange() != null) {
                    item.setTextEditText(content);
                } else {
                    SnippetCompletionProposal.setTextEdit(completionContext, cu, item, content);
                }
            }
            item.setDetail(template.getDescription());
            if (SnippetCompletionProposal.isCompletionItemLabelDetailsSupport()) {
                CompletionItemLabelDetails itemLabelDetails = new CompletionItemLabelDetails();
                itemLabelDetails.setDescription(template.getDescription());
                item.setLabelDetails(itemLabelDetails);
            }
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("rid", String.valueOf(response.getId()));
            data.put("pid", String.valueOf(i));
            item.setData(data);
            proposals.add(i, new SnippetCompletionProposal(template));
            res.add(item);
            ++i;
        }
        response.setProposals(proposals);
        response.setItems(res);
        response.setCommonData("uri", uri);
        CompletionResponses.store(response);
        return res;
    }

    public static void setTextEdit(CompletionContext completionContext, ICompilationUnit cu, CompletionItem item, String content) throws JavaModelException {
        int length = completionContext.getTokenEnd() - completionContext.getTokenStart() + 1;
        Range range = JDTUtils.toRange((IOpenable)cu, completionContext.getTokenStart(), length);
        TextEdit textEdit = new TextEdit(range, content);
        item.setTextEdit(Either.forLeft((Object)textEdit));
    }

    private static boolean isCompletionItemLabelDetailsSupport() {
        return JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionItemLabelDetailsSupport();
    }

    public static String evaluateGenericTemplate(ICompilationUnit cu, CompletionContext completionContext, Template template) {
        JavaContextType contextType = (JavaContextType)JavaLanguageServerPlugin.getInstance().getTemplateContextRegistry().getContextType(template.getContextTypeId());
        char[] completionToken = completionContext.getToken();
        if (contextType == null || completionToken == null) {
            return null;
        }
        TemplateBuffer buffer = null;
        try {
            Document document = new Document(cu.getSource());
            DocumentTemplateContext javaContext = contextType.createContext((IDocument)document, completionContext.getOffset(), completionToken.length, cu);
            buffer = javaContext.evaluate(template);
        }
        catch (JavaModelException | BadLocationException | TemplateException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
        if (buffer == null) {
            return null;
        }
        String content = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)content)) {
            return null;
        }
        return content;
    }

    private static List<CompletionItem> getTypeDefinitionSnippets(SnippetCompletionContext scc, IProgressMonitor monitor, CompletionItemDefaults completionItemDefaults) throws JavaModelException {
        CompletionItem recordSnippet;
        CompletionItem interfaceSnippet;
        CompletionItem classSnippet;
        char[] completionToken = scc.getCompletionContext().getToken();
        boolean isInterfacePrefix = true;
        boolean isClassPrefix = true;
        boolean isRecordPrefix = true;
        if (completionToken != null && completionToken.length > 0) {
            String prefix = new String(completionToken);
            isInterfacePrefix = "interface".startsWith(prefix);
            isClassPrefix = "class".startsWith(prefix);
            isRecordPrefix = "record".startsWith(prefix);
        }
        if (!(isInterfacePrefix || isClassPrefix || isRecordPrefix)) {
            return Collections.emptyList();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> res = new ArrayList<CompletionItem>(3);
        if (isClassPrefix && (classSnippet = SnippetCompletionProposal.getClassSnippet(scc, monitor)) != null) {
            res.add(classSnippet);
        }
        if (isInterfacePrefix && (interfaceSnippet = SnippetCompletionProposal.getInterfaceSnippet(scc, monitor)) != null) {
            res.add(interfaceSnippet);
        }
        if (isRecordPrefix && (recordSnippet = SnippetCompletionProposal.getRecordSnippet(scc, monitor)) != null) {
            res.add(recordSnippet);
        }
        for (CompletionItem item : res) {
            SnippetCompletionProposal.setFields(item, scc.getCompilationUnit(), completionItemDefaults);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean accept(ICompilationUnit cu, CompletionContext completionContext, boolean acceptClass) {
        if (completionContext != null && completionContext.isExtended()) {
            if (completionContext.isInJavadoc()) {
                return false;
            }
            CompletionContext completionContext2 = completionContext;
            if (completionContext2 instanceof InternalCompletionContext) {
                void internalCompletionContext;
                InternalCompletionContext internalCompletionContext2 = (InternalCompletionContext)completionContext2;
                InternalCompletionContext cfr_ignored_0 = (InternalCompletionContext)completionContext2;
                org.eclipse.jdt.internal.compiler.ast.ASTNode node = internalCompletionContext.getCompletionNode();
                if (node instanceof CompletionOnKeyword2) {
                    return true;
                }
                if (node instanceof CompletionOnFieldType) {
                    return true;
                }
                if (acceptClass && node instanceof CompletionOnSingleNameReference) {
                    if (completionContext.getEnclosingElement() instanceof IMethod) {
                        CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                        if (ast == null) {
                            return true;
                        }
                        ASTNode astNode = ASTNodeSearchUtil.getAstNode((CompilationUnit)ast, (int)completionContext.getTokenStart(), (int)(completionContext.getTokenEnd() - completionContext.getTokenStart() + 1));
                        return astNode == null || astNode.getParent() instanceof ExpressionStatement;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static CompletionItem getClassSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        if (!SnippetCompletionProposal.accept(cu, scc.getCompletionContext(), true)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem classSnippetItem = new CompletionItem();
        classSnippetItem.setLabel("class");
        classSnippetItem.setFilterText("class");
        classSnippetItem.setSortText(SortTextHelper.convertRelevance(1));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.CLASSSNIPPET_PUBLIC : CodeGenerationTemplate.CLASSSNIPPET_DEFAULT;
            classSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            if (SnippetCompletionProposal.isCompletionListItemDefaultsSupport()) {
                classSnippetItem.setTextEditText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return classSnippetItem;
    }

    private static CompletionItem getInterfaceSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        if (!SnippetCompletionProposal.accept(cu, scc.completionContext, false)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem interfaceSnippetItem = new CompletionItem();
        interfaceSnippetItem.setFilterText("interface");
        interfaceSnippetItem.setLabel("interface");
        interfaceSnippetItem.setSortText(SortTextHelper.convertRelevance(0));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.INTERFACESNIPPET_PUBLIC : CodeGenerationTemplate.INTERFACESNIPPET_DEFAULT;
            interfaceSnippetItem.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            if (SnippetCompletionProposal.isCompletionListItemDefaultsSupport()) {
                interfaceSnippetItem.setTextEditText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return interfaceSnippetItem;
    }

    private static CompletionItem getRecordSnippet(SnippetCompletionContext scc, IProgressMonitor monitor) {
        ICompilationUnit cu = scc.getCompilationUnit();
        IJavaProject javaProject = cu.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        String version = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (JavaModelUtil.isVersionLessThan((String)version, (String)"14")) {
            return null;
        }
        if (!SnippetCompletionProposal.accept(cu, scc.getCompletionContext(), false)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionItem recordSnippet = new CompletionItem();
        recordSnippet.setFilterText("record");
        recordSnippet.setLabel("record");
        recordSnippet.setSortText(SortTextHelper.convertRelevance(0));
        try {
            CodeGenerationTemplate template = scc.needsPublic(monitor) ? CodeGenerationTemplate.RECORDSNIPPET_PUBLIC : CodeGenerationTemplate.RECORDSNIPPET_DEFAULT;
            recordSnippet.setInsertText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            if (SnippetCompletionProposal.isCompletionListItemDefaultsSupport()) {
                recordSnippet.setTextEditText(SnippetCompletionProposal.getSnippetContent(scc, template, true));
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e.getStatus());
            return null;
        }
        return recordSnippet;
    }

    private static void setFields(CompletionItem ci, ICompilationUnit cu, CompletionItemDefaults completionItemDefaults) {
        ci.setKind(CompletionItemKind.Snippet);
        CompletionUtils.setInsertTextFormat(ci, completionItemDefaults);
        CompletionUtils.setInsertTextMode(ci, completionItemDefaults);
        ci.setDocumentation(SnippetUtils.beautifyDocument(ci.getInsertText()));
    }

    private static String getSnippetContent(SnippetCompletionContext scc, CodeGenerationTemplate templateSetting, boolean snippetStringSupport) throws CoreException {
        TemplateBuffer buffer;
        ICompilationUnit cu = scc.getCompilationUnit();
        Template template = templateSetting.createTemplate();
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), scc.getRecommendedLineSeprator());
        String fileComment = cu.getTypes().length == 0 ? CodeGeneration.getFileComment((ICompilationUnit)cu, (String)StubUtility.getLineDelimiterUsed((IJavaProject)cu.getJavaProject())) : null;
        context.setVariable("filecomment", fileComment != null ? String.valueOf(fileComment) + "\n" : "");
        context.setVariable(PACKAGEHEADER, scc.getPackageHeader());
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        List<IType> types = Arrays.asList(cu.getAllTypes());
        int postfix = 0;
        while (!types.isEmpty() && types.stream().filter(SnippetCompletionProposal.isTypeExists(typeName)).findFirst().isPresent()) {
            typeName = "Inner" + JavaCore.removeJavaLikeExtension((String)cu.getElementName()) + (postfix == 0 ? "" : "_" + postfix);
            ++postfix;
        }
        if (postfix > 0 && snippetStringSupport) {
            context.setVariable("type_name", "${1:" + typeName + "}");
        } else {
            context.setVariable("type_name", typeName);
        }
        context.setVariable(CURSOR, snippetStringSupport ? "${0}" : "");
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static Predicate<IType> isTypeExists(String typeName) {
        return type -> type.getElementName().equals(typeName);
    }

    private static boolean isCompletionListItemDefaultsSupport() {
        return JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionListItemDefaultsSupport();
    }

    private static boolean isCompletionLazyResolveTextEditEnabled() {
        return JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isCompletionLazyResolveTextEditEnabled();
    }

    private static class SnippetCompletionContext {
        private ICompilationUnit cu;
        private Boolean needsPublic;
        private CompletionContext completionContext;
        private String packageHeader;
        private String recommendedLineSeprator;

        SnippetCompletionContext(ICompilationUnit cu, CompletionContext completionContext) {
            this.cu = cu;
            this.completionContext = completionContext;
        }

        ICompilationUnit getCompilationUnit() {
            return this.cu;
        }

        boolean needsPublic(IProgressMonitor monitor) {
            if (this.needsPublic == null) {
                this.needsPublic = SnippetCompletionContext.needsPublic(this.cu, this.getCompletionContext(), monitor);
            }
            return this.needsPublic;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean needsPublic(ICompilationUnit cu, CompletionContext completionContext, IProgressMonitor monitor) {
            block15: {
                block14: {
                    block13: {
                        if (completionContext == null || !completionContext.isExtended()) break block14;
                        if (completionContext.isInJavadoc()) {
                            return false;
                        }
                        var5_3 = completionContext;
                        if (!(var5_3 instanceof InternalCompletionContext)) break block14;
                        var3_4 = (InternalCompletionContext)var5_3;
                        (InternalCompletionContext)var5_3;
                        node = internalCompletionContext.getCompletionNode();
                        if (!(node instanceof CompletionOnKeyword2) && !(node instanceof CompletionOnFieldType) && !(node instanceof CompletionOnSingleNameReference)) break block14;
                        if (completionContext.getEnclosingElement() instanceof IMethod) {
                            return false;
                        }
                        try {
                            scanner = new TokenScanner((ITypeRoot)cu);
                            previous = curr = scanner.readNext(0, true);
                            while (scanner.getCurrentEndOffset() < completionContext.getTokenStart()) {
                                previous = curr;
                                if (monitor.isCanceled()) {
                                    return false;
                                }
                                if (curr == 158) break;
                                try {
                                    curr = scanner.readNext(true);
                                }
                                catch (CoreException var10_11) {
                                    // empty catch block
                                }
                            }
                            if (TokenScanner.isModifier((int)previous)) {
                                return false;
                            }
                        }
                        catch (CoreException e) {
                            if (e.getStatus().getCode() == 20001) break block13;
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                    if (!(node instanceof CompletionOnSingleNameReference)) break block15;
                    ast = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
                    if (ast == null || monitor.isCanceled()) {
                        return false;
                    }
                    astNode = ASTNodeSearchUtil.getAstNode((CompilationUnit)ast, (int)completionContext.getOffset(), (int)1);
                    if (astNode == null) {
                        return false;
                    }
                    ** GOTO lbl48
                }
                return false;
lbl-1000:
                // 1 sources

                {
                    if (astNode instanceof Initializer) {
                        return false;
                    }
                    astNode = astNode.getParent();
lbl48:
                    // 2 sources

                    ** while (astNode != null)
                }
            }
            return true;
        }

        CompletionContext getCompletionContext() {
            return this.completionContext;
        }

        String getPackageHeader() throws JavaModelException {
            if (this.packageHeader == null) {
                IPackageDeclaration[] packageDeclarations = this.cu.getPackageDeclarations();
                String packageName = this.cu.getParent().getElementName();
                this.packageHeader = packageName != null && !packageName.isEmpty() && (packageDeclarations == null || packageDeclarations.length == 0) ? "package " + packageName + ";\n\n" : "";
            }
            return this.packageHeader;
        }

        String getRecommendedLineSeprator() throws JavaModelException {
            if (this.recommendedLineSeprator == null) {
                this.recommendedLineSeprator = this.cu.findRecommendedLineSeparator();
            }
            return this.recommendedLineSeprator;
        }
    }
}

