/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpUtils;

public class SignatureHelpContext {
    private int completionOffset = -1;
    private int secondaryCompletionOffset = -1;
    private List<int[]> argumentRanges = new ArrayList<int[]>();
    private String methodName;
    private List<String> declaringTypeNames;
    private List<Expression> arguments;
    private String[] parameterTypes;
    private String[] parameterTypesFromBinding;
    private ASTNode targetNode;

    public void resolve(int triggerOffset, ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnit root = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        if (root == null || monitor.isCanceled()) {
            return;
        }
        this.findTargetNode((ASTNode)root, unit, triggerOffset);
        this.resolveMethodName(this.targetNode);
        this.resolveDeclaringTypeName(this.targetNode);
        this.arguments = this.resolveArguments(this.targetNode);
        this.resolveParameterTypes(this.targetNode);
        this.guessCompletionOffset(this.targetNode, unit);
        this.guessArgumentRanges(unit, this.completionOffset);
    }

    private void findTargetNode(ASTNode root, ICompilationUnit unit, int triggerOffset) throws JavaModelException {
        ASTNode node;
        if (root == null) {
            return;
        }
        String source = unit.getSource();
        if (source == null || triggerOffset >= source.length()) {
            return;
        }
        int searchOffset = triggerOffset;
        while (searchOffset > 0) {
            char cur = source.charAt(searchOffset);
            char prev = source.charAt(searchOffset - 1);
            if (Character.isWhitespace(cur) && prev != ';') {
                --searchOffset;
                continue;
            }
            if (cur != ')' || !Character.isWhitespace(prev) && prev != ',') break;
            --searchOffset;
        }
        if ((node = this.findMethodLikeNode(root, searchOffset = searchOffset <= 0 ? triggerOffset : searchOffset)) == null) {
            return;
        }
        this.targetNode = this.findEnclosingMethodNode(node, source, searchOffset);
    }

    private ASTNode findMethodLikeNode(ASTNode root, int offset) {
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)offset, (int)0);
        while (node != null && !(node instanceof Block)) {
            if (this.isMethodLikeNode(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private boolean isMethodLikeNode(ASTNode node) {
        return node instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation || node instanceof ConstructorInvocation || node instanceof SuperMethodInvocation || node instanceof MethodRef;
    }

    private ASTNode findEnclosingMethodNode(ASTNode node, String source, int offset) {
        if (this.isInArgumentList(node, source, offset)) {
            return node;
        }
        ASTNode parent = node.getParent();
        while (parent != null && !(parent instanceof Block)) {
            if (this.isMethodLikeNode(parent) && this.isInArgumentList(parent, source, offset)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return node;
    }

    private boolean isInArgumentList(ASTNode node, String source, int offset) {
        int[] argumentRange = this.findArgumentRange(node, source);
        if (argumentRange == null || argumentRange.length < 2) {
            return false;
        }
        return argumentRange[0] <= offset && argumentRange[1] >= offset;
    }

    /*
     * WARNING - void declaration
     */
    private int[] findArgumentRange(ASTNode node, String source) {
        List<Expression> arguments = this.resolveArguments(node);
        if (arguments == null) {
            return null;
        }
        if (arguments.size() > 0) {
            Expression firstArg = arguments.get(0);
            Expression lastArg = arguments.get(arguments.size() - 1);
            return new int[]{firstArg.getStartPosition(), lastArg.getStartPosition() + lastArg.getLength()};
        }
        SimpleName simpleNameNode = null;
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation lastArg = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            simpleNameNode = methodInvocation.getName();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ClassInstanceCreation) {
                void classInstanceCreation;
                ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                simpleNameNode = classInstanceCreation.getType();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof SuperMethodInvocation) {
                    void superInvocation;
                    SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)aSTNode3;
                    SuperMethodInvocation cfr_ignored_2 = (SuperMethodInvocation)aSTNode3;
                    simpleNameNode = superInvocation.getName();
                } else {
                    ASTNode aSTNode4 = node;
                    if (aSTNode4 instanceof MethodRef) {
                        void methodRef;
                        MethodRef methodRef2 = (MethodRef)aSTNode4;
                        MethodRef cfr_ignored_3 = (MethodRef)aSTNode4;
                        simpleNameNode = methodRef.getName();
                    } else if (node instanceof ConstructorInvocation) {
                        simpleNameNode = node;
                    } else if (node instanceof SuperConstructorInvocation) {
                        simpleNameNode = node;
                    }
                }
            }
        }
        if (simpleNameNode == null) {
            return null;
        }
        int i = simpleNameNode.getStartPosition() + simpleNameNode.getLength();
        while (i < node.getStartPosition() + node.getLength()) {
            if (source.charAt(i) == '(') {
                return new int[]{i + 1, node.getStartPosition() + node.getLength() - 1};
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void resolveMethodName(ASTNode node) {
        if (node == null) {
            return;
        }
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            this.methodName = methodInvocation.getName().getIdentifier();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ClassInstanceCreation) {
                void classInstanceCreation;
                ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                ITypeBinding binding = classInstanceCreation.getType().resolveBinding();
                if (binding != null) {
                    this.methodName = binding.getErasure().getName();
                }
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof SuperMethodInvocation) {
                    void superInvocation;
                    SuperMethodInvocation binding = (SuperMethodInvocation)aSTNode3;
                    SuperMethodInvocation cfr_ignored_2 = (SuperMethodInvocation)aSTNode3;
                    this.methodName = superInvocation.getName().getIdentifier();
                } else {
                    ASTNode aSTNode4 = node;
                    if (aSTNode4 instanceof MethodRef) {
                        void methodRef;
                        MethodRef methodRef2 = (MethodRef)aSTNode4;
                        MethodRef cfr_ignored_3 = (MethodRef)aSTNode4;
                        this.methodName = methodRef.getName().getIdentifier();
                    } else {
                        ASTNode aSTNode5 = node;
                        if (aSTNode5 instanceof ConstructorInvocation) {
                            void constructorInvocation;
                            ConstructorInvocation constructorInvocation2 = (ConstructorInvocation)aSTNode5;
                            ConstructorInvocation cfr_ignored_4 = (ConstructorInvocation)aSTNode5;
                            IMethodBinding binding = constructorInvocation.resolveConstructorBinding();
                            if (binding != null) {
                                this.methodName = binding.getDeclaringClass().getName();
                            }
                        } else {
                            ASTNode aSTNode6 = node;
                            if (aSTNode6 instanceof SuperConstructorInvocation) {
                                void superConstructorInvocation;
                                SuperConstructorInvocation binding = (SuperConstructorInvocation)aSTNode6;
                                SuperConstructorInvocation cfr_ignored_5 = (SuperConstructorInvocation)aSTNode6;
                                IMethodBinding binding2 = superConstructorInvocation.resolveConstructorBinding();
                                if (binding2 != null) {
                                    this.methodName = binding2.getDeclaringClass().getName();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resolveDeclaringTypeName(ASTNode node) {
        if (node == null) {
            return;
        }
        IMethodBinding methodBinding = null;
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            methodBinding = methodInvocation.resolveMethodBinding();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ClassInstanceCreation) {
                void classInstanceCreation;
                ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                methodBinding = classInstanceCreation.resolveConstructorBinding();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof SuperMethodInvocation) {
                    void superMethodInvocation;
                    SuperMethodInvocation superMethodInvocation2 = (SuperMethodInvocation)aSTNode3;
                    SuperMethodInvocation cfr_ignored_2 = (SuperMethodInvocation)aSTNode3;
                    methodBinding = superMethodInvocation.resolveMethodBinding();
                } else {
                    ASTNode aSTNode4 = node;
                    if (aSTNode4 instanceof SuperConstructorInvocation) {
                        void superConstructorInvocation;
                        SuperConstructorInvocation superConstructorInvocation2 = (SuperConstructorInvocation)aSTNode4;
                        SuperConstructorInvocation cfr_ignored_3 = (SuperConstructorInvocation)aSTNode4;
                        methodBinding = superConstructorInvocation.resolveConstructorBinding();
                    } else {
                        ASTNode aSTNode5 = node;
                        if (aSTNode5 instanceof ConstructorInvocation) {
                            void constructorInvocation;
                            ConstructorInvocation constructorInvocation2 = (ConstructorInvocation)aSTNode5;
                            ConstructorInvocation cfr_ignored_4 = (ConstructorInvocation)aSTNode5;
                            methodBinding = constructorInvocation.resolveConstructorBinding();
                        }
                    }
                }
            }
        }
        if (methodBinding != null) {
            ITypeBinding declaringType = methodBinding.getDeclaringClass();
            ArrayList<String> typeNames = new ArrayList<String>();
            ITypeBinding[] iTypeBindingArray = declaringType.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding mInterface = iTypeBindingArray[n2];
                String unqualifiedName = mInterface.getErasure().getName().replace(";", "");
                typeNames.add(unqualifiedName);
                ++n2;
            }
            while (declaringType != null) {
                String unqualifiedName = declaringType.getErasure().getName().replace(";", "");
                typeNames.add(unqualifiedName);
                declaringType = declaringType.getSuperclass();
            }
            this.declaringTypeNames = typeNames;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Expression> resolveArguments(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            return methodInvocation.arguments();
        }
        ASTNode aSTNode2 = node;
        if (aSTNode2 instanceof ClassInstanceCreation) {
            void classInstanceCreation;
            ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
            ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
            return classInstanceCreation.arguments();
        }
        ASTNode aSTNode3 = node;
        if (aSTNode3 instanceof SuperMethodInvocation) {
            void superMethodInvocation;
            SuperMethodInvocation superMethodInvocation2 = (SuperMethodInvocation)aSTNode3;
            SuperMethodInvocation cfr_ignored_2 = (SuperMethodInvocation)aSTNode3;
            return superMethodInvocation.arguments();
        }
        ASTNode aSTNode4 = node;
        if (aSTNode4 instanceof MethodRef) {
            void methodRef;
            MethodRef methodRef2 = (MethodRef)aSTNode4;
            MethodRef cfr_ignored_3 = (MethodRef)aSTNode4;
            return methodRef.parameters();
        }
        ASTNode aSTNode5 = node;
        if (aSTNode5 instanceof SuperConstructorInvocation) {
            void superConstructorInvocation;
            SuperConstructorInvocation superConstructorInvocation2 = (SuperConstructorInvocation)aSTNode5;
            SuperConstructorInvocation cfr_ignored_4 = (SuperConstructorInvocation)aSTNode5;
            return superConstructorInvocation.arguments();
        }
        ASTNode aSTNode6 = node;
        if (aSTNode6 instanceof ConstructorInvocation) {
            void constructorInvocation;
            ConstructorInvocation constructorInvocation2 = (ConstructorInvocation)aSTNode6;
            ConstructorInvocation cfr_ignored_5 = (ConstructorInvocation)aSTNode6;
            return constructorInvocation.arguments();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void resolveParameterTypes(ASTNode node) {
        IMethod method;
        if (node == null) {
            return;
        }
        IMethodBinding binding = null;
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            binding = methodInvocation.resolveMethodBinding();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ClassInstanceCreation) {
                void classInstanceCreation;
                ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                binding = classInstanceCreation.resolveConstructorBinding();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof SuperMethodInvocation) {
                    void superMethodInvocation;
                    SuperMethodInvocation superMethodInvocation2 = (SuperMethodInvocation)aSTNode3;
                    SuperMethodInvocation cfr_ignored_2 = (SuperMethodInvocation)aSTNode3;
                    binding = superMethodInvocation.resolveMethodBinding();
                } else {
                    ASTNode aSTNode4 = node;
                    if (aSTNode4 instanceof MethodRef) {
                        void methodRef;
                        MethodRef methodRef2 = (MethodRef)aSTNode4;
                        MethodRef cfr_ignored_3 = (MethodRef)aSTNode4;
                        binding = methodRef.resolveBinding();
                    } else {
                        ASTNode aSTNode5 = node;
                        if (aSTNode5 instanceof SuperConstructorInvocation) {
                            void superConstructorInvocation;
                            SuperConstructorInvocation superConstructorInvocation2 = (SuperConstructorInvocation)aSTNode5;
                            SuperConstructorInvocation cfr_ignored_4 = (SuperConstructorInvocation)aSTNode5;
                            binding = superConstructorInvocation.resolveConstructorBinding();
                        } else {
                            ASTNode aSTNode6 = node;
                            if (aSTNode6 instanceof ConstructorInvocation) {
                                void constructorInvocation;
                                ConstructorInvocation constructorInvocation2 = (ConstructorInvocation)aSTNode6;
                                ConstructorInvocation cfr_ignored_5 = (ConstructorInvocation)aSTNode6;
                                binding = constructorInvocation.resolveConstructorBinding();
                            }
                        }
                    }
                }
            }
        }
        if (binding == null) {
            return;
        }
        IMethodBinding iMethodBinding = binding;
        if (iMethodBinding instanceof IMethodBinding) {
            void methodBinding;
            IMethodBinding iMethodBinding2 = iMethodBinding;
            if (methodBinding.isDefaultConstructor()) {
                this.parameterTypes = new String[0];
                return;
            }
            this.parameterTypesFromBinding = (String[])Arrays.stream(methodBinding.getParameterTypes()).map(type -> {
                String unqualifiedName = type.getErasure().getName();
                return unqualifiedName.replace(";", "");
            }).toArray(String[]::new);
        }
        if ((method = (IMethod)binding.getJavaElement()) != null) {
            this.parameterTypes = (String[])Arrays.stream(method.getParameterTypes()).map(signature -> SignatureHelpUtils.getSimpleTypeName(signature)).toArray(String[]::new);
        }
    }

    private void guessCompletionOffset(ASTNode node, ICompilationUnit unit) throws JavaModelException {
        IBuffer buffer = unit.getBuffer();
        if (node == null || buffer == null) {
            this.completionOffset = -1;
            return;
        }
        int startPosition = node.getStartPosition();
        int endPosition = startPosition + node.getLength();
        int i = startPosition += this.getOptionalExpressionLength(node);
        while (i < endPosition) {
            if (buffer.getChar(i) == '(') {
                if (node instanceof MethodInvocation || node instanceof SuperMethodInvocation || node instanceof MethodRef) {
                    this.completionOffset = i;
                    this.secondaryCompletionOffset = i + 1;
                    return;
                }
                if (node instanceof ClassInstanceCreation || node instanceof ConstructorInvocation || node instanceof SuperConstructorInvocation) {
                    this.completionOffset = i + 1;
                    return;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getOptionalExpressionLength(ASTNode node) {
        Expression optionalExpression = null;
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            optionalExpression = methodInvocation.getExpression();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ClassInstanceCreation) {
                void classInstanceCreation;
                ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                optionalExpression = classInstanceCreation.getExpression();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof SuperConstructorInvocation) {
                    void superConstructorInvocation;
                    SuperConstructorInvocation superConstructorInvocation2 = (SuperConstructorInvocation)aSTNode3;
                    SuperConstructorInvocation cfr_ignored_2 = (SuperConstructorInvocation)aSTNode3;
                    optionalExpression = superConstructorInvocation.getExpression();
                }
            }
        }
        if (optionalExpression == null) {
            return 0;
        }
        return optionalExpression.getLength();
    }

    private void guessArgumentRanges(ICompilationUnit unit, int completionOffset) throws JavaModelException {
        IBuffer buffer = unit.getBuffer();
        if (buffer == null || completionOffset == -1) {
            return;
        }
        int argumentStartPosition = completionOffset;
        if (buffer.getChar(argumentStartPosition) == '(') {
            ++argumentStartPosition;
        }
        String argumentLiterals = buffer.getText(argumentStartPosition, buffer.getLength() - argumentStartPosition);
        ArrayList<int[]> list = new ArrayList<int[]>();
        int[] argumentRange = new int[]{argumentStartPosition, argumentStartPosition};
        Stack<Character> stack = new Stack<Character>();
        boolean hasArgument = false;
        int i = 0;
        while (i < argumentLiterals.length()) {
            char c = argumentLiterals.charAt(i);
            if (!hasArgument && this.isArgumentChar(c)) {
                hasArgument = true;
            }
            block0 : switch (c) {
                case ',': {
                    if (!stack.isEmpty()) break;
                    argumentRange[1] = argumentStartPosition + i;
                    list.add(argumentRange);
                    argumentRange = new int[]{argumentStartPosition + i + 1, argumentStartPosition + i + 1};
                    break;
                }
                case '\'': {
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '\'') break block0;
                        if (c == '\\') {
                            i += 2;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                case '\"': {
                    String textBlockStart = argumentLiterals.substring(i, i + 3);
                    if (textBlockStart.equals("\"\"\"")) {
                        int endIndex = argumentLiterals.indexOf("\"\"\"", i + 3);
                        while (endIndex > 0 && argumentLiterals.charAt(endIndex - 1) == '\\') {
                            endIndex = argumentLiterals.indexOf("\"\"\"", endIndex + 3);
                        }
                        if (endIndex > 0) {
                            i = endIndex + 2;
                            break;
                        }
                        i = argumentLiterals.length() - 1;
                        break;
                    }
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '\"') break block0;
                        if (c == '\\') {
                            i += 2;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                case '(': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case ')': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '(') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '[': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case ']': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '[') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '{': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case '}': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '{') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '<': {
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '>') break block0;
                        ++i;
                    }
                    break;
                }
            }
            ++i;
        }
        if (hasArgument) {
            argumentRange[1] = argumentStartPosition + argumentLiterals.length() - 1;
            list.add(argumentRange);
        }
        this.argumentRanges = list;
    }

    private boolean isArgumentChar(char c) {
        return !Character.isWhitespace(c) && c != ')' && c != ']' && c != '}' & c != ';';
    }

    public int completionOffset() {
        return this.completionOffset;
    }

    public int secondaryCompletionOffset() {
        return this.secondaryCompletionOffset;
    }

    public List<int[]> argumentRanges() {
        return this.argumentRanges;
    }

    public String methodName() {
        return this.methodName;
    }

    public List<String> declaringTypeNames() {
        return this.declaringTypeNames;
    }

    public List<Expression> arguments() {
        return this.arguments;
    }

    public String[] parameterTypes() {
        return this.parameterTypes;
    }

    public String[] parameterTypesFromBinding() {
        return this.parameterTypesFromBinding;
    }

    public ASTNode targetNode() {
        return this.targetNode;
    }
}

