/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

class DOMCompletionContext
extends CompletionContext {
    private final int offset;
    private final char[] token;
    private final IJavaElement enclosingElement;
    private final Supplier<Stream<IBinding>> bindingsAcquirer;

    DOMCompletionContext(int offset, char[] token, IJavaElement enclosingElement, Supplier<Stream<IBinding>> bindingHaver) {
        this.offset = offset;
        this.enclosingElement = enclosingElement;
        this.token = token;
        this.bindingsAcquirer = bindingHaver;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public char[] getToken() {
        return this.token;
    }

    @Override
    public IJavaElement getEnclosingElement() {
        return this.enclosingElement;
    }

    @Override
    public IJavaElement[] getVisibleElements(String typeSignature) {
        return (IJavaElement[])this.bindingsAcquirer.get().filter(binding -> {
            if (typeSignature == null) {
                return binding instanceof IVariableBinding || binding instanceof IMethodBinding;
            }
            if (binding instanceof IVariableBinding) {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                return DOMCompletionContext.castCompatable(variableBinding.getType(), typeSignature);
            }
            if (binding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                return DOMCompletionContext.castCompatable(methodBinding.getReturnType(), typeSignature);
            }
            return false;
        }).map(binding -> binding.getJavaElement()).filter(obj -> obj != null).toArray(IJavaElement[]::new);
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    private static boolean castCompatable(ITypeBinding typeBinding, String sig2) {
        String sig1 = typeBinding.getKey().replace('/', '.');
        String sig1Raw = new String(Signature.getTypeErasure(sig1.toCharArray()));
        switch (sig1) {
            case "J": {
                return sig2.equals("J") || sig2.equals("D") || sig2.equals("F");
            }
            case "I": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("D") || sig2.equals("F");
            }
            case "B": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("B") || sig2.equals("D") || sig2.equals("F");
            }
            case "D": 
            case "F": {
                return sig2.equals("D") || sig2.equals("F");
            }
        }
        if (sig1.equals(sig2) || sig1Raw.equals(sig2)) {
            return true;
        }
        if (typeBinding.getSuperclass() != null && DOMCompletionContext.castCompatable(typeBinding.getSuperclass(), sig2)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            if (DOMCompletionContext.castCompatable(superInterface, sig2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

