/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.ClassFile;

public class JavacClassFile
extends ClassFile {
    private String fullName;
    private IContainer outputDir;
    private byte[] bytes = null;
    private File proxyFile = null;

    public JavacClassFile(String qualifiedName, ClassFile enclosingClass, IContainer outputDir) {
        this.fullName = qualifiedName;
        this.isNestedType = enclosingClass != null;
        this.enclosingClassFile = enclosingClass;
        this.outputDir = outputDir;
    }

    public JavacClassFile(JCTree.JCModuleDecl moduleDecl, IContainer outputDir) {
        this.fullName = "module-info";
        this.isNestedType = false;
        this.enclosingClassFile = null;
        this.outputDir = outputDir;
    }

    public char[][] getCompoundName() {
        String[] names = this.fullName.split("\\.");
        char[][] compoundNames = new char[names.length][];
        for (int i = 0; i < names.length; ++i) {
            compoundNames[i] = names[i].toCharArray();
        }
        return compoundNames;
    }

    public char[] fileName() {
        String compoundName = this.fullName.replace('.', '/');
        return compoundName.toCharArray();
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            File tempClassFile = this.getProxyTempClassFile();
            if (tempClassFile == null || !tempClassFile.exists()) {
                this.bytes = new byte[0];
            } else {
                try {
                    this.bytes = Files.readAllBytes(tempClassFile.toPath());
                }
                catch (IOException e) {
                    this.bytes = new byte[0];
                }
            }
        }
        return this.bytes;
    }

    File getProxyTempClassFile() {
        if (this.proxyFile == null) {
            this.proxyFile = JavacClassFile.computeMappedTempClassFile(this.outputDir, this.fullName);
        }
        return this.proxyFile;
    }

    void deleteTempClassFile() {
        File tempClassFile = this.getProxyTempClassFile();
        if (tempClassFile != null && tempClassFile.exists()) {
            tempClassFile.delete();
        }
    }

    void deleteExpectedClassFile() {
        IFile targetClassFile = JavacClassFile.computeExpectedClassFile(this.outputDir, this.fullName);
        if (targetClassFile != null) {
            try {
                targetClassFile.delete(true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static File computeMappedTempClassFile(IContainer expectedOutputDir, String qualifiedClassName) {
        if (expectedOutputDir != null) {
            IPath baseOutputPath = JavacClassFile.getMappedTempOutput(expectedOutputDir);
            String fileName = qualifiedClassName.replace('.', File.separatorChar);
            Path filePath = new Path(fileName);
            return baseOutputPath.append(filePath.addFileExtension("class")).toFile();
        }
        return null;
    }

    public static IFile computeExpectedClassFile(IContainer expectedOutputDir, String qualifiedClassName) {
        if (expectedOutputDir != null) {
            String fileName = qualifiedClassName.replace('.', File.separatorChar);
            Path filePath = new Path(fileName);
            return expectedOutputDir.getFile(filePath.addFileExtension("class"));
        }
        return null;
    }

    public static IPath getMappedTempOutput(IContainer expectedOutput) {
        IProject project = expectedOutput.getProject();
        if (project == null) {
            return expectedOutput.getRawLocation();
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.core");
        String tempOutputName = expectedOutput.getName() + "_" + Integer.toHexString(expectedOutput.hashCode());
        return workingLocation.append("javac/" + tempOutputName);
    }
}

