/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Timer;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Timer
extends Definition {
    private static final String NEGATIVDURATIONERROR = "A non-negative float value was expected as timer duration instead of {0}";
    private static final String INFINITYDURATIONERROR = "{0} can not be used as the default timer duration";
    private static final String OPERANDERROR = "The default timer duration should be a float value";
    private static final String FULLNAMEPART1 = ".<dimensions>";
    private static final String FULLNAMEPART2 = ".<default_duration>";
    private static final String KIND = "timer";
    private final ArrayDimensions dimensions;
    private final Value defaultDuration;

    public Def_Timer(Identifier identifier, ArrayDimensions dimensions, Value defaultDuration) {
        super(identifier);
        this.dimensions = dimensions;
        this.defaultDuration = defaultDuration;
        if (dimensions != null) {
            dimensions.setFullNameParent(this);
        }
        if (defaultDuration != null) {
            defaultDuration.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TIMER;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dimensions != null) {
            this.dimensions.setMyScope(scope);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.dimensions == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.defaultDuration == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "timer.gif";
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    public ArrayDimensions getDimensions() {
        return this.dimensions;
    }

    public boolean hasDefaultDuration(CompilationTimeStamp timestamp, Reference reference) {
        int nofReferences;
        if (this.defaultDuration == null) {
            return false;
        }
        if (this.dimensions == null || reference == null) {
            return true;
        }
        IValue v = this.defaultDuration;
        List<ISubReference> subreferences = reference.getSubreferences();
        int nofDimensions = this.dimensions.size();
        int upperLimit = nofDimensions < (nofReferences = subreferences.size() - 1) ? nofDimensions : nofReferences;
        for (int i = 0; i < upperLimit; ++i) {
            if (!IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)(v = v.getValueRefdLast(timestamp, null)).getValuetype())) continue;
            ISubReference ref = subreferences.get(i + 1);
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)ref.getReferenceType())) {
                return true;
            }
            Value index = ((ArraySubReference)ref).getValue();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)index.getValuetype())) {
                return true;
            }
            long realIndex = ((Integer_Value)index).getValue() - this.dimensions.get(i).getOffset();
            if (realIndex < 0L || realIndex >= (long)((SequenceOf_Value)v).getNofComponents()) continue;
            v = ((SequenceOf_Value)v).getValueByIndex((int)realIndex);
        }
        return !IValue.Value_type.NOTUSED_VALUE.equals((Object)v.getValuetype());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        if (this.getMyScope() instanceof ComponentTypeBody) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionComponentTimer", this.identifier, this);
        } else if (this.isLocal()) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalTimer", this.identifier, this);
        } else {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalTimer", this.identifier, this);
        }
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.dimensions != null) {
            this.dimensions.check(timestamp);
        }
        if (this.defaultDuration != null) {
            if (this.dimensions == null) {
                this.defaultDuration.setLoweridToReference(timestamp);
                IType.Type_type tempType = this.defaultDuration.getExpressionReturntype(timestamp, this.isLocal() ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : Expected_Value_type.EXPECTED_STATIC_VALUE);
                switch (tempType) {
                    case TYPE_REAL: {
                        IValue last = this.defaultDuration.getValueRefdLast(timestamp, null);
                        if (!last.isUnfoldable(timestamp)) {
                            Real_Value real = (Real_Value)last;
                            double value = real.getValue();
                            if (value < 0.0) {
                                this.defaultDuration.getLocation().reportSemanticError(MessageFormat.format(NEGATIVDURATIONERROR, value));
                            } else if (real.isPositiveInfinity()) {
                                String message = MessageFormat.format(INFINITYDURATIONERROR, real.createStringRepresentation());
                                this.defaultDuration.getLocation().reportSemanticError(message);
                            }
                        }
                        return;
                    }
                }
                this.defaultDuration.getLocation().reportSemanticError(OPERANDERROR);
            } else {
                this.checkArrayDuration(timestamp, this.defaultDuration, 0);
            }
            this.defaultDuration.setCodeSection(GovernedSimple.CodeSectionType.CS_POST_INIT);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    private void checkSingleDuration(CompilationTimeStamp timestamp, IValue duration) {
        duration.setLoweridToReference(timestamp);
        if (duration.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_STATIC_VALUE) == IType.Type_type.TYPE_REAL) {
            Real_Value value;
            double valueReal;
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            Value v = (Value)duration.getValueRefdLast(timestamp, referenceChain);
            referenceChain.release();
            if (!duration.isUnfoldable(timestamp) && v.getValuetype() == IValue.Value_type.REAL_VALUE && ((valueReal = (value = (Real_Value)v).getValue()) < 0.0 || value.isSpecialFloat())) {
                duration.getLocation().reportSemanticError("A non-negative float value was expected as timer duration instead of" + valueReal);
            }
        } else {
            duration.getLocation().reportSemanticError("Value is not real");
        }
    }

    private void checkArrayDuration(CompilationTimeStamp timestamp, IValue duration, int startDimension) {
        ArrayDimension dim = this.dimensions.get(startDimension);
        boolean arraySizeKnown = !dim.getIsErroneous(timestamp);
        int arraySize = 0;
        if (arraySizeKnown) {
            arraySize = (int)dim.getSize();
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        Value v = (Value)duration.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (v.getIsErroneous(timestamp)) {
            return;
        }
        if (v.getValuetype() == IValue.Value_type.SEQUENCEOF_VALUE) {
            SequenceOf_Value value = (SequenceOf_Value)v;
            int nofComp = value.getNofComponents();
            if (!value.isIndexed()) {
                if (arraySizeKnown) {
                    if (arraySize > nofComp) {
                        duration.getLocation().reportSemanticError("Too few elements in the default duration of timer array: " + arraySize + " was expected instead of " + nofComp);
                    } else if (arraySize < nofComp) {
                        duration.getLocation().reportSemanticError("Too many elements in the default duration of timer array: " + arraySize + " was expected instead of " + nofComp);
                    }
                }
                boolean last_dim = startDimension + 1 >= this.dimensions.size();
                for (int i = 0; i < nofComp; ++i) {
                    IValue array_v = value.getValueByIndex(i);
                    if (array_v.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                    if (last_dim) {
                        this.checkSingleDuration(timestamp, array_v);
                        continue;
                    }
                    this.checkArrayDuration(timestamp, array_v, startDimension + 1);
                }
            } else {
                boolean last_dim = startDimension + 1 >= this.dimensions.size();
                HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                for (int i = 0; i < nofComp; ++i) {
                    IValue array_v = value.getValueByIndex(i);
                    if (array_v.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                    if (last_dim) {
                        this.checkSingleDuration(timestamp, array_v);
                    } else {
                        this.checkArrayDuration(timestamp, array_v, startDimension + 1);
                    }
                    IValue array_index = value.getIndexByIndex(i);
                    dim.checkIndex(timestamp, array_index, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                    IValue tmp = array_index.getValueRefdLast(timestamp, referenceChain);
                    if (tmp.getValuetype() != IValue.Value_type.INTEGER_VALUE) continue;
                    BigInteger index = ((Integer_Value)tmp).getValueValue();
                    if (index.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        array_index.getLocation().reportSemanticError(MessageFormat.format("An integer value less than {0} was expected for indexing timer array instead of {1}", Integer.MAX_VALUE, index));
                        array_index.setIsErroneous(true);
                        continue;
                    }
                    int IndexValue = index.intValue();
                    if (indexMap.containsKey(IndexValue)) {
                        array_index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value {0} for timer array elements {1} and {2}", index, i + 1, indexMap.get(IndexValue)));
                        array_index.setIsErroneous(true);
                        continue;
                    }
                    indexMap.put(IndexValue, i + 1);
                }
                indexMap.clear();
            }
        } else {
            if (arraySizeKnown) {
                duration.getLocation().reportSemanticError("An array value (with " + arraySize + " elements) was expected as default duration of timer array");
            } else {
                duration.getLocation().reportSemanticError("An array value was expected as default duration of timer array");
            }
            duration.setIsErroneous(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_TIMER.semanticallyEquals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a timer, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Timer otherTimer = (Def_Timer)definition;
        if (this.dimensions != null) {
            if (otherTimer.dimensions == null) {
                this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a timer array, but the definition inherited from component type `{1}'' is a single timer", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
                return false;
            }
            if (!this.dimensions.isIdenticial(timestamp, otherTimer.dimensions)) {
                this.location.reportSemanticError(MessageFormat.format("Local timer `{0}'' and the timer inherited from component type `{1}'' have different array dimensions", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
                return false;
            }
        } else if (otherTimer.dimensions != null) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a single timer, but the definition inherited from component type `{1}'' is a timer array", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
            return false;
        }
        if (this.defaultDuration == null) {
            if (otherTimer.defaultDuration == null) return true;
            this.location.reportSemanticWarning(MessageFormat.format("Local timer `{0}'' does not have default duration, but the timer inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName()));
            return true;
        }
        if (otherTimer.defaultDuration != null) {
            if (this.defaultDuration.isUnfoldable(timestamp)) return true;
            if (otherTimer.defaultDuration.isUnfoldable(timestamp)) return true;
            if (this.defaultDuration.checkEquality(timestamp, otherTimer.defaultDuration)) return true;
            String message = MessageFormat.format("Local timer `{0}'' and the timer inherited from component type `{1}'' have different default durations", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName());
            this.defaultDuration.getLocation().reportSemanticWarning(message);
            return true;
        }
        String message = MessageFormat.format("Local timer `{0}'' has default duration, but the timer inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherTimer.getMyScope().getFullName());
        this.defaultDuration.getLocation().reportSemanticWarning(message);
        return true;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || !ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        }
        if (this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            Timer.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName()) && subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            declarationCollector.addDeclaration(this);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.defaultDuration == null) {
            result.add(252);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            int result = 1;
            Location tempIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(tempIdentifier) || reparser.isExtending(tempIdentifier)) {
                reparser.extendDamagedRegion(tempIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result != 0) {
                    throw new ReParseException(result);
                }
                if (this.dimensions != null) {
                    this.dimensions.updateSyntax(reparser, false);
                }
                if (this.defaultDuration != null) {
                    this.defaultDuration.updateSyntax(reparser, false);
                    reparser.updateLocation(this.defaultDuration.getLocation());
                }
                if (this.withAttributesPath != null) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.dimensions != null) {
            this.dimensions.updateSyntax(reparser, false);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.updateSyntax(reparser, false);
            reparser.updateLocation(this.defaultDuration.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.dimensions != null) {
            this.dimensions.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.defaultDuration != null) {
            this.defaultDuration.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.dimensions != null && !this.dimensions.accept(v)) {
            return false;
        }
        return this.defaultDuration == null || this.defaultDuration.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        StringBuilder sb = aData.getSrc();
        StringBuilder initComp = aData.getInitComp();
        StringBuilder source = new StringBuilder();
        if (!this.isLocal()) {
            source.append("public static ");
        }
        aData.addBuiltinTypeImport("TitanTimer");
        if (this.getMyScope() instanceof ComponentTypeBody) {
            if (this.dimensions == null) {
                if (this.defaultDuration == null) {
                    source.append(MessageFormat.format("final ThreadLocal<TitanTimer> {0} = new ThreadLocal<TitanTimer>() '{'\n", genName));
                    source.append("@Override\n");
                    source.append("protected TitanTimer initialValue() {\n");
                    source.append(MessageFormat.format("return new TitanTimer(\"{0}\");\n", this.identifier.getDisplayName()));
                    source.append("}\n");
                    source.append("};\n");
                } else if (this.defaultDuration.canGenerateSingleExpression()) {
                    source.append(MessageFormat.format("final ThreadLocal<TitanTimer> {0} = new ThreadLocal<TitanTimer>() '{'\n", genName));
                    source.append("@Override\n");
                    source.append("protected TitanTimer initialValue() {\n");
                    source.append(MessageFormat.format("return new TitanTimer(\"{1}\", {2});\n", genName, this.identifier.getDisplayName(), this.defaultDuration.generateSingleExpression(aData)));
                    source.append("}\n");
                    source.append("};\n");
                } else {
                    source.append(MessageFormat.format("final ThreadLocal<TitanTimer> {0} = new ThreadLocal<TitanTimer>() '{'\n", genName));
                    source.append("@Override\n");
                    source.append("protected TitanTimer initialValue() {\n");
                    source.append(MessageFormat.format("return new TitanTimer(\"{1}\");\n", genName, this.identifier.getDisplayName()));
                    source.append("}\n");
                    source.append("};\n");
                    ExpressionStruct expression = new ExpressionStruct();
                    expression.expression.append(genName);
                    expression.expression.append(".get().set_default_duration(");
                    this.defaultDuration.generateCodeExpression(aData, expression, true);
                    expression.expression.append(')');
                    expression.mergeExpression(aData.getPostInit());
                }
                if (this.defaultDuration != null) {
                    this.defaultDuration.generateCodeInit(aData, initComp, genName + ".get()");
                }
            } else {
                aData.addBuiltinTypeImport("TitanTimer_Array");
                ArrayList<String> classNames = new ArrayList<String>();
                ExpressionStruct expression = new ExpressionStruct();
                String elementName = this.generateClassCode(aData, sb, classNames);
                source.append(MessageFormat.format("final ThreadLocal<{0}> {1} = new ThreadLocal<{0}>() '{'\n", elementName, genName));
                source.append("@Override\n");
                source.append(MessageFormat.format("protected {0} initialValue() '{'\n", elementName));
                source.append(MessageFormat.format("return new {0}();\n", elementName));
                source.append("}\n");
                source.append("};\n");
                if (this.defaultDuration != null) {
                    this.generateCodeArrayDuration(aData, initComp, genName + ".get()", classNames, this.defaultDuration, 0);
                }
                expression.expression.append(genName);
                expression.expression.append(".get().set_name(\"");
                expression.expression.append(this.identifier.getDisplayName());
                expression.expression.append("\");\n");
                expression.mergeExpression(aData.getPreInit());
            }
        } else if (this.dimensions == null) {
            if (this.defaultDuration == null) {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\");\n", genName, this.identifier.getDisplayName()));
            } else if (this.defaultDuration.canGenerateSingleExpression()) {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\", {2});\n", genName, this.identifier.getDisplayName(), this.defaultDuration.generateSingleExpression(aData)));
            } else {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\");\n", genName, this.identifier.getDisplayName()));
                ExpressionStruct expression = new ExpressionStruct();
                expression.expression.append(genName);
                expression.expression.append(".set_default_duration(");
                this.defaultDuration.generateCodeExpression(aData, expression, true);
                expression.expression.append(')');
                expression.mergeExpression(aData.getPostInit());
            }
            if (this.defaultDuration != null) {
                this.defaultDuration.generateCodeInit(aData, initComp, genName);
            }
        } else {
            ArrayList<String> classNames = new ArrayList<String>();
            ExpressionStruct expression = new ExpressionStruct();
            aData.addBuiltinTypeImport("TitanTimer_Array");
            String elementName = this.generateClassCode(aData, sb, classNames);
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", elementName, genName));
            if (this.defaultDuration != null) {
                this.generateCodeArrayDuration(aData, initComp, genName, classNames, this.defaultDuration, 0);
            }
            expression.expression.append(genName);
            expression.expression.append(".set_name(\"");
            expression.expression.append(this.identifier.getDisplayName());
            expression.expression.append("\");\n");
            expression.mergeExpression(aData.getPreInit());
        }
        sb.append((CharSequence)source);
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        aData.addBuiltinTypeImport("TitanTimer");
        if (this.defaultDuration != null) {
            this.defaultDuration.setGenNameRecursive(this.getGenName());
        }
        if (this.dimensions == null) {
            if (this.defaultDuration == null) {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\");\n", genName, this.identifier.getDisplayName()));
            } else if (this.defaultDuration.canGenerateSingleExpression()) {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\", {2});\n", genName, this.identifier.getDisplayName(), this.defaultDuration.generateSingleExpression(aData)));
            } else {
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(\"{1}\");\n", genName, this.identifier.getDisplayName()));
                ExpressionStruct expression = new ExpressionStruct();
                expression.expression.append(genName);
                expression.expression.append(".set_default_duration(");
                this.defaultDuration.generateCodeExpression(aData, expression, true);
                expression.expression.append(')');
                expression.mergeExpression(source);
            }
        } else {
            ArrayList<String> classNames = new ArrayList<String>();
            aData.addBuiltinTypeImport("TitanTimer_Array");
            StringBuilder sb = aData.getCodeForType(genName);
            String elementName = this.generateClassCode(aData, sb, classNames);
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", elementName, genName));
            if (this.defaultDuration != null) {
                this.generateCodeArrayDuration(aData, source, genName, classNames, this.defaultDuration, 0);
            }
            source.append(genName).append(".set_name(\"").append(this.identifier.getDisplayName()).append("\");\n");
        }
    }

    private void generateCodeArrayDuration(JavaGenData aData, StringBuilder source, String genName, ArrayList<String> classNames, Value defaultDuration2, int startDim) {
        ArrayDimension dim = this.dimensions.get(startDim);
        int dim_size = (int)dim.getSize();
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        Value v = (Value)defaultDuration2.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        if (v.getValuetype() != IValue.Value_type.SEQUENCEOF_VALUE) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            return;
        }
        SequenceOf_Value value = (SequenceOf_Value)v;
        if (value.getNofComponents() != dim_size && !value.isIndexed()) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            return;
        }
        if (!value.isIndexed()) {
            if (startDim + 1 < this.dimensions.size()) {
                for (int i = 0; i < dim_size; ++i) {
                    IValue v_elem = value.getValueByIndex(i);
                    if (v_elem.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                    String embeddedName = MessageFormat.format("{0}.get_at({1,number,#})", genName, (long)i + dim.getOffset());
                    this.generateCodeArrayDuration(aData, source, embeddedName, classNames, (Value)v_elem, startDim + 1);
                }
            } else {
                for (int i = 0; i < dim_size; ++i) {
                    IValue v_elem = value.getValueByIndex(i);
                    if (v_elem.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                    ExpressionStruct expression = new ExpressionStruct();
                    expression.expression.append(genName);
                    expression.expression.append(MessageFormat.format(".get_at({0,number,#})", (long)i + dim.getOffset()));
                    expression.expression.append(".operator_assign(");
                    v_elem.generateCodeExpression(aData, expression, true);
                    expression.expression.append(')');
                    expression.mergeExpression(source);
                }
            }
        } else if (startDim + 1 < this.dimensions.size()) {
            for (int i = 0; i < value.getNofComponents(); ++i) {
                IValue v_elem = value.getValueByIndex(i);
                IValue index = value.getIndexByIndex(i);
                if (v_elem.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                String tempId1 = aData.getTemporaryVariableName();
                String tempIdX = aData.getTemporaryVariableName();
                source.append("{\n");
                source.append(MessageFormat.format("final TitanInteger {0} = new TitanInteger();\n", tempIdX));
                index.generateCodeInit(aData, source, tempIdX);
                source.append(MessageFormat.format("final {0} {1} = {2}.get_at({3});\n", classNames.get(classNames.size() - startDim - 2), tempId1, genName, tempIdX));
                this.generateCodeArrayDuration(aData, source, tempId1, classNames, (Value)v_elem, startDim + 1);
                source.append("}\n");
            }
        } else {
            for (int i = 0; i < value.getNofComponents(); ++i) {
                IValue v_elem = value.getValueByIndex(i);
                IValue v_elemIndex = value.getIndexByIndex(i);
                if (v_elem.getValuetype() == IValue.Value_type.NOTUSED_VALUE) continue;
                ExpressionStruct expression = new ExpressionStruct();
                String tempIdX = aData.getTemporaryVariableName();
                source.append("{\n");
                source.append(MessageFormat.format("final TitanInteger {0} = new TitanInteger();\n", tempIdX));
                v_elemIndex.generateCodeInit(aData, source, tempIdX);
                String embeddedName = MessageFormat.format("{0}.get_at(", genName);
                expression.expression.append(embeddedName).append(tempIdX).append(")");
                expression.expression.append(".operator_assign(");
                v_elem.generateCodeExpression(aData, expression, true);
                expression.expression.append(')');
                expression.mergeExpression(source);
                source.append("}\n");
            }
        }
    }

    private String generateClassCode(JavaGenData aData, StringBuilder sb, ArrayList<String> list) {
        String tempId1 = "TitanTimer";
        for (int i = 0; i < this.dimensions.size(); ++i) {
            ArrayDimension dim = this.dimensions.get(this.dimensions.size() - i - 1);
            String tempId2 = aData.getTemporaryVariableName();
            list.add(tempId2);
            sb.append(MessageFormat.format("public static class {0} extends TitanTimer_Array<{1}> '{'\n", tempId2, tempId1));
            sb.append(MessageFormat.format("public {0}() '{'\n", tempId2));
            sb.append(MessageFormat.format("super({0}.class, {1,number,#}, {2,number,#});\n", tempId1, dim.getSize(), dim.getOffset()));
            sb.append("}\n");
            sb.append(MessageFormat.format("public {0}({0} otherValue) '{'\n", tempId2));
            sb.append("super(otherValue);\n");
            sb.append("}\n }\n\n");
            tempId1 = tempId2;
        }
        return tempId1;
    }

    @Override
    public void generateCodeInitComp(JavaGenData aData, StringBuilder initComp, Definition definition) {
        if (this.defaultDuration == null) {
            return;
        }
        if (!(definition instanceof Def_Timer)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            return;
        }
        Def_Timer baseTimerDefinition = (Def_Timer)definition;
        if (baseTimerDefinition.defaultDuration == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            return;
        }
        if (this.defaultDuration.isUnfoldable(CompilationTimeStamp.getBaseTimestamp()) || baseTimerDefinition.defaultDuration.isUnfoldable(CompilationTimeStamp.getBaseTimestamp()) || this.defaultDuration.checkEquality(CompilationTimeStamp.getBaseTimestamp(), baseTimerDefinition.defaultDuration)) {
            if (this.dimensions == null) {
                ExpressionStruct expression = new ExpressionStruct();
                expression.expression.append(baseTimerDefinition.getGenNameFromScope(aData, initComp, ""));
                expression.expression.append(".set_default_duration(");
                this.defaultDuration.generateCodeExpression(aData, expression, true);
                expression.expression.append(')');
                expression.mergeExpression(initComp);
            } else {
                this.generateCodeArrayDuration(aData, initComp, baseTimerDefinition.getGenNameFromScope(aData, initComp, ""), new ArrayList<String>(), baseTimerDefinition.defaultDuration, 0);
            }
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("timer ");
        this.hoverContent.addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

