/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IMemberInfo;
import org.eclipse.titan.designer.AST.TTCN3.types.Address_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.Testcase_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Type
extends Definition {
    private final Type type;
    private NamedBridgeScope bridgeScope = null;
    private boolean hasSimilarName = false;

    public Def_Type(Identifier identifier, Type type) {
        this(identifier, type, null);
    }

    public Def_Type(Identifier identifier, Type type, DocumentComment documentComment) {
        super(identifier);
        this.type = type;
        if (type != null) {
            type.setFullNameParent(this);
            type.setOwnertype(IType.TypeOwner_type.OT_TYPE_DEF, this);
        }
        this.documentComment = documentComment;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TYPE;
    }

    @Override
    public String getAssignmentName() {
        return "type";
    }

    @Override
    public String getOutlineIcon() {
        if (this.type != null) {
            return this.type.getOutlineIcon();
        }
        return "type.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    public final void setHasSimilarName(boolean status) {
        this.hasSimilarName = status;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public Type getSetting(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.type != null) {
            this.type.setMyScope(this.bridgeScope);
        }
    }

    @Override
    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.type == null) {
            return;
        }
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
            this.type.setAttributeParentPath(this.withAttributesPath);
        }
        this.type.setWithAttributes(attributes);
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        super.setAttributeParentPath(parent);
        if (this.type == null) {
            return;
        }
        this.type.setAttributeParentPath(this.getAttributePath());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        if (!"ADDRESS".equals(this.identifier.getTtcnName()) && !"anytype".equals(this.identifier.getTtcnName())) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionType", this.identifier, this);
            NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        }
        if (this.type == null) {
            return;
        }
        this.type.setGenName(this.getGenName() + (this.hasSimilarName ? "_at_offset" + this.getLocation().getOffset() : ""));
        if (IType.Type_type.TYPE_COMPONENT.equals((Object)this.type.getTypetype())) {
            ((Component_Type)this.type).getComponentBody().setGenName(this.getGenName() + "_component_");
        }
        this.type.check(timestamp);
        this.type.checkConstructorName(this.identifier.getName());
        if ("ADDRESS".equals(this.identifier.getTtcnName())) {
            Address_Type.checkAddress(timestamp, this.type);
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        this.type.checkRecursions(timestamp, chain);
        chain.release();
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp, this.type.getTypetype());
            this.hasImplicitOmitAttribute(timestamp);
            this.analyzeExtensionAttributes(timestamp, this.withAttributesPath);
        }
        switch (this.type.getTypetype()) {
            case TYPE_FUNCTION: {
                ((Function_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
            case TYPE_ALTSTEP: {
                ((Altstep_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
            case TYPE_TESTCASE: {
                ((Testcase_Type)this.type).getFormalParameters().setMyDefinition(this);
                break;
            }
        }
        AstSyntaxHighlightTokens.addSyntaxDecoration(this.identifier.getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.DefType);
        this.checkDocumentComment();
    }

    @Override
    public void postCheck() {
        super.postCheck();
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp, WithAttributesPath withAttributesPath) {
        int i;
        List<SingleWithAttribute> realAttributes = withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (SingleWithAttribute attribute : realAttributes) {
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType())) continue;
            Qualifiers qualifiers = attribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) {
                if (specifications == null) {
                    specifications = new ArrayList<AttributeSpecification>();
                }
                specifications.add(attribute.getAttributeSpecification());
                continue;
            }
            int size2 = qualifiers.getNofQualifiers();
            for (int j = 0; j < size2; ++j) {
                Qualifier tempQualifier = qualifiers.getQualifierByIndex(j);
                ISubReference tempSubReference = tempQualifier.getSubReferenceByIndex(0);
                if (tempSubReference.getReferenceType() == ISubReference.Subreference_type.arraySubReference) {
                    tempQualifier.getLocation().reportSemanticError("Invalid field qualifier [-]");
                    continue;
                }
                tempQualifier.getLocation().reportSemanticError(MessageFormat.format("Invalid field qualifier {0}", tempSubReference.getId().getDisplayName()));
            }
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        block6: for (i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            switch (extensionAttribute.getAttributeType()) {
                case ANYTYPE: 
                case VERSION: 
                case REQUIRES: 
                case TITANVERSION: {
                    continue block6;
                }
                default: {
                    extensionAttribute.getLocation().reportSemanticError("Extension attributes are not supported for types");
                }
            }
        }
    }

    @Override
    public String getProposalKind() {
        if (this.type != null) {
            return this.type.getProposalDescription(new StringBuilder()).toString();
        }
        return "unknown type";
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.type == null) {
            return super.getOutlineChildren();
        }
        return this.type.getOutlineChildren();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
        if (this.type != null && IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)this.type.getTypetype())) {
            this.type.addProposal(propCollector, index);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        } else if (this.type != null && IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)this.type.getTypetype()) && (declarationCollector.getReference().getModuleIdentifier() != null && index == 1 || index == 0)) {
            this.type.addDeclaration(declarationCollector, index);
        }
        if (this.type != null && IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)this.type.getTypetype()) && (declarationCollector.getReference().getModuleIdentifier() != null && index == 1 || index == 0)) {
            this.type.addDeclaration(declarationCollector, index);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(297);
        result.add(88);
        result.add(295);
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            result.add(175);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    try {
                        this.type.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.type.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.type == null || this.type.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        if (this.type == null) {
            return;
        }
        StringBuilder sb = aData.getCodeForType(genName);
        StringBuilder source = new StringBuilder();
        this.type.generateCode(aData, source);
        if (IType.Type_type.TYPE_COMPONENT.equals((Object)this.type.getTypetype())) {
            ((Component_Type)this.type).getComponentBody().generateCode(aData, source);
        }
        sb.append((CharSequence)source);
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        CompilationTimeStamp timestamp;
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        CompilationTimeStamp compilationTimeStamp = timestamp = this.lastTimeChecked != null ? this.lastTimeChecked : CompilationTimeStamp.getBaseTimestamp();
        if (timestamp == null) {
            return this.hoverContent;
        }
        Type assType = this.getType(timestamp);
        boolean isClass = assType.getTypetype() == IType.Type_type.TYPE_CLASS;
        this.hoverContent.addIcon(assType.getOutlineIcon());
        switch (assType.getTypetype()) {
            case TYPE_ALTSTEP: {
                this.hoverContent.addText("type altstep ");
                break;
            }
            case TYPE_CLASS: {
                this.hoverContent.addText("class ");
                break;
            }
            case TYPE_COMPONENT: {
                this.hoverContent.addText("type component ");
                break;
            }
            case TYPE_FUNCTION: {
                this.hoverContent.addText("type function ");
                break;
            }
            case TYPE_PORT: {
                this.hoverContent.addText("type port ");
                break;
            }
            case TYPE_SIGNATURE: {
                this.hoverContent.addText("type signature ");
                break;
            }
            case TYPE_TESTCASE: {
                this.hoverContent.addText("type testcase ");
                break;
            }
            case TYPE_TTCN3_CHOICE: {
                this.hoverContent.addText("type union ");
                break;
            }
            case TYPE_TTCN3_ENUMERATED: {
                this.hoverContent.addText("type enumerated ");
                break;
            }
            case TYPE_TTCN3_SEQUENCE: {
                this.hoverContent.addText("type record ");
                break;
            }
            case TYPE_SEQUENCE_OF: {
                this.hoverContent.addText("type record of ");
                break;
            }
            case TYPE_TTCN3_SET: {
                this.hoverContent.addText("type set ");
                break;
            }
            case TYPE_SET_OF: {
                this.hoverContent.addText("type set of ");
                break;
            }
            default: {
                this.hoverContent.addText("type ");
            }
        }
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>", 1).addStyledText(" ").closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
        }
        if (isClass) {
            Class_Type ct = (Class_Type)assType;
            if (ct != null) {
                ct.addClassMembers(this, this.hoverContent, dc);
            }
        } else if (dc != null) {
            dc.addMembersContent(this.hoverContent);
        } else if (assType instanceof IMemberInfo) {
            IMemberInfo mInfo = (IMemberInfo)((Object)assType);
            mInfo.addMembersContent(this.hoverContent);
        }
        if (dc != null) {
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        CompilationTimeStamp timestamp;
        CompilationTimeStamp compilationTimeStamp = timestamp = this.lastTimeChecked != null ? this.lastTimeChecked : CompilationTimeStamp.getBaseTimestamp();
        if (timestamp == null) {
            return "";
        }
        Type assType = this.getType(timestamp);
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append('\n');
        switch (assType.getTypetype()) {
            case TYPE_CLASS: {
                Class_Type ct = (Class_Type)assType;
                for (Definition def : ct.getDefinitions()) {
                    boolean functionOverride = false;
                    if (def instanceof Def_Function && ((Def_Function)def).isOverride()) {
                        functionOverride = true;
                    }
                    if (def.isInherited() && !functionOverride) continue;
                    sb.append(ind).append("@member").append(' ').append(def.getIdentifier().getDisplayName()).append('\n');
                }
                break;
            }
            case TYPE_TTCN3_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Set_Seq_Choice_BaseType choice = (TTCN3_Set_Seq_Choice_BaseType)assType;
                for (int i = 0; i < choice.getNofComponents(); ++i) {
                    sb.append(ind).append("@member").append(' ').append(choice.getComponentByIndex(i).getIdentifier().getDisplayName()).append('\n');
                }
                break;
            }
            case TYPE_COMPONENT: {
                Component_Type component = (Component_Type)assType;
                for (Definition def : component.getComponentBody().getDefinitions()) {
                    sb.append(ind).append("@member").append(' ').append(def.getIdentifier().getDisplayName()).append('\n');
                }
                break;
            }
            case TYPE_TTCN3_ENUMERATED: {
                TTCN3_Enumerated_Type enumerated = (TTCN3_Enumerated_Type)assType;
                for (EnumItem item : enumerated.getEnumItemsOrdered()) {
                    sb.append(ind).append("@member").append(' ').append(item.getId().getDisplayName()).append('\n');
                }
                break;
            }
        }
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

