/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IMemberInfo;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public class Def_Var
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<initial_value>";
    public static final String PORTNOTALLOWED = "Variable can not be defined for port type `{0}''";
    public static final String SIGNATURENOTALLOWED = "Variable can not be defined for signature `{0}''";
    private static final String KIND = " variable definition";
    protected final Type type;
    private Value initialValue;
    private boolean wasAssigned;
    private final FormalParameter.parameterEvaluationType evaluationType;

    public Def_Var(Identifier identifier, Type type, Value initialValue, FormalParameter.parameterEvaluationType evaluationType) {
        super(identifier);
        this.type = type;
        this.initialValue = initialValue;
        this.evaluationType = evaluationType;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_VAR_DEF, this);
            type.setFullNameParent(this);
        }
        if (initialValue != null) {
            initialValue.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_VAR;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.initialValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.initialValue != null) {
            this.initialValue.setMyScope(scope);
        }
    }

    @Override
    public String getAssignmentName() {
        return "variable";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "variable.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public Value getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setWithAttributes(MultipleWithAttributes attributes) {
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        this.isUsed = false;
        this.wasAssigned = false;
        if (!(this.getMyScope() instanceof ClassTypeBody)) {
            if (this.getMyScope() instanceof ComponentTypeBody) {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionComponentVariable", this.identifier, this);
            } else {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalVariable", this.identifier, this);
            }
            NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        }
        if (this.type == null) {
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp);
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
            case TYPE_SIGNATURE: {
                this.location.reportSemanticError(MessageFormat.format(SIGNATURENOTALLOWED, lastType.getFullName()));
                break;
            }
        }
        if (this.initialValue != null) {
            this.initialValue.setMyGovernor(this.type);
            IValue temporalValue = this.type.checkThisValueRef(timestamp, this.initialValue);
            if (this.isLocal()) {
                this.type.checkThisValue(timestamp, temporalValue, this, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
            } else {
                this.type.checkThisValue(timestamp, temporalValue, this, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_STATIC_VALUE, true, false, true, false, false));
            }
            this.initialValue.setGenNameRecursive(this.getGenName());
            this.initialValue.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        }
        AstSyntaxHighlightTokens.addSyntaxDecoration(this.getIdentifier().getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Variable);
    }

    public void setWritten() {
        this.wasAssigned = true;
    }

    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_VAR.semanticallyEquals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a variable, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Var otherVariable = (Def_Var)definition;
        if (!this.type.isIdentical(timestamp, otherVariable.type)) {
            String message = MessageFormat.format("Local variable `{0}'' has type `{1}'', but the variable inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.type.getTypename(), otherVariable.getMyScope().getFullName(), otherVariable.type.getTypename());
            this.type.getLocation().reportSemanticError(message);
            return false;
        }
        if (this.initialValue != null) {
            if (otherVariable.initialValue != null) {
                if (!(this.initialValue.isUnfoldable(timestamp) || otherVariable.initialValue.isUnfoldable(timestamp) || this.initialValue.checkEquality(timestamp, otherVariable.initialValue))) {
                    String message = MessageFormat.format("Local variable `{0}'' and the variable inherited from component type `{1}'' have different values", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName());
                    this.initialValue.getLocation().reportSemanticWarning(message);
                }
            } else {
                this.initialValue.getLocation().reportSemanticWarning(MessageFormat.format("Local variable `{0}'' has initial value, but the variable inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
            }
        } else if (otherVariable.initialValue != null) {
            this.location.reportSemanticWarning(MessageFormat.format("Local variable `{0}'' does not have initial value, but the variable inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
        }
        return true;
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.initialValue == null) {
            result.add(252);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            int result = 1;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.initialValue != null) {
                if (enveloped) {
                    this.initialValue.updateSyntax(reparser, false);
                    reparser.updateLocation(this.initialValue.getLocation());
                } else if (reparser.envelopsDamage(this.initialValue.getLocation())) {
                    this.initialValue.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.initialValue.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.initialValue != null) {
            this.initialValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.initialValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.initialValue != null) {
            this.initialValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.initialValue == null || this.initialValue.accept(v);
    }

    public boolean getWritten() {
        return this.wasAssigned;
    }

    public FormalParameter.parameterEvaluationType get_eval_type() {
        return this.evaluationType;
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        StringBuilder initComp = aData.getInitComp();
        if (!this.isLocal()) {
            source.append("\tpublic static final ");
        }
        String typeGeneratedName = this.type.getGenNameValue(aData, source);
        if (this.type.getTypetype() == IType.Type_type.TYPE_ARRAY) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder sbforTemp = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, sbforTemp);
        }
        if (this.getMyScope() instanceof ComponentTypeBody) {
            source.append(MessageFormat.format("ThreadLocal<{0}> {1} = new ThreadLocal<{0}>() '{'\n", typeGeneratedName, genName));
            source.append("@Override\n");
            source.append(MessageFormat.format("protected {0} initialValue() '{'\n", typeGeneratedName));
            source.append(MessageFormat.format("return new {0}();\n", typeGeneratedName));
            source.append("}\n");
            source.append("};\n");
            sb.append((CharSequence)source);
            if (this.initialValue != null) {
                this.initialValue.generateCodeInit(aData, initComp, genName + ".get()");
            } else if (cleanUp) {
                initComp.append(genName);
                initComp.append(".get().clean_up();\n");
            }
        } else {
            source.append(MessageFormat.format("{0} {1} = new {0}();\n", typeGeneratedName, genName));
            sb.append((CharSequence)source);
            if (this.initialValue != null) {
                this.initialValue.generateCodeInit(aData, initComp, genName);
            } else if (cleanUp) {
                initComp.append(genName);
                initComp.append(".clean_up();\n");
            }
        }
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        String typeGeneratedName = this.type.getGenNameValue(aData, source);
        if (this.type.getTypetype() == IType.Type_type.TYPE_ARRAY) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder sb = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, sb);
            arrayType.generateCodeTemplate(aData, sb);
        }
        if (this.initialValue != null && this.initialValue.canGenerateSingleExpression()) {
            ExpressionStruct expression = new ExpressionStruct();
            this.initialValue.generateCodeExpressionMandatory(aData, expression, false);
            if (this.initialValue.returnsNative() || this.initialValue.getValuetype() == IValue.Value_type.REFERENCED_VALUE || this.initialValue.getValuetype() == IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE || this.type.getTypetypeTtcn3() != this.initialValue.getExpressionReturntype(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE)) {
                source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", typeGeneratedName, genName, expression.expression));
            } else {
                source.append(MessageFormat.format("final {0} {1} = {2};\n", typeGeneratedName, genName, expression.expression));
            }
        } else {
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", typeGeneratedName, genName));
            if (this.initialValue != null) {
                this.initialValue.generateCodeInit(aData, source, genName);
            }
        }
    }

    @Override
    public void generateCodeInitComp(JavaGenData aData, StringBuilder initComp, Definition definition) {
        if (this.initialValue != null) {
            this.initialValue.generateCodeInit(aData, initComp, definition.getGenNameFromScope(aData, initComp, ""));
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        Class_Type ct;
        IType assType;
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        if ((assType = this.getType(this.getLastTimeChecked())) instanceof Referenced_Type) {
            assType = assType.getTypeRefdLast(this.lastTimeChecked);
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("var ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        if (assType instanceof Class_Type && (ct = (Class_Type)assType) != null) {
            ct.addClassMembers(this, this.hoverContent, dc);
        }
        if (assType instanceof IMemberInfo) {
            IMemberInfo mInfo = (IMemberInfo)((Object)assType);
            mInfo.addMembersContent(this.hoverContent);
        }
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }

    public Value stealValue() {
        Value retval = this.initialValue;
        this.initialValue = null;
        return retval;
    }
}

