/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.DecodeMatch_template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class OctetString_Type
extends ASN1Type {
    private static final String OCTETSTRINGVALUEEXPECTED1 = "(reference to) OCTET STRING value was expected";
    private static final String OCTETSTRINGVALUEEXPECTED2 = "OCTET STRING value was expected";
    private static final String OCTETSTRINGVALUEEXPECTED3 = "octetstring value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `octetstring''";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_OCTETSTRING;
    }

    @Override
    public IASN1Type newInstance() {
        return new OctetString_Type();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_OCTETSTRING.equals((Object)temp.getTypetype()) || !this.isAsn() && IType.Type_type.TYPE_ANY.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "octetstring";
    }

    @Override
    public String getOutlineIcon() {
        return "octetstring.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_OCTETSTRING;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.initAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        IValue last;
        boolean selfReference;
        block18: {
            block17: {
                IType lastType;
                selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
                last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
                if (last == null || last.getIsErroneous(timestamp)) {
                    return selfReference;
                }
                switch (value.getValuetype()) {
                    case OMIT_VALUE: 
                    case REFERENCED_VALUE: {
                        return selfReference;
                    }
                    case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                        if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                        return selfReference;
                    }
                }
                if (!last.isAsn()) break block17;
                if (IValue.Value_type.REFERENCED_VALUE.equals((Object)value.getValuetype()) && !(lastType = last.getMyGovernor().getTypeRefdLast(timestamp)).getIsErroneous(timestamp) && !IType.Type_type.TYPE_OCTETSTRING.equals((Object)lastType.getTypetype())) {
                    value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED1);
                    value.setIsErroneous(true);
                    return selfReference;
                }
                switch (last.getValuetype()) {
                    case OCTETSTRING_VALUE: {
                        break;
                    }
                    case BITSTRING_VALUE: 
                    case HEXSTRING_VALUE: {
                        if (last == value) {
                            last = last.setValuetype(timestamp, IValue.Value_type.OCTETSTRING_VALUE);
                            break;
                        }
                        break block18;
                    }
                    case EXPRESSION_VALUE: 
                    case MACRO_VALUE: {
                        break;
                    }
                    default: {
                        value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED2);
                        value.setIsErroneous(true);
                        break;
                    }
                }
                break block18;
            }
            switch (last.getValuetype()) {
                case OCTETSTRING_VALUE: {
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED3);
                    value.setIsErroneous(true);
                }
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case OSTR_PATTERN: {
                break;
            }
            case DECODE_MATCH: {
                selfReference = ((DecodeMatch_template)template).checkThisTemplateString(timestamp, this, implicitOmit, lhs);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
            }
        }
        return selfReference;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        int restrictionLength;
        if (this.subType != null && (restrictionLength = this.subType.get_length_restriction()) != -1) {
            if (this.rawAttribute == null) {
                this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
            }
            if (this.rawAttribute.fieldlength == 0) {
                this.rawAttribute.fieldlength = restrictionLength * 8;
                this.rawAttribute.length_restriction = -1;
            } else {
                this.rawAttribute.length_restriction = restrictionLength;
            }
        }
        this.checkJson(timestamp);
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case RAW: 
            case TEXT: 
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                Value indexValue = ((ArraySubReference)subreference).getValue();
                this.checkStringIndex(timestamp, indexValue, expectedIndex, refChain);
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public int getLengthMultiplier() {
        return 8;
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        if (this.rawAttribute != null && this.rawAttribute.fieldlength > 0) {
            return this.rawAttribute.fieldlength;
        }
        return -1;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("octetstring");
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() == i + 1) {
            declarationCollector.addDeclaration("octetstring", this.location, this);
        }
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.hasRawAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return "OCTET__STRING";
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanOctetString");
        return "TitanOctetString";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanOctetString_template");
        return "TitanOctetString_template";
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        this.generateCodeIspresentBound_forStrings(aData, expression, subreferences, subReferenceIndex, globalId, externalId, isTemplate, optype, field, targetScope);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || !this.isAsn() && this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanOctetString");
        return "TitanOctetString.TitanOctetString";
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return this.rawAttribute != null;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute == null) {
            aData.addBuiltinTypeImport("TitanOctetString");
            return "TitanOctetString.TitanOctetString_raw_";
        }
        if (this.needsAlias()) {
            return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
        }
        return this.getGenNameOwn(aData) + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("TitanOctetString");
        return "TitanOctetString.TitanOctetString_json_";
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        aData.addBuiltinTypeImport("TitanOctetString");
        return MessageFormat.format("TitanOctetString.convert_to_OctetString({0})", fromName);
    }
}

