/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.titan.designer.editors.asn1editor.ASN1FoldingSupport;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.progress.IProgressConstants;

public final class ReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final String OUTLINEUPDATE = "Outline update";
    private ASN1Editor editor;
    private IDocument document;

    public ASN1Editor getEditor() {
        return this.editor;
    }

    public void setEditor(ASN1Editor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.fullReconciliation(false);
    }

    public void reconcile(IRegion partition) {
        this.fullReconciliation(false);
    }

    public void initialReconcile() {
        this.fullReconciliation(true);
    }

    private void fullReconciliation(boolean isInitial) {
        GlobalIntervalHandler.putInterval(this.document, null);
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            this.analyze(isInitial);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    List<Position> positions = new ASN1FoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                    ReconcilingStrategy.this.editor.updateFoldingStructure(positions);
                    IFile file = (IFile)ReconcilingStrategy.this.editor.getEditorInput().getAdapter(IFile.class);
                    if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)file) || !MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflyMixedMarker", (IResource)file)) {
                        ReconcilingStrategy.this.getEditor().updateOutlinePage();
                    }
                }
            });
        }
    }

    void analyze(boolean isInitial) {
        final IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        WorkspaceJob op = new WorkspaceJob(OUTLINEUPDATE){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TITANDebugConsole.println("outline update started");
                        List<Position> positions = new ASN1FoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                        ReconcilingStrategy.this.getEditor().updateFoldingStructure(positions);
                        if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)editedFile) || !MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflyMixedMarker", (IResource)editedFile)) {
                            ReconcilingStrategy.this.getEditor().updateOutlinePage();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        op.setPriority(30);
        op.setUser(true);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule((ISchedulingRule)project);
        op.schedule();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

