/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.common.parsers.cfg.indices.ComponentSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentsSubPage;

public final class ComponentSectionDragSourceListener
implements DragSourceListener {
    private final TableViewer viewer;
    private final ComponentsSubPage componentsSubPage;

    public ComponentSectionDragSourceListener(ComponentsSubPage componentsSubPage, TableViewer viewer) {
        this.componentsSubPage = componentsSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.componentsSubPage.removeSelectedComponents();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (ComponentItemTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<ComponentSectionHandler.Component> items = new ArrayList<ComponentSectionHandler.Component>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof ComponentSectionHandler.Component)) continue;
                    items.add((ComponentSectionHandler.Component)element);
                }
                event.data = items.toArray(new ComponentSectionHandler.Component[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof ComponentSectionHandler.Component;
    }
}

