/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ISourceAnalyzer;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.PreprocessedTokenStream;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Lexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Parser;
import org.eclipse.titan.designer.properties.data.PreprocessorSymbolsOptionsData;

public class TTCN3Analyzer
implements ISourceAnalyzer {
    private List<TITANMarker> warningsAndErrors;
    private List<TITANMarker> unsupportedConstructs;
    private Interval rootInterval;
    private TTCN3Module actualTtc3Module;
    private List<SyntacticErrorStorage> mErrorsStored = null;

    @Override
    public List<SyntacticErrorStorage> getErrorStorage() {
        return this.mErrorsStored;
    }

    @Override
    public List<TITANMarker> getWarnings() {
        return this.warningsAndErrors;
    }

    @Override
    public List<TITANMarker> getUnsupportedConstructs() {
        return this.unsupportedConstructs;
    }

    @Override
    public TTCN3Module getModule() {
        return this.actualTtc3Module;
    }

    @Override
    public Interval getRootInterval() {
        return this.rootInterval;
    }

    @Override
    public void parse(IFile aFile, String aCode) {
        int rootInt;
        Reader reader;
        if (aCode != null) {
            reader = new StringReader(aCode);
            rootInt = aCode.length();
        } else if (aFile != null) {
            IFileStore store;
            try {
                InputStreamReader temp = new InputStreamReader(aFile.getContents());
                if (!aFile.getCharset().equals(temp.getEncoding())) {
                    try {
                        temp.close();
                    }
                    catch (IOException e) {
                        ErrorReporter.logWarningExceptionStackTrace((Exception)e);
                    }
                    temp = new InputStreamReader(aFile.getContents(), aFile.getCharset());
                }
                reader = new BufferedReader(temp);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            catch (UnsupportedEncodingException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                return;
            }
            try {
                store = EFS.getStore((URI)aFile.getLocationURI());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            IFileInfo fileInfo = store.fetchInfo();
            rootInt = (int)fileInfo.getLength();
        } else {
            return;
        }
        this.parse(reader, rootInt, aFile);
    }

    private void parse(Reader aReader, int aFileLength, IFile aEclipseFile) {
        Ttcn3Parser parser;
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean realtimeEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableRealtimeExtension", false, null);
        boolean oopEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableOOPExtension", false, null);
        UnbufferedCharStream charStream = new UnbufferedCharStream(aReader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.enableOop(oopEnabled);
        lexer.setCommentTodo(true);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.initRootInterval(aFileLength);
        if (realtimeEnabled) {
            lexer.enableRealtime();
        }
        TitanListener lexerListener = new TitanListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        PreprocessedTokenStream preprocessor = null;
        if (aEclipseFile != null && "ttcnpp".equals(aEclipseFile.getFileExtension())) {
            lexer.setTTCNPP();
            preprocessor = new PreprocessedTokenStream((TokenSource)lexer);
            preprocessor.setActualFile(aEclipseFile);
            if (aEclipseFile.getProject() != null) {
                preprocessor.setMacros(PreprocessorSymbolsOptionsData.getTTCN3PreprocessorDefines(aEclipseFile.getProject()));
            }
            parser = new Ttcn3Parser((TokenStream)preprocessor);
            parser.enableOop(oopEnabled);
            ParserUtilities.setBuildParseTree(parser);
            preprocessor.setActualLexer(lexer);
            preprocessor.setParser(parser);
        } else {
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            parser = new Ttcn3Parser((TokenStream)tokenStream);
            parser.enableOop(oopEnabled);
            ParserUtilities.setBuildParseTree(parser);
        }
        if (aEclipseFile != null) {
            lexer.setActualFile(aEclipseFile);
            parser.setActualFile(aEclipseFile);
            parser.setProject(aEclipseFile.getProject());
        }
        parser.removeErrorListeners();
        TitanListener parserListener = new TitanListener();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        DFA[] decisionToDFA = ((ParserATNSimulator)parser.getInterpreter()).decisionToDFA;
        parser.setInterpreter((ATNSimulator)new ParserATNSimulator((Parser)parser, parser.getATN(), decisionToDFA, new PredictionContextCache()));
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            Ttcn3Parser.Pr_TTCN3FileContext root = parser.pr_TTCN3File();
            ParserUtilities.logParseTree((ParseTree)root, parser);
            this.warningsAndErrors = parser.getWarningsAndErrors();
            this.warningsAndErrors.addAll(lexer.getWarningsAndErrors());
            this.mErrorsStored = lexerListener.getErrorsStored();
            this.mErrorsStored.addAll(parserListener.getErrorsStored());
        }
        catch (RecognitionException root) {
            // empty catch block
        }
        if (!this.warningsAndErrors.isEmpty() || !this.mErrorsStored.isEmpty()) {
            try {
                UnbufferedCharStream charStream2 = new UnbufferedCharStream(aReader);
                lexer.setInputStream((IntStream)charStream2);
                parser.reset();
                parserListener.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                Ttcn3Parser.Pr_TTCN3FileContext root = parser.pr_TTCN3File();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                this.warningsAndErrors = parser.getWarningsAndErrors();
                this.warningsAndErrors.addAll(lexer.getWarningsAndErrors());
                this.mErrorsStored = lexerListener.getErrorsStored();
                this.mErrorsStored.addAll(parserListener.getErrorsStored());
            }
            catch (RecognitionException recognitionException) {
                // empty catch block
            }
        }
        this.unsupportedConstructs = parser.getUnsupportedConstructs();
        this.rootInterval = lexer.getRootInterval();
        this.actualTtc3Module = parser.getModule();
        if (preprocessor != null) {
            this.mErrorsStored.addAll(preprocessor.getErrorStorage());
            this.warningsAndErrors.addAll(preprocessor.getWarnings());
            this.unsupportedConstructs.addAll(preprocessor.getUnsupportedConstructs());
            if (this.actualTtc3Module != null) {
                this.actualTtc3Module.setIncludedFiles(preprocessor.getIncludedFiles());
                this.actualTtc3Module.setInactiveCodeLocations(preprocessor.getInactiveCodeLocations());
            }
        }
        try {
            aReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void md5_parser(IFile aFile, String aCode, TTCN3Module actualTtc3Module) {
        Reader reader;
        if (aCode != null) {
            reader = new StringReader(aCode);
        } else {
            if (aFile != null) {
                try {
                    InputStreamReader temp = new InputStreamReader(aFile.getContents());
                    if (!aFile.getCharset().equals(temp.getEncoding())) {
                        try {
                            temp.close();
                        }
                        catch (IOException e) {
                            ErrorReporter.logWarningExceptionStackTrace((Exception)e);
                        }
                        temp = new InputStreamReader(aFile.getContents(), aFile.getCharset());
                    }
                    reader = new BufferedReader(temp);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    return;
                }
                catch (UnsupportedEncodingException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    return;
                }
            }
            return;
        }
        TTCN3Module actualModule = actualTtc3Module;
        if (actualModule == null) {
            actualModule = (TTCN3Module)GlobalParser.getProjectSourceParser(aFile.getProject()).containedModule(aFile);
        }
        TTCN3Analyzer.md5_processing(reader, aFile, actualModule);
    }

    private static void md5_processing(Reader aReader, IFile aEclipseFile, TTCN3Module actualTtc3Module) {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean realtimeEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableRealtimeExtension", false, null);
        boolean oopEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableOOPExtension", false, null);
        UnbufferedCharStream charStream = new UnbufferedCharStream(aReader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.removeErrorListeners();
        lexer.enableOop(oopEnabled);
        lexer.setCommentTodo(true);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        if (realtimeEnabled) {
            lexer.enableRealtime();
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        PreprocessedTokenStream preprocessor = null;
        if (aEclipseFile != null && "ttcnpp".equals(aEclipseFile.getFileExtension())) {
            lexer.setTTCNPP();
            preprocessor = new PreprocessedTokenStream((TokenSource)lexer);
            preprocessor.setActualFile(aEclipseFile);
            if (aEclipseFile.getProject() != null) {
                preprocessor.setMacros(PreprocessorSymbolsOptionsData.getTTCN3PreprocessorDefines(aEclipseFile.getProject()));
            }
            Ttcn3Parser parser = new Ttcn3Parser((TokenStream)preprocessor);
            parser.enableOop(oopEnabled);
            ParserUtilities.setBuildParseTree(parser);
            preprocessor.setActualLexer(lexer);
            preprocessor.setParser(parser);
            List tokens = preprocessor.get(0, preprocessor.size());
            for (Token token : tokens) {
                if (token.getChannel() == 1) continue;
                String text = token.getText();
                md5.update(text.getBytes());
                md5.update(" ".getBytes());
            }
        } else {
            List tokens = lexer.getAllTokens();
            for (Token token : tokens) {
                if (token.getChannel() == 1) continue;
                String text = token.getText();
                md5.update(text.getBytes());
                md5.update(" ".getBytes());
            }
        }
        if (md5 != null) {
            byte[] digest = md5.digest();
            if (actualTtc3Module != null) {
                actualTtc3Module.addMD5Digest(digest);
            }
        }
        try {
            aReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

