/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocator;
import org.eclipse.titan.designer.wizards.NewTITANProjectWizard;

public final class NewTITANProjectOptionsWizardPage
extends WizardPage {
    private static final String SOURCEDIR_TOOLTIP = "The folder in which you want to save the sources of this project";
    private static final String WORKINGDIR_TOOLTIP = "The folder in which you want all build operations to run.\nPlease note, that all files in the working directory are assumed to be generated, and will not be analyzed on-the-fly.";
    private static final String TITLE = "TITAN settings";
    private static final String DESCRIPTION = "Define the main TITAN folders";
    private static final String WORKINGDIR_EMPTY = "The name of the working directory folder must be filled out";
    private static final String SOURCEWORKSAME = "The source and the working directory can not be the same";
    private Composite pageComposite;
    private Text sourceText;
    private Button excludeFromBuildButton;
    private boolean isExcludedFromBuildSelected = false;
    private TITANResourceLocator workingDirectory;
    private String sourceFolder = "src";
    private String workingFolder = "bin";
    private final BasicProjectSelectorListener generalListener = new BasicProjectSelectorListener();

    public NewTITANProjectOptionsWizardPage() {
        super(TITLE);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getTitle() {
        return TITLE;
    }

    public void dispose() {
        this.pageComposite.dispose();
        super.dispose();
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public boolean isExcludeFromBuildSelected() {
        return this.isExcludedFromBuildSelected;
    }

    public String getWorkingFolder() {
        return this.workingFolder;
    }

    public void createControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        Label sourceLabel = new Label(this.pageComposite, 0);
        sourceLabel.setText("source folder:");
        sourceLabel.setLayoutData((Object)new GridData(32));
        sourceLabel.setToolTipText(SOURCEDIR_TOOLTIP);
        this.sourceText = new Text(this.pageComposite, 2052);
        this.sourceText.setLayoutData((Object)new GridData(768));
        this.sourceText.setText(this.sourceFolder);
        this.sourceText.setToolTipText(SOURCEDIR_TOOLTIP);
        this.sourceText.addModifyListener((ModifyListener)this.generalListener);
        this.excludeFromBuildButton = new Button(this.pageComposite, 32);
        this.excludeFromBuildButton.setText("The source folder should be generated as excluded from build");
        this.excludeFromBuildButton.setToolTipText("Useful if the set up of the project takes a long time, and so the project should not be analyzed by default.");
        this.excludeFromBuildButton.setEnabled(true);
        this.excludeFromBuildButton.setSelection(false);
        this.isExcludedFromBuildSelected = false;
        this.excludeFromBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTITANProjectOptionsWizardPage.this.isExcludedFromBuildSelected = NewTITANProjectOptionsWizardPage.this.excludeFromBuildButton.getSelection();
            }
        });
        Composite workingDirComposite = new Composite(this.pageComposite, 0);
        layout = new GridLayout();
        workingDirComposite.setLayout((Layout)layout);
        data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        workingDirComposite.setLayoutData((Object)data);
        IPath projectPath = ((NewTITANProjectWizard)this.getWizard()).getProjectPath();
        this.workingDirectory = new TITANResourceLocator("working directory:", workingDirComposite, 2, projectPath.toOSString());
        this.workingDirectory.setStringValue("bin");
        this.workingDirectory.getTextControl(workingDirComposite).setToolTipText(WORKINGDIR_TOOLTIP);
        this.workingDirectory.addModifyListener((ModifyListener)this.generalListener);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setControl((Control)this.pageComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IPath location = ((NewTITANProjectWizard)this.getWizard()).getProjectPath();
        if (location == null) {
            return;
        }
        IPath projectPath = ((NewTITANProjectWizard)this.getWizard()).getProjectPath();
        this.workingDirectory.setRootPath(projectPath.toOSString());
    }

    public boolean isPageComplete() {
        if (!this.validatePage()) {
            return false;
        }
        return super.isPageComplete();
    }

    private boolean validatePage() {
        IStatus nameStatus;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String sourceName = this.sourceText.getText();
        if (!"".equals(sourceName) && !(nameStatus = workspace.validateName(sourceName, 2)).isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String workName = this.workingDirectory.getStringValue();
        if ("".equals(workName)) {
            this.setErrorMessage(WORKINGDIR_EMPTY);
            return false;
        }
        if (sourceName.equals(workName)) {
            this.setErrorMessage(SOURCEWORKSAME);
            return false;
        }
        this.sourceFolder = sourceName;
        this.workingFolder = workName;
        this.setErrorMessage(null);
        return true;
    }

    private final class BasicProjectSelectorListener
    implements ModifyListener {
        private BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            boolean valid = NewTITANProjectOptionsWizardPage.this.validatePage();
            NewTITANProjectOptionsWizardPage.this.setPageComplete(valid);
        }
    }
}

