/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.properties.FieldEditorPropertyPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class ExecutorPreferencePage
extends FieldEditorPropertyPage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor setLogFolder;
    private StringFieldEditor logFolderPath;
    private BooleanFieldEditor deleteLogFiles;
    private BooleanFieldEditor automaticMerge;

    public ExecutorPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        super.initialize();
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.setLogFolder = new BooleanFieldEditor("setLogFolder", "Set the default log folder. Can be overriden by the logging section of the config file.", parent);
        this.addField((FieldEditor)this.setLogFolder);
        this.logFolderPath = new StringFieldEditor("logFolderPath", "Path of the log folder. Relative to the working directory.", StringFieldEditor.UNLIMITED, parent);
        this.addField((FieldEditor)this.logFolderPath);
        this.deleteLogFiles = new BooleanFieldEditor("deleteLogFiles", "Delete log files before execution.", parent);
        this.addField((FieldEditor)this.deleteLogFiles);
        this.automaticMerge = new BooleanFieldEditor("automaticMergeEnabled", "Merge the log files after test execution.", parent);
        this.addField((FieldEditor)this.automaticMerge);
    }

    @Override
    protected void updateFieldEditors() {
        Composite fieldEditorParent = this.getFieldEditorParent();
        if (this.isPropertyPage() && !this.isProjectSettingsSelected()) {
            for (FieldEditor editor : this.getFieldEditors()) {
                editor.setEnabled(false, fieldEditorParent);
            }
            return;
        }
        this.setLogFolder.setEnabled(true, fieldEditorParent);
        boolean setLogFolderValue = this.setLogFolder.getBooleanValue();
        this.logFolderPath.setEnabled(setLogFolderValue, fieldEditorParent);
        this.deleteLogFiles.setEnabled(setLogFolderValue, fieldEditorParent);
        this.automaticMerge.setEnabled(setLogFolderValue, fieldEditorParent);
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.titan.executor");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.setLogFolder) {
            this.updateFieldEditors();
        }
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.executor.preferences.ExecutorPreferencePage";
    }

    public IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

