/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.menus;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Deque;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.common.CustomVisualizationViewer;
import org.eclipse.titanium.graph.utils.CheckDependentNodes;
import org.eclipse.titanium.graph.utils.CheckParallelPaths;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.utils.LocationHighlighter;

public class NodePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    protected NodeDescriptor node;
    protected final GraphHandler handler;
    protected final JMenuItem goToDefinition = new JMenuItem("Go to definition");

    public NodePopupMenu(GraphHandler handler) {
        this.node = null;
        JMenuItem selectNode = new JMenuItem("Select node");
        JMenuItem getParalellPaths = new JMenuItem("Search paralell paths");
        JMenuItem getDependentNodes = new JMenuItem("Show dependent nodes");
        final NodePopupMenu thisPopUpMenu = this;
        this.handler = handler;
        selectNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomVisualizationViewer actVisualisator = thisPopUpMenu.handler.getVisualizator();
                if (actVisualisator == null) {
                    return;
                }
                Layout tmpLayout = actVisualisator.getGraphLayout();
                if (tmpLayout == null) {
                    return;
                }
                Graph g = tmpLayout.getGraph();
                if (g == null) {
                    return;
                }
                if (NodePopupMenu.this.node == null) {
                    ErrorReporter.logError((String)"null node attribute for NodePopupMenu");
                    return;
                }
                actVisualisator.getPickedVertexState().clear();
                actVisualisator.getPickedVertexState().pick((Object)NodePopupMenu.this.node, true);
                actVisualisator.getPickedEdgeState().clear();
                for (EdgeDescriptor edge : g.getIncidentEdges((Object)NodePopupMenu.this.node)) {
                    actVisualisator.getPickedEdgeState().pick((Object)edge, true);
                }
            }
        });
        getParalellPaths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final CustomVisualizationViewer actVisualisator = thisPopUpMenu.handler.getVisualizator();
                if (actVisualisator == null) {
                    return;
                }
                Layout tmpLayout = actVisualisator.getGraphLayout();
                if (tmpLayout == null) {
                    return;
                }
                if (NodePopupMenu.this.node == null) {
                    ErrorReporter.logError((String)"null node attribute for NodePopupMenu");
                    return;
                }
                final Graph g = tmpLayout.getGraph();
                Job searchJob = new Job("Searching for parallel paths..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        CheckParallelPaths checker = new CheckParallelPaths(g, NodePopupMenu.this.node);
                        if (checker.hasParallelPaths()) {
                            for (Deque list : checker.getPaths()) {
                                for (EdgeDescriptor edge : list) {
                                    edge.setColour(NodeColours.DARK_RED);
                                }
                            }
                        }
                        actVisualisator.repaint();
                        return Status.OK_STATUS;
                    }
                };
                searchJob.schedule();
            }
        });
        getDependentNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeDescriptor neighbor;
                CustomVisualizationViewer actVisualisator = thisPopUpMenu.handler.getVisualizator();
                if (actVisualisator == null) {
                    return;
                }
                Layout tmpLayout = actVisualisator.getGraphLayout();
                if (tmpLayout == null) {
                    return;
                }
                Graph graph = tmpLayout.getGraph();
                if (graph == null) {
                    return;
                }
                if (NodePopupMenu.this.node == null) {
                    ErrorReporter.logError((String)"null node attribute for NodePopupMenu");
                    return;
                }
                actVisualisator.getPickedVertexState().clear();
                actVisualisator.getPickedVertexState().pick((Object)NodePopupMenu.this.node, true);
                actVisualisator.getPickedEdgeState().clear();
                CheckDependentNodes cdn = new CheckDependentNodes(graph);
                ArrayList<NodeDescriptor> neighbors = new ArrayList<NodeDescriptor>();
                ArrayList<NodeDescriptor> dependentNodes = new ArrayList<NodeDescriptor>();
                neighbors.add(NodePopupMenu.this.node);
                dependentNodes.add(NodePopupMenu.this.node);
                while (!neighbors.isEmpty()) {
                    NodeDescriptor neighbor2 = (NodeDescriptor)neighbors.get(0);
                    ArrayList edges2 = new ArrayList(graph.getOutEdges((Object)neighbor2));
                    for (EdgeDescriptor edge : edges2) {
                        NodeDescriptor vertex = (NodeDescriptor)graph.getDest((Object)edge);
                        if (dependentNodes.contains(vertex)) continue;
                        neighbors.add(vertex);
                        dependentNodes.add(vertex);
                    }
                    neighbors.remove(0);
                }
                int index = dependentNodes.size() - 1;
                boolean changed = true;
                while (changed) {
                    changed = false;
                    for (index = dependentNodes.size() - 1; index >= 0; --index) {
                        neighbor = (NodeDescriptor)dependentNodes.get(index);
                        if (cdn.isDependent(neighbor, dependentNodes) || neighbor.equals(NodePopupMenu.this.node)) continue;
                        changed = true;
                        dependentNodes.remove(index);
                    }
                }
                for (index = dependentNodes.size() - 1; index >= 0; --index) {
                    neighbor = (NodeDescriptor)dependentNodes.get(index);
                    if (!cdn.isDependent(neighbor, dependentNodes) || neighbor.equals(NodePopupMenu.this.node)) continue;
                    actVisualisator.getPickedVertexState().pick((Object)neighbor, true);
                    ArrayList edges3 = new ArrayList(graph.getInEdges((Object)neighbor));
                    for (EdgeDescriptor edge : edges3) {
                        actVisualisator.getPickedEdgeState().pick((Object)edge, true);
                    }
                    ArrayList edges4 = new ArrayList(graph.getOutEdges((Object)neighbor));
                    for (EdgeDescriptor edge : edges4) {
                        if (!dependentNodes.contains(graph.getDest((Object)edge))) continue;
                        actVisualisator.getPickedEdgeState().pick((Object)edge, true);
                    }
                }
            }
        });
        this.add(selectNode);
        this.add(getParalellPaths);
        this.add(getDependentNodes);
        this.goToDefinition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (NodePopupMenu.this.node != null) {
                            Location loc = NodePopupMenu.this.node.getLocation();
                            if (loc == null || loc instanceof NULL_Location) {
                                return;
                            }
                            LocationHighlighter.jumpToLocation(loc);
                        }
                    }
                });
            }
        });
        this.add(this.goToDefinition);
    }

    protected NodePopupMenu(String label) {
        super(label);
        this.handler = null;
    }

    public void show(NodeDescriptor node, int x, int y) {
        this.node = node;
        super.show((Component)((Object)this.handler.getVisualizator()), x, y);
    }

    public void addEntry(String title, ActionListener listener) {
        JMenuItem newItem = new JMenuItem(title);
        newItem.addActionListener(listener);
        this.add(newItem);
    }

    public void enableGoToDefinition(boolean value) {
        this.goToDefinition.setEnabled(value);
    }
}

