/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.implementation.ReceiveTemplateType;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class AltstepCoverage {
    private AltstepCoverage() {
    }

    private static abstract class Base
    extends BaseModuleCodeSmellSpotter {
        public Base() {
            super(CodeSmellType.ALTSTEP_COVERAGE);
        }

        void addPortsOfComponent(Component_Type comp, Map<Identifier, Set<String>> visiblePorts) {
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            for (Definition def : comp.getComponentBody().getDefinitions()) {
                TypeSet incomingTypes;
                if (!(def instanceof Def_Port)) continue;
                Def_Port portDef = (Def_Port)def;
                Identifier portId = portDef.getIdentifier();
                HashSet<String> receivableTypes = new HashSet<String>();
                Port_Type type = portDef.getType(timestamp);
                if (type != null && (incomingTypes = type.getPortBody().getInMessages()) != null) {
                    int size = incomingTypes.getNofTypes();
                    for (int i = 0; i < size; ++i) {
                        receivableTypes.add(incomingTypes.getTypeByIndex(i).getTypename());
                    }
                }
                visiblePorts.put(portId, receivableTypes);
            }
        }

        void addPortsOfParameterList(FormalParameterList parameters, Map<Identifier, Set<String>> visiblePorts) {
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            for (int i = 0; i < parameters.getNofParameters(); ++i) {
                FormalParameter param = parameters.getParameterByIndex(i);
                Type t = param.getType(timestamp);
                if (t instanceof Referenced_Type) {
                    t = t.getTypeRefdLast(timestamp);
                }
                if (!(t instanceof Port_Type)) continue;
                Port_Type type = (Port_Type)t;
                Identifier portId = param.getIdentifier();
                HashSet<String> receivableTypes = new HashSet<String>();
                TypeSet incomingTypes = type.getPortBody().getInMessages();
                if (incomingTypes == null) continue;
                for (int j = 0; j < incomingTypes.getNofTypes(); ++j) {
                    receivableTypes.add(incomingTypes.getTypeByIndex(j).getTypename());
                }
                visiblePorts.put(portId, receivableTypes);
            }
        }

        void removeHandledByGuards(AltGuards guards, Map<Identifier, Set<String>> visiblePorts) {
            ArrayList<Identifier> ports = new ArrayList<Identifier>();
            ports.addAll(visiblePorts.keySet());
            for (int i = 0; i < guards.getNofAltguards(); ++i) {
                Set<String> receiveFromPort;
                Operation_Altguard opAg;
                Statement action;
                AltGuard ag = guards.getAltguardByIndex(i);
                if (!(ag instanceof Operation_Altguard) || !((action = (opAg = (Operation_Altguard)ag).getGuardStatement()) instanceof Receive_Port_Statement)) continue;
                Receive_Port_Statement receive = (Receive_Port_Statement)action;
                ReceiveTemplateType typeVisitor = new ReceiveTemplateType();
                receive.accept((ASTVisitor)typeVisitor);
                if (receive.getPort() == null) {
                    if (typeVisitor.getReceivable() == null) {
                        visiblePorts.clear();
                        continue;
                    }
                    for (Set<String> receiveFromPort2 : visiblePorts.values()) {
                        receiveFromPort2.remove(typeVisitor.getReceivable().getTypename());
                    }
                    continue;
                }
                ports.remove(receive.getPort().getId());
                if (typeVisitor.getReceivable() == null) {
                    receiveFromPort = visiblePorts.get(receive.getPort().getId());
                    if (receiveFromPort == null) continue;
                    receiveFromPort.clear();
                    continue;
                }
                receiveFromPort = visiblePorts.get(receive.getPort().getId());
                if (receiveFromPort == null) continue;
                receiveFromPort.remove(typeVisitor.getReceivable().getTypename());
            }
            for (Identifier unusedPorts : ports) {
                visiblePorts.remove(unusedPorts);
            }
        }

        void handleRemainingPorts(String prepend, Location reportAt, Map<Identifier, Set<String>> visiblePorts, BaseCodeSmellSpotter.Problems problems) {
            Iterator<Map.Entry<Identifier, Set<String>>> it = visiblePorts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Identifier, Set<String>> entry = it.next();
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
            if (!visiblePorts.isEmpty()) {
                StringBuilder sb = new StringBuilder(prepend);
                sb.append(" Unhandled cases:\n");
                for (Map.Entry<Identifier, Set<String>> entry : visiblePorts.entrySet()) {
                    sb.append("port " + entry.getKey().getDisplayName() + ": ");
                    Iterator<String> typeIt = entry.getValue().iterator();
                    if (typeIt.hasNext()) {
                        sb.append(typeIt.next());
                    }
                    while (typeIt.hasNext()) {
                        sb.append(", ").append(typeIt.next());
                    }
                    sb.append('\n');
                }
                problems.report(reportAt, sb.toString());
            }
        }
    }

    public static class OnAltStatement
    extends Base {
        private static final String NOT_COVERED = "This alt statement does not handle all possible incoming message types.";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (node instanceof Alt_Statement) {
                Component_Type runsOn;
                Alt_Statement alt = (Alt_Statement)node;
                HashMap<Identifier, Set<String>> visiblePorts = new HashMap<Identifier, Set<String>>();
                RunsOnScope runsOnScope = alt.getMyScope().getScopeRunsOn();
                if (runsOnScope != null && (runsOn = runsOnScope.getComponentType()) != null) {
                    this.addPortsOfComponent(runsOn, visiblePorts);
                }
                Definition parentDef = alt.getMyStatementBlock().getMyDefinition();
                FormalParameterList parameters = null;
                if (parentDef instanceof Def_Function) {
                    parameters = ((Def_Function)parentDef).getFormalParameterList();
                } else if (parentDef instanceof Def_Testcase) {
                    parameters = ((Def_Testcase)parentDef).getFormalParameterList();
                } else if (parentDef instanceof Def_Altstep) {
                    parameters = ((Def_Altstep)parentDef).getFormalParameterList();
                }
                if (parameters != null) {
                    this.addPortsOfParameterList(parameters, visiblePorts);
                }
                this.removeHandledByGuards(alt.getAltGuards(), visiblePorts);
                this.handleRemainingPorts(NOT_COVERED, alt.getLocation(), visiblePorts, problems);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Alt_Statement.class);
            return ret;
        }
    }

    public static class OnAltstep
    extends Base {
        private static final String NOT_COVERED = "This altstep does not handle all possible incoming message types.";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (node instanceof Def_Altstep) {
                FormalParameterList parameters;
                Def_Altstep alt = (Def_Altstep)node;
                HashMap<Identifier, Set<String>> visiblePorts = new HashMap<Identifier, Set<String>>();
                CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
                Component_Type runsOn = alt.getRunsOnType(timestamp);
                if (runsOn != null) {
                    this.addPortsOfComponent(runsOn, visiblePorts);
                }
                if ((parameters = alt.getFormalParameterList()) != null) {
                    this.addPortsOfParameterList(parameters, visiblePorts);
                }
                this.removeHandledByGuards(alt.getAltGuards(), visiblePorts);
                this.handleRemainingPorts(NOT_COVERED, alt.getIdentifier().getLocation(), visiblePorts, problems);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Def_Altstep.class);
            return ret;
        }
    }
}

