/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.preferences.PreferenceConstants;

public class ConsecutiveAssignments
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Consecutive assignments should be merged into one assignment.";
    private final int minCountToMark = Platform.getPreferencesService().getInt("org.eclipse.titanium", PreferenceConstants.TOO_MANY_CONSECUTIVE_ASSIGNMENTS_SIZE, 4, null);
    private static final int DEFAULT_MIN_COUNT_TO_MARK = 4;

    public ConsecutiveAssignments() {
        super(CodeSmellType.CONSECUTIVE_ASSIGNMENTS);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof StatementBlock)) {
            return;
        }
        CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
        int count = 0;
        boolean limitReached = false;
        Location smellLoc = null;
        Assignment_Statement lastAs = null;
        Assignment toMatch = null;
        StatementBlock sb = (StatementBlock)node;
        for (int i = 0; i < sb.getSize(); ++i) {
            Statement s = sb.getStatementByIndex(i);
            if (!(s instanceof Assignment_Statement)) {
                if (limitReached) {
                    smellLoc.setEndOffset(lastAs.getLocation().getEndOffset());
                    problems.report(smellLoc, ERROR_MESSAGE);
                    limitReached = false;
                }
                count = 0;
                toMatch = null;
                continue;
            }
            Assignment_Statement as = (Assignment_Statement)s;
            Reference ref = as.getReference();
            Assignment a = ref.getRefdAssignment(timestamp, false);
            if (a == null) {
                if (limitReached) {
                    smellLoc.setEndOffset(lastAs.getLocation().getEndOffset());
                    problems.report(smellLoc, ERROR_MESSAGE);
                    limitReached = false;
                }
                count = 0;
                toMatch = null;
                continue;
            }
            if (toMatch == null) {
                toMatch = a;
            } else if (toMatch != a) {
                if (limitReached) {
                    smellLoc.setEndOffset(lastAs.getLocation().getEndOffset());
                    problems.report(smellLoc, ERROR_MESSAGE);
                    limitReached = false;
                }
                count = 0;
                toMatch = a;
            }
            if (count == 0) {
                smellLoc = new Location(as.getLocation());
            }
            lastAs = as;
            if (++count < this.minCountToMark) continue;
            limitReached = true;
        }
        if (limitReached) {
            smellLoc.setEndOffset(lastAs.getLocation().getEndOffset());
            problems.report(smellLoc, ERROR_MESSAGE);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(StatementBlock.class);
        return ret;
    }
}

