/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.definition;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.refactoring.definition.DependencyCollector;
import org.eclipse.titanium.refactoring.definition.SelectionFinder;

public class ExtractDefinitionRefactoring {
    public static final boolean ENABLE_COPY_COMMENTS = false;
    private final IProject sourceProj;
    private IProject targetProj;
    private final Definition selection;
    private Map<IPath, StringBuilder> copyMap;
    private List<IFile> filesToCopy;

    ExtractDefinitionRefactoring() {
        SelectionFinder sf = new SelectionFinder();
        sf.perform();
        this.selection = sf.getSelection();
        this.sourceProj = sf.getSourceProj();
    }

    ExtractDefinitionRefactoring(IProject sourceProj, Definition selection) {
        this.selection = selection;
        this.sourceProj = sourceProj;
    }

    public String getName() {
        return "Extract definition";
    }

    public Definition getSelection() {
        return this.selection;
    }

    public IProject getSourceProject() {
        return this.sourceProj;
    }

    public void setTargetProject(IProject targetProj) {
        this.targetProj = targetProj;
    }

    private RefactoringStatus checkInitialConditions() {
        RefactoringStatus result = new RefactoringStatus();
        if (this.selection == null) {
            result.addError("Selection is not a definition (selection is null)! ");
        }
        if (this.targetProj == null) {
            result.addError("Target project is null! ");
        }
        return result;
    }

    public void perform() {
        RefactoringStatus rs = this.checkInitialConditions();
        if (!rs.hasError()) {
            try {
                DependencyCollector dc = new DependencyCollector(this.selection);
                WorkspaceJob job1 = dc.readDependencies();
                job1.join();
                this.copyMap = dc.getCopyMap();
                this.filesToCopy = dc.getFilesToCopy();
                WorkspaceJob job2 = this.createChange();
                job2.join();
            }
            catch (InterruptedException ie) {
                ErrorReporter.logExceptionStackTrace((Exception)ie);
            }
        } else {
            ErrorReporter.logError((String)"Initial conditions are not fulfilled for the ExtractDefinition operation");
        }
    }

    private WorkspaceJob createChange() {
        WorkspaceJob job = new WorkspaceJob("ExtractDefinition: writing to target project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (ExtractDefinitionRefactoring.this.copyMap == null) {
                    ErrorReporter.logError((String)"ExtractDefinition::createChange(): Reading dependencies did not finish.");
                    return Status.CANCEL_STATUS;
                }
                if (ExtractDefinitionRefactoring.this.filesToCopy == null) {
                    ErrorReporter.logError((String)"ExtractDefinition::createChange(): Reading dependencies did not finish (2).");
                    return Status.CANCEL_STATUS;
                }
                for (Map.Entry e : ExtractDefinitionRefactoring.this.copyMap.entrySet()) {
                    IFile targetFile = ExtractDefinitionRefactoring.this.createFile((IPath)e.getKey());
                    if (targetFile == null) {
                        ErrorReporter.logError((String)("Unable to create file `" + e.getKey() + "' while extracting a definition."));
                        return Status.CANCEL_STATUS;
                    }
                    TextFileChange change = new TextFileChange("extract_append", targetFile);
                    MultiTextEdit rootEdit = new MultiTextEdit();
                    change.setEdit((TextEdit)rootEdit);
                    InsertEdit edit = new InsertEdit(0, ((StringBuilder)e.getValue()).toString());
                    rootEdit.addChild((TextEdit)edit);
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
                for (IFile f : ExtractDefinitionRefactoring.this.filesToCopy) {
                    if (ExtractDefinitionRefactoring.this.copyFile(f) != null) continue;
                    ErrorReporter.logError((String)("Unable to copy file `" + (f == null ? "null" : f.getProjectRelativePath()) + "' while extracting a definition."));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private IFile createFile(IPath relativePath) {
        IFile ret = this.targetProj.getFile(relativePath);
        if (!ret.exists()) {
            try {
                this.createTargetFolderHierarchy(ret);
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                ret.create((InputStream)source, 0, null);
            }
            catch (CoreException ce) {
                return null;
            }
        }
        return ret;
    }

    private IFile copyFile(IFile toCopy) {
        IFile newFile = this.targetProj.getFile(toCopy.getProjectRelativePath());
        try {
            this.createTargetFolderHierarchy(newFile);
            IPath relPath = toCopy.getProjectRelativePath();
            toCopy.copy(this.targetProj.getFile(relPath).getFullPath(), true, null);
        }
        catch (CoreException ce) {
            return null;
        }
        return toCopy;
    }

    private void createTargetFolderHierarchy(IFile file) throws CoreException {
        LinkedList<IFolder> folders = new LinkedList<IFolder>();
        for (IContainer parent = file.getParent(); parent != null && parent instanceof IFolder; parent = parent.getParent()) {
            folders.add(0, (IFolder)parent);
        }
        for (IFolder f : folders) {
            if (f.exists()) continue;
            f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

